/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFor;
import com.sun.enterprise.deployment.archivist.ExtensionsArchivist;
import com.sun.enterprise.deployment.io.AppClientDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.runtime.AppClientRuntimeDDFile;
import com.sun.enterprise.deployment.io.runtime.GFAppClientRuntimeDDFile;
import com.sun.enterprise.deployment.util.AppClientValidator;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.SAXException;

@Service
@PerLookup
@ArchivistFor(value="car")
public class AppClientArchivist
extends Archivist<ApplicationClientDescriptor> {
    public static final Attributes.Name GLASSFISH_APPCLIENT = new Attributes.Name("GlassFish-AppClient");
    public static final Attributes.Name GLASSFISH_CLIENT_PU_SCAN_TARGETS_NAME = new Attributes.Name("GlassFish-Client-PersistenceUnit-Scan-Targets");
    public static final Attributes.Name GLASSFISH_GROUP_FACADE = new Attributes.Name("GlassFish-Group-Facade");
    public static final Attributes.Name GLASSFISH_ANCHOR_DIR = new Attributes.Name("GlassFish-Anchor");
    private String mainClassNameToRun = null;

    public AppClientArchivist() {
        this.handleRuntimeInfo = true;
    }

    @Override
    public ArchiveType getModuleType() {
        return DOLUtils.carType();
    }

    public ApplicationClientDescriptor open(ReadableArchive archive, String mainClassNameToRun) throws IOException, SAXException {
        this.mainClassNameToRun = mainClassNameToRun;
        return (ApplicationClientDescriptor)super.open(archive);
    }

    @Override
    public void setDescriptor(Application application) {
        Set<ApplicationClientDescriptor> appClientBundles = application.getBundleDescriptors(ApplicationClientDescriptor.class);
        if (appClientBundles.size() > 0) {
            this.descriptor = appClientBundles.iterator().next();
            if (((ApplicationClientDescriptor)this.descriptor).getModuleDescriptor().isStandalone()) {
                return;
            }
            this.descriptor = null;
        }
        DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.descriptorFailure", new Object[]{this});
        throw new RuntimeException("Error setting descriptor " + this.descriptor + " in " + this);
    }

    @Override
    public DeploymentDescriptorFile<ApplicationClientDescriptor> getStandardDDFile() {
        if (this.standardDD == null) {
            this.standardDD = new AppClientDeploymentDescriptorFile();
        }
        return this.standardDD;
    }

    @Override
    public List<ConfigurationDeploymentDescriptorFile> getConfigurationDDFiles() {
        if (this.confDDFiles == null) {
            this.confDDFiles = new ArrayList();
            this.confDDFiles.add(new GFAppClientRuntimeDDFile());
            this.confDDFiles.add(new AppClientRuntimeDDFile());
        }
        return this.confDDFiles;
    }

    @Override
    public ApplicationClientDescriptor getDefaultBundleDescriptor() {
        ApplicationClientDescriptor appClientDesc = new ApplicationClientDescriptor();
        return appClientDesc;
    }

    @Override
    public void validate(ClassLoader aClassLoader) {
        ClassLoader cl = aClassLoader;
        if (cl == null) {
            cl = this.classLoader;
        }
        if (cl == null) {
            return;
        }
        ((ApplicationClientDescriptor)this.descriptor).setClassLoader(cl);
        ((ApplicationClientDescriptor)this.descriptor).visit(new AppClientValidator());
    }

    @Override
    protected void postStandardDDsRead(ApplicationClientDescriptor descriptor, ReadableArchive archive, Map<ExtensionsArchivist, RootDeploymentDescriptor> extensions) throws IOException {
        super.postStandardDDsRead(descriptor, archive, extensions);
        if (this.mainClassNameToRun == null) {
            Manifest m = archive.getManifest();
            this.mainClassNameToRun = this.getMainClassName(m);
        }
        descriptor.setMainClassName(this.mainClassNameToRun);
    }

    @Override
    protected void postOpen(ApplicationClientDescriptor descriptor, ReadableArchive archive) throws IOException {
        super.postOpen(descriptor, archive);
        this.postValidate(descriptor, archive);
    }

    @Override
    protected void writeContents(ReadableArchive in, WritableArchive out, Vector entriesToSkip) throws IOException {
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        this.manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        this.manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, ((ApplicationClientDescriptor)this.getDescriptor()).getMainClassName());
        super.writeContents(in, out, entriesToSkip);
    }

    public String getMainClassName(Manifest m) {
        if (m != null) {
            return m.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        }
        return null;
    }

    @Override
    protected boolean postHandles(ReadableArchive archive) throws IOException {
        return this.getMainClassName(archive.getManifest()) != null;
    }

    @Override
    protected String getArchiveExtension() {
        return ".jar";
    }
}

