/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgicdi.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.InjectionPoint;
import org.glassfish.osgicdi.OSGiService;
import org.glassfish.osgicdi.ServiceUnavailableException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

class OSGiServiceFactory {
    private static Logger logger = Logger.getLogger(OSGiServiceFactory.class.getPackage().getName());

    OSGiServiceFactory() {
    }

    public static Object getService(InjectionPoint svcInjectionPoint) throws ServiceUnavailableException {
        OSGiService os = (OSGiService)svcInjectionPoint.getAnnotated().getAnnotation(OSGiService.class);
        OSGiServiceFactory.debug("getService " + svcInjectionPoint.getType() + " OS:" + os);
        Object instance = OSGiServiceFactory.createServiceProxy(svcInjectionPoint);
        return instance;
    }

    public static boolean checkServiceAvailability(InjectionPoint svcInjectionPoint) throws ServiceUnavailableException {
        OSGiService os = (OSGiService)svcInjectionPoint.getAnnotated().getAnnotation(OSGiService.class);
        new StaticInvocationHandler(os, svcInjectionPoint);
        return true;
    }

    private static Object createServiceProxy(InjectionPoint svcInjectionPoint) throws ServiceUnavailableException {
        Type serviceType = svcInjectionPoint.getType();
        OSGiService os = (OSGiService)svcInjectionPoint.getAnnotated().getAnnotation(OSGiService.class);
        InvocationHandler proxyInvHndlr = os.dynamic() ? new DynamicInvocationHandler(os, svcInjectionPoint) : new StaticInvocationHandler(os, svcInjectionPoint);
        Object instance = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{(Class)serviceType}, proxyInvHndlr);
        return instance;
    }

    private static Object lookupService(InjectionPoint svcInjectionPoint) throws ServiceUnavailableException {
        Type serviceType = svcInjectionPoint.getType();
        OSGiService os = (OSGiService)svcInjectionPoint.getAnnotated().getAnnotation(OSGiService.class);
        OSGiServiceFactory.debug("lookup service" + serviceType);
        Class<?> annotatedElt = svcInjectionPoint.getMember().getDeclaringClass();
        BundleContext bc = OSGiServiceFactory.getBundleContext(svcInjectionPoint);
        OSGiServiceFactory.debug("creating service tracker for " + ((Class)serviceType).getName() + " using bundle-context:" + bc);
        ServiceTracker st = null;
        try {
            Class svcTypeClazz = (Class)serviceType;
            if (os.serviceCriteria().trim().equals("")) {
                st = new ServiceTracker(bc, svcTypeClazz.getName(), null);
            } else {
                Filter f = bc.createFilter(OSGiServiceFactory.getFilter(svcTypeClazz, os));
                st = new ServiceTracker(bc, f, null);
            }
            st.open();
            Object service = os.waitTimeout() == -1 ? st.getService() : st.waitForService((long)os.waitTimeout());
            OSGiServiceFactory.debug("service obtained from tracker" + service);
            if (service == null) {
                throw new ServiceUnavailableException("Service " + ((Class)serviceType).getName() + " Unavailable", 4, null);
            }
            Object object = service;
            return object;
        }
        catch (InvalidSyntaxException ise) {
            ise.printStackTrace();
            throw new ServiceUnavailableException("Invalid Filter specification", 3, ise);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new ServiceUnavailableException("Service " + ((Class)serviceType).getName() + " Unavailable", 4, e);
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    private static String getFilter(Class serviceType, OSGiService os) {
        String objectClassClause = "(objectClass=" + serviceType.getName() + ")";
        String filter = "(&" + objectClassClause + os.serviceCriteria() + ")";
        OSGiServiceFactory.debug("filter = " + filter);
        return filter;
    }

    public static void ungetService(Object serviceInstance, InjectionPoint svcInjectionPoint) {
    }

    private static void debug(String debugString) {
        logger.logp(Level.FINE, "OSGiServiceFactory", "debug", "OSGiServiceFactory:: {0}", new Object[]{debugString});
    }

    private static BundleContext getBundleContext(InjectionPoint svcInjectionPoint) {
        Class<?> annotatedElt = svcInjectionPoint.getMember().getDeclaringClass();
        BundleContext bc = null;
        try {
            bc = ((BundleReference)BundleReference.class.cast(annotatedElt.getClassLoader())).getBundle().getBundleContext();
        }
        catch (ClassCastException cce) {
            logger.logp(Level.SEVERE, "OSGiServiceFactory", "getBundleContext", "Expected annotated element {0} to be within an OSGi Bundle.", new Object[]{cce});
            throw cce;
        }
        return bc;
    }

    private static class StaticInvocationHandler
    implements InvocationHandler {
        private final OSGiService os;
        private final InjectionPoint svcInjectionPoint;
        private ServiceReference svcReference = null;
        private BundleContext bundleContext = null;

        public StaticInvocationHandler(OSGiService os, InjectionPoint svcInjectionPoint) {
            OSGiServiceFactory.debug("In StaticInvocationHandler");
            this.os = os;
            this.svcInjectionPoint = svcInjectionPoint;
            this.bundleContext = OSGiServiceFactory.getBundleContext(svcInjectionPoint);
            this.getServiceReference(svcInjectionPoint);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getServiceReference(InjectionPoint svcInjectionPoint) {
            Type serviceType = svcInjectionPoint.getType();
            OSGiServiceFactory.debug("lookup service" + serviceType);
            OSGiServiceFactory.debug("creating service tracker for " + ((Class)serviceType).getName() + " using bundle-context:" + this.bundleContext);
            ServiceTracker st = null;
            try {
                Class svcTypeClazz = (Class)serviceType;
                if (this.os.serviceCriteria().trim().equals("")) {
                    st = new ServiceTracker(this.bundleContext, svcTypeClazz.getName(), null);
                } else {
                    Filter f = this.bundleContext.createFilter(OSGiServiceFactory.getFilter(svcTypeClazz, this.os));
                    st = new ServiceTracker(this.bundleContext, f, null);
                }
                st.open();
                if (this.os.waitTimeout() != -1) {
                    st.waitForService((long)this.os.waitTimeout());
                }
                this.svcReference = st.getServiceReference();
                if (this.svcReference == null) {
                    OSGiServiceFactory.debug("ServiceReference obtained from ServiceTracker is null. No matching services available at this point");
                    this.throwServiceUnavailable();
                }
                OSGiServiceFactory.debug("ServiceReference obtained from tracker:" + this.svcReference);
            }
            catch (InvalidSyntaxException ise) {
                ise.printStackTrace();
                throw new ServiceUnavailableException("Invalid Filter specification", 3, ise);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.throwServiceUnavailable();
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.svcReference != null) {
                Object instanceToUse = this.bundleContext.getService(this.svcReference);
                if (instanceToUse == null) {
                    this.svcReference = null;
                    this.throwServiceUnavailable();
                }
                OSGiServiceFactory.debug("Using the service that was looked up earlier as this is set to DYNAMIC=false");
                OSGiServiceFactory.debug("Calling Method " + method + " on Proxy");
                try {
                    return method.invoke(instanceToUse, args);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() != null) {
                        throw e.getCause();
                    }
                    throw new Throwable(e);
                }
            }
            this.throwServiceUnavailable();
            return null;
        }

        private void throwServiceUnavailable() {
            Type serviceType = this.svcInjectionPoint.getType();
            throw new ServiceUnavailableException("Service " + ((Class)serviceType).getName() + " Unavailable", 4, null);
        }
    }

    private static class DynamicInvocationHandler
    implements InvocationHandler {
        private final OSGiService os;
        private final InjectionPoint svcInjectionPoint;

        public DynamicInvocationHandler(OSGiService os, InjectionPoint svcInjectionPoint) {
            OSGiServiceFactory.debug("In DynamicInvocationHandler");
            this.os = os;
            this.svcInjectionPoint = svcInjectionPoint;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            OSGiServiceFactory.debug("looking a service as this is set to DYNAMIC=true");
            Object instanceToUse = OSGiServiceFactory.lookupService(this.svcInjectionPoint);
            OSGiServiceFactory.debug("calling Method " + method + " on proxy");
            try {
                return method.invoke(instanceToUse, args);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw new Throwable(e);
            }
        }
    }
}

