/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsft.tasks;

import com.sun.jsft.tasks.DefaultTaskManager;
import com.sun.jsft.tasks.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.SystemEventListener;

public abstract class TaskManager {
    private Map<String, Task> tasks = new HashMap<String, Task>(2);
    private static final String TASK_MANAGER = "_jsftTM";
    public static final String IMPL_CLASS = "com.sun.jsft.TASK_MANAGER";

    public abstract void start();

    public static TaskManager getInstance() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        TaskManager taskManager = null;
        Map requestMap = null;
        if (ctx != null) {
            requestMap = ctx.getExternalContext().getRequestMap();
            taskManager = (TaskManager)requestMap.get(TASK_MANAGER);
        }
        if (taskManager == null) {
            Map initParams = ctx.getExternalContext().getInitParameterMap();
            String className = (String)initParams.get(IMPL_CLASS);
            if (className != null) {
                try {
                    taskManager = (TaskManager)Class.forName(className).newInstance();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                taskManager = new DefaultTaskManager();
            }
            if (requestMap != null) {
                requestMap.put(TASK_MANAGER, taskManager);
            }
        }
        return taskManager;
    }

    public static void setTaskManager(TaskManager taskManager) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx == null) {
            throw new RuntimeException("Currently only JSF is supported!  FacesContext not found.");
        }
        ctx.getExternalContext().getRequestMap().put(TASK_MANAGER, taskManager);
    }

    public void addTask(String taskName, String type, SystemEventListener ... newListeners) {
        Task task = this.tasks.get(taskName);
        if (task == null) {
            task = new Task(taskName);
            task.setListeners(type, this.toArrayList(newListeners));
            this.tasks.put(taskName, task);
        } else {
            List<SystemEventListener> taskListeners = task.getListeners(type);
            if (taskListeners == null) {
                task.setListeners(type, this.toArrayList(newListeners));
            } else {
                taskListeners.addAll(this.toArrayList(newListeners));
            }
        }
    }

    public Collection<Task> getTasks() {
        return this.tasks.values();
    }

    private <T> ArrayList<T> toArrayList(T[] arr) {
        ArrayList<T> list = new ArrayList<T>(arr.length);
        for (T item : arr) {
            list.add(item);
        }
        return list;
    }
}

