/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentActivator;
import org.apache.felix.scr.impl.manager.ComponentContainer;
import org.apache.felix.scr.impl.manager.ComponentFactoryImpl;
import org.apache.felix.scr.impl.manager.ComponentHolder;
import org.apache.felix.scr.impl.manager.ComponentManager;
import org.apache.felix.scr.impl.manager.PrototypeServiceFactoryComponentManager;
import org.apache.felix.scr.impl.manager.ServiceFactoryComponentManager;
import org.apache.felix.scr.impl.manager.SingleComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.ServiceMetadata;
import org.apache.felix.scr.impl.metadata.TargetedPID;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.Promises;

public abstract class ConfigurableComponentHolder<S>
implements ComponentHolder<S>,
ComponentContainer<S>,
SimpleLogger {
    private final ComponentActivator m_activator;
    private final ComponentMetadata m_componentMetadata;
    private final TargetedPID[] m_targetedPids;
    private final Long[] m_changeCount;
    private final Map<String, Long> m_factoryChangeCount = new HashMap<String, Long>();
    private volatile Integer m_factoryPidIndex;
    private final Dictionary<String, Object>[] m_configurations;
    private final Map<String, Dictionary<String, Object>> m_factoryConfigurations = new HashMap<String, Dictionary<String, Object>>();
    private final Map<String, TargetedPID> m_factoryTargetedPids = new HashMap<String, TargetedPID>();
    private final Map<String, AbstractComponentManager<S>> m_components;
    private volatile AbstractComponentManager<S> m_singleComponent;
    private volatile boolean m_enabled;
    private final Object enableLock = new Object();
    private volatile Promise<Void> m_enablePromise;
    private volatile Promise<Void> m_disablePromise = Promises.resolved(null);
    private final ComponentMethods m_componentMethods;

    public ConfigurableComponentHolder(ComponentActivator activator, ComponentMetadata metadata) {
        this.m_activator = activator;
        this.m_componentMetadata = metadata;
        int pidCount = metadata.getConfigurationPid().size();
        this.m_targetedPids = new TargetedPID[pidCount];
        this.m_configurations = new Dictionary[pidCount];
        this.m_changeCount = new Long[pidCount];
        this.m_components = new HashMap<String, AbstractComponentManager<S>>();
        this.m_componentMethods = this.createComponentMethods();
        this.m_enabled = false;
    }

    protected abstract ComponentMethods createComponentMethods();

    protected ComponentMethods getComponentMethods() {
        return this.m_componentMethods;
    }

    protected AbstractComponentManager<S> createComponentManager(boolean factoryConfiguration) {
        AbstractComponentManager manager = this.m_componentMetadata.isFactory() ? (!this.m_componentMetadata.isObsoleteFactoryComponentFactory() || !factoryConfiguration ? new ComponentFactoryImpl(this, this.m_componentMethods) : new SingleComponentManager(this, this.m_componentMethods, true)) : (this.m_componentMetadata.getServiceScope() == ServiceMetadata.Scope.bundle ? new ServiceFactoryComponentManager(this, this.m_componentMethods) : (this.m_componentMetadata.getServiceScope() == ServiceMetadata.Scope.prototype ? PSFLoader.newPSFComponentManager(this, this.m_componentMethods) : new SingleComponentManager(this, this.m_componentMethods)));
        return manager;
    }

    @Override
    public final ComponentActivator getActivator() {
        return this.m_activator;
    }

    @Override
    public final ComponentMetadata getComponentMetadata() {
        return this.m_componentMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configurationDeleted(TargetedPID pid, TargetedPID factoryPid) {
        this.log(4, "ImmediateComponentHolder configuration deleted for pid {0}", new Object[]{pid}, null);
        HashMap<AbstractComponentManager<S>, Map<String, Object>> scms = new HashMap<AbstractComponentManager<S>, Map<String, Object>>();
        boolean reconfigure = false;
        Map<String, AbstractComponentManager<S>> map = this.m_components;
        synchronized (map) {
            if (factoryPid != null) {
                this.checkFactoryPidIndex(factoryPid);
                String string = pid.getServicePid();
                this.m_factoryTargetedPids.remove(string);
                this.m_factoryChangeCount.remove(string);
                this.m_factoryConfigurations.remove(string);
                AbstractComponentManager<S> scm = this.m_components.remove(string);
                if (this.m_factoryConfigurations.isEmpty()) {
                    this.m_factoryPidIndex = null;
                }
                if (!this.m_enabled || scm == null) {
                    return;
                }
                boolean bl = reconfigure = this.m_componentMetadata.isConfigurationOptional() && this.m_components.isEmpty();
                if (reconfigure) {
                    this.m_singleComponent = scm;
                    scms.put(scm, this.mergeProperties(null));
                } else {
                    scms.put(scm, null);
                }
            } else {
                int n = this.getSingletonPidIndex(pid);
                this.m_targetedPids[n] = null;
                this.m_changeCount[n] = null;
                this.m_configurations[n] = null;
                if (!this.m_enabled) {
                    return;
                }
                reconfigure = this.m_componentMetadata.isConfigurationOptional();
                if (this.m_factoryPidIndex == null) {
                    if (this.m_singleComponent != null) {
                        if (reconfigure) {
                            scms.put(this.m_singleComponent, this.mergeProperties(null));
                        } else {
                            scms.put(this.m_singleComponent, null);
                            this.m_singleComponent = null;
                        }
                    }
                } else if (reconfigure) {
                    for (Map.Entry<String, AbstractComponentManager<S>> entry : this.m_components.entrySet()) {
                        scms.put(entry.getValue(), this.mergeProperties(entry.getKey()));
                    }
                } else {
                    for (Map.Entry<String, AbstractComponentManager<S>> entry : this.m_components.entrySet()) {
                        scms.put(entry.getValue(), null);
                    }
                    this.m_components.clear();
                }
            }
        }
        for (Map.Entry entry : scms.entrySet()) {
            if (reconfigure) {
                ((AbstractComponentManager)entry.getKey()).reconfigure((Map)entry.getValue(), true, factoryPid);
                continue;
            }
            ((AbstractComponentManager)entry.getKey()).dispose(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean configurationUpdated(TargetedPID pid, TargetedPID factoryPid, Dictionary<String, Object> props, long changeCount) {
        boolean created;
        HashMap<AbstractComponentManager<S>, Map<String, Object>> scms;
        block16: {
            this.log(4, "ConfigurableComponentHolder configuration updated for pid {0} with properties {1} and change count {2}", new Object[]{pid, props, changeCount}, null);
            scms = new HashMap<AbstractComponentManager<S>, Map<String, Object>>();
            created = false;
            Map<String, AbstractComponentManager<S>> map = this.m_components;
            synchronized (map) {
                block19: {
                    block17: {
                        block18: {
                            if (factoryPid == null) break block17;
                            this.checkFactoryPidIndex(factoryPid);
                            Long oldChangeCount = this.m_factoryChangeCount.get(pid.getServicePid());
                            TargetedPID oldTargetedPID = this.m_factoryTargetedPids.get(pid.getServicePid());
                            if (oldChangeCount != null && changeCount <= oldChangeCount && factoryPid.equals(oldTargetedPID)) {
                                return false;
                            }
                            this.m_factoryChangeCount.put(pid.getServicePid(), changeCount);
                            this.m_factoryConfigurations.put(pid.getServicePid(), props);
                            this.m_factoryTargetedPids.put(pid.getServicePid(), factoryPid);
                            if (!this.m_enabled || !this.isSatisfied()) break block18;
                            if (this.m_singleComponent != null && !this.m_componentMetadata.isObsoleteFactoryComponentFactory()) {
                                AbstractComponentManager<S> abstractComponentManager = this.m_singleComponent;
                                scms.put(abstractComponentManager, this.mergeProperties(pid.getServicePid()));
                                this.m_singleComponent = null;
                                this.m_components.put(pid.getServicePid(), abstractComponentManager);
                                break block16;
                            } else if (this.m_components.containsKey(pid.getServicePid())) {
                                scms.put(this.m_components.get(pid.getServicePid()), this.mergeProperties(pid.getServicePid()));
                                break block16;
                            } else {
                                AbstractComponentManager<S> abstractComponentManager = this.createComponentManager(true);
                                this.m_components.put(pid.getServicePid(), abstractComponentManager);
                                scms.put(abstractComponentManager, this.mergeProperties(pid.getServicePid()));
                                created = true;
                            }
                            break block16;
                        }
                        return false;
                    }
                    int index = this.getSingletonPidIndex(pid);
                    if (this.m_changeCount[index] != null && changeCount <= this.m_changeCount[index] && pid.equals(this.m_targetedPids[index])) {
                        return false;
                    }
                    this.m_changeCount[index] = changeCount;
                    this.m_targetedPids[index] = pid;
                    this.m_configurations[index] = props;
                    if (!this.m_enabled || !this.isSatisfied()) break block19;
                    if (this.m_singleComponent != null) {
                        scms.put(this.m_singleComponent, this.mergeProperties(pid.getServicePid()));
                        break block16;
                    } else if (this.m_factoryPidIndex != null) {
                        for (Map.Entry entry : this.m_components.entrySet()) {
                            scms.put((AbstractComponentManager<S>)entry.getValue(), this.mergeProperties((String)entry.getKey()));
                        }
                        break block16;
                    } else {
                        this.m_singleComponent = this.createComponentManager(false);
                        scms.put(this.m_singleComponent, this.mergeProperties(pid.getServicePid()));
                        created = true;
                    }
                    break block16;
                }
                return false;
            }
        }
        boolean enable = created && this.m_enabled;
        Iterator iterator = scms.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ((AbstractComponentManager)entry.getKey()).reconfigure((Map)entry.getValue(), false, factoryPid);
            this.log(4, "ImmediateComponentHolder Finished configuring the dependency managers for component for pid {0} ", new Object[]{pid}, null);
            if (enable) {
                ((AbstractComponentManager)entry.getKey()).enable(false);
                this.log(4, "ImmediateComponentHolder Finished enabling component for pid {0} ", new Object[]{pid}, null);
                continue;
            }
            this.log(4, "ImmediateComponentHolder Will not enable component for pid {0}: holder enabled state: {1}, metadata enabled: {2} ", new Object[]{pid, this.m_enabled, this.m_componentMetadata.isEnabled()}, null);
        }
        return created;
    }

    private Map<String, Object> mergeProperties(String servicePid) {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.m_componentMetadata.getProperties());
        ArrayList<String> pids = null;
        boolean isDS13 = this.m_componentMetadata.getDSVersion().isDS13();
        if (isDS13) {
            pids = new ArrayList<String>();
            if (properties.get("service.pid") instanceof String) {
                pids.add((String)properties.get("service.pid"));
            }
        }
        for (int i = 0; i < this.m_configurations.length; ++i) {
            if (!(this.m_factoryPidIndex == null || i != this.m_factoryPidIndex || this.m_componentMetadata.isObsoleteFactoryComponentFactory() && servicePid == null)) {
                ConfigurableComponentHolder.copyTo(properties, this.m_factoryConfigurations.get(servicePid));
                if (!isDS13) continue;
                pids.add((String)this.m_factoryConfigurations.get(servicePid).get("service.pid"));
                continue;
            }
            if (this.m_configurations[i] == null) continue;
            ConfigurableComponentHolder.copyTo(properties, this.m_configurations[i]);
            if (!isDS13) continue;
            pids.add((String)this.m_configurations[i].get("service.pid"));
        }
        if (isDS13 && !pids.isEmpty()) {
            if (pids.size() == 1) {
                properties.put("service.pid", pids.get(0));
            } else {
                properties.put("service.pid", pids);
            }
        }
        return properties;
    }

    private int getSingletonPidIndex(TargetedPID pid) {
        int index = this.m_componentMetadata.getPidIndex(pid);
        if (index == -1) {
            this.log(1, "Unrecognized pid {0}, expected one of {1}", new Object[]{pid, this.m_componentMetadata.getConfigurationPid()}, null);
            throw new IllegalArgumentException("Unrecognized pid " + pid);
        }
        if (this.m_factoryPidIndex != null && index == this.m_factoryPidIndex) {
            this.log(1, "singleton pid {0} supplied, but matches an existing factory pid at index: {1}", new Object[]{pid, this.m_factoryPidIndex}, null);
            throw new IllegalStateException("Singleton pid supplied matching a previous factory pid " + pid);
        }
        return index;
    }

    private void checkFactoryPidIndex(TargetedPID factoryPid) {
        int index = this.m_componentMetadata.getPidIndex(factoryPid);
        if (index == -1) {
            this.log(1, "Unrecognized factory pid {0}, expected one of {1}", new Object[]{factoryPid, this.m_componentMetadata.getConfigurationPid()}, null);
            throw new IllegalArgumentException("Unrecognized factory pid " + factoryPid);
        }
        if (this.m_configurations[index] != null) {
            this.log(1, "factory pid {0}, but this pid is already supplied as a singleton: {1} at index {2}", new Object[]{factoryPid, Arrays.asList(this.m_targetedPids), index}, null);
            throw new IllegalStateException("Factory pid supplied after all non-factory configurations supplied " + factoryPid);
        }
        if (this.m_factoryPidIndex == null) {
            this.m_factoryPidIndex = index;
        } else if (index != this.m_factoryPidIndex) {
            this.log(1, "factory pid {0} supplied for index {1}, but a factory pid previously supplied at index {2}", new Object[]{factoryPid, index, this.m_factoryPidIndex}, null);
            throw new IllegalStateException("Factory pid supplied at wrong index " + factoryPid);
        }
    }

    protected static void copyTo(Map<String, Object> target, Dictionary<String, ?> source) {
        Enumeration<String> keys = source.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object value = source.get(key);
            target.put(key, value);
        }
    }

    private boolean isSatisfied() {
        if (this.m_componentMetadata.isConfigurationOptional() || this.m_componentMetadata.isConfigurationIgnored()) {
            return true;
        }
        for (int i = 0; i < this.m_componentMetadata.getConfigurationPid().size(); ++i) {
            if (this.m_configurations[i] != null || this.m_factoryPidIndex != null && this.m_factoryPidIndex == i) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends ComponentManager<?>> getComponents() {
        Map<String, AbstractComponentManager<S>> map = this.m_components;
        synchronized (map) {
            return this.getComponentManagers();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    private void wait(Promise<Void> promise) {
        boolean waited = false;
        boolean interrupted = false;
        while (!waited) {
            try {
                promise.getValue();
                waited = true;
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<Void> enableComponents(boolean async) {
        Object object = this.enableLock;
        synchronized (object) {
            if (this.m_enablePromise != null) {
                return this.m_enablePromise;
            }
            this.wait(this.m_disablePromise);
            ArrayList<AbstractComponentManager<S>> cms = new ArrayList<AbstractComponentManager<S>>();
            Map<String, AbstractComponentManager<S>> map = this.m_components;
            synchronized (map) {
                if (this.isSatisfied()) {
                    if (this.m_factoryPidIndex == null || this.m_componentMetadata.isObsoleteFactoryComponentFactory() && !this.m_componentMetadata.isConfigurationRequired()) {
                        this.m_singleComponent = this.createComponentManager(false);
                        cms.add(this.m_singleComponent);
                        this.m_singleComponent.reconfigure(this.mergeProperties(null), false, null);
                    }
                    if (this.m_factoryPidIndex != null) {
                        for (String string : this.m_factoryConfigurations.keySet()) {
                            AbstractComponentManager<S> scm = this.createComponentManager(true);
                            this.m_components.put(string, scm);
                            scm.reconfigure(this.mergeProperties(string), false, new TargetedPID(string));
                            cms.add(scm);
                        }
                    }
                }
                this.m_enabled = true;
            }
            ArrayList promises = new ArrayList();
            for (AbstractComponentManager abstractComponentManager : cms) {
                promises.add(abstractComponentManager.enable(async));
            }
            this.m_enablePromise = new Deferred().resolveWith(Promises.all(promises));
            this.m_disablePromise = null;
            return this.m_enablePromise;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<Void> disableComponents(boolean async) {
        Object object = this.enableLock;
        synchronized (object) {
            List<AbstractComponentManager<S>> cms;
            if (this.m_disablePromise != null) {
                return this.m_disablePromise;
            }
            this.wait(this.m_enablePromise);
            Map<String, AbstractComponentManager<S>> map = this.m_components;
            synchronized (map) {
                this.m_enabled = false;
                cms = this.getDirectComponentManagers();
                this.clearComponents();
            }
            ArrayList promises = new ArrayList();
            for (AbstractComponentManager<S> cm : cms) {
                promises.add(cm.disable(async));
            }
            this.m_disablePromise = new Deferred().resolveWith(Promises.all(promises));
            this.m_enablePromise = null;
            return this.m_disablePromise;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeComponents(int reason) {
        List<AbstractComponentManager<S>> cms;
        Map<String, AbstractComponentManager<S>> map = this.m_components;
        synchronized (map) {
            cms = this.getDirectComponentManagers();
            this.clearComponents();
        }
        for (AbstractComponentManager abstractComponentManager : cms) {
            abstractComponentManager.dispose(reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposed(SingleComponentManager<S> component) {
        Map<String, AbstractComponentManager<S>> map = this.m_components;
        synchronized (map) {
            if (!this.m_components.isEmpty()) {
                Iterator<AbstractComponentManager<S>> vi = this.m_components.values().iterator();
                while (vi.hasNext()) {
                    if (component != vi.next()) continue;
                    vi.remove();
                    break;
                }
            }
            if (component == this.m_singleComponent) {
                this.m_singleComponent = null;
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConfigurableComponentHolder)) {
            return false;
        }
        ConfigurableComponentHolder other = (ConfigurableComponentHolder)object;
        return this.m_activator == other.m_activator && this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return "[ImmediateComponentHolder:" + this.getName() + "]";
    }

    String getName() {
        return this.m_componentMetadata.getName();
    }

    List<AbstractComponentManager<S>> getComponentManagers() {
        ArrayList cms = new ArrayList();
        if (this.m_singleComponent != null) {
            this.m_singleComponent.getComponentManagers(cms);
        }
        for (AbstractComponentManager cm : this.m_components.values()) {
            cm.getComponentManagers(cms);
        }
        return cms;
    }

    List<AbstractComponentManager<S>> getDirectComponentManagers() {
        ArrayList<AbstractComponentManager<S>> cms = new ArrayList<AbstractComponentManager<S>>();
        if (this.m_singleComponent != null) {
            cms.add(this.m_singleComponent);
        }
        cms.addAll(this.m_components.values());
        return cms;
    }

    void clearComponents() {
        this.m_components.clear();
        this.m_singleComponent = null;
    }

    @Override
    public boolean isLogEnabled(int level) {
        ComponentActivator activator = this.getActivator();
        if (activator != null) {
            return activator.isLogEnabled(level);
        }
        return false;
    }

    @Override
    public void log(int level, String message, Throwable ex) {
        ComponentActivator activator = this.getActivator();
        if (activator != null) {
            activator.log(level, message, this.getComponentMetadata(), null, ex);
        }
    }

    @Override
    public void log(int level, String message, Object[] arguments, Throwable ex) {
        ComponentActivator activator = this.getActivator();
        if (activator != null) {
            activator.log(level, message, arguments, this.getComponentMetadata(), null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TargetedPID getConfigurationTargetedPID(TargetedPID pid, TargetedPID factoryPid) {
        if (factoryPid == null) {
            int index = this.m_componentMetadata.getPidIndex(pid);
            if (index != -1) {
                return this.m_targetedPids[index];
            }
            return null;
        }
        Map<String, AbstractComponentManager<S>> map = this.m_components;
        synchronized (map) {
            return this.m_factoryTargetedPids.get(pid.getServicePid());
        }
    }

    private static class PSFLoader {
        private PSFLoader() {
        }

        static <S> AbstractComponentManager<S> newPSFComponentManager(ConfigurableComponentHolder<S> holder, ComponentMethods methods) {
            return new PrototypeServiceFactoryComponentManager<S>(holder, methods);
        }
    }
}

