/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Scanner;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;

public class PropsSanitizer
extends Task {
    private static final String NL = System.getProperty("line.separator", "\n");
    private static final String WARN = "Sanitize process Not run!";
    private ArrayList properties = new ArrayList();
    private boolean quiet;
    private String fileName;

    public void setFile(String propertyFile) {
        this.fileName = propertyFile;
    }

    public void addProperty(Property prop) {
        this.properties.add(prop);
    }

    public void setQuiet(boolean q) {
        this.quiet = q;
    }

    public void execute() throws BuildException {
        Hashtable uProps = this.getProject().getUserProperties();
        Hashtable<String, String> nProps = new Hashtable<String, String>();
        if (this.properties.isEmpty() & uProps.isEmpty()) {
            System.out.println("No Properties specified for replacement!");
        } else {
            if (!this.properties.isEmpty()) {
                for (Property prop : this.properties) {
                    nProps.put(prop.getName().trim(), prop.getValue().trim());
                }
            }
            try {
                String fileContents = this.readFile(this.fileName);
                fileContents = this.changeProp(fileContents, nProps);
                fileContents = this.changeProp(fileContents, uProps);
                this.writeFile(this.fileName, fileContents);
                if (!this.quiet) {
                    System.out.println("DEBUG ==>  Finished Sanitize Process!");
                }
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("WARNING==> No such file: " + this.fileName + NL + WARN);
            }
            catch (IOException ioe) {
                System.out.println("WARNING==> Unable to read in file: " + this.fileName + NL + "Check permissions on file." + NL + WARN);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String fName) throws IOException, FileNotFoundException {
        StringBuilder contents = new StringBuilder();
        Scanner scanner = new Scanner(new FileInputStream(fName));
        scanner.useDelimiter(NL);
        System.out.println("Reading from " + fName + "....");
        try {
            while (scanner.hasNextLine()) {
                String nLine = scanner.nextLine();
                contents.append(nLine + NL);
            }
        }
        finally {
            scanner.close();
        }
        return contents.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String fName, String contents) throws FileNotFoundException, IOException {
        BufferedWriter output = new BufferedWriter(new FileWriter(fName));
        try {
            output.write(contents);
            System.out.println("Changes written to file: " + fName + NL);
        }
        finally {
            ((Writer)output).close();
        }
    }

    private String changeProp(String contents, Hashtable hsProps) {
        StringBuilder output = new StringBuilder();
        Scanner scanner = new Scanner(contents);
        scanner.useDelimiter(NL);
        if (!this.quiet) {
            System.out.println("DEBUG ==>  Starting Sanitize Process!");
        }
        while (scanner.hasNext()) {
            String token = scanner.next();
            Boolean written = false;
            Enumeration keys = hsProps.keys();
            while (keys.hasMoreElements()) {
                String uKey = ((String)keys.nextElement()).trim();
                String uVal = ((String)hsProps.get(uKey)).trim();
                if (!token.startsWith(uKey)) continue;
                output.append(token.replace(token, uKey + "=" + uVal + NL));
                written = true;
                hsProps.remove(uKey);
                System.out.println("Replaced property " + token + " with " + uKey + "=" + uVal);
                break;
            }
            if (written.booleanValue()) continue;
            output.append(token + NL);
        }
        if (!this.quiet && !hsProps.isEmpty()) {
            Enumeration keys = hsProps.keys();
            while (keys.hasMoreElements()) {
                String uKey = ((String)keys.nextElement()).trim();
                String uVal = ((String)hsProps.get(uKey)).trim();
                System.out.println("WARNING==> " + uKey + " Not Found In file " + this.fileName + NL);
            }
        }
        return output.toString();
    }
}

