/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.tools.ResultUtils;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ReportBindResultLDAPConnectionPoolHealthCheck
extends LDAPConnectionPoolHealthCheck {
    private final boolean displaySuccessResultWithControls;
    private final boolean displaySuccessResultWithoutControls;
    private final CommandLineTool tool;
    private final int wrapColumn;

    public ReportBindResultLDAPConnectionPoolHealthCheck(CommandLineTool tool, boolean displaySuccessResultWithControls, boolean displaySuccessResultWithoutControls) {
        this.tool = tool;
        this.displaySuccessResultWithControls = displaySuccessResultWithControls;
        this.displaySuccessResultWithoutControls = displaySuccessResultWithoutControls;
        this.wrapColumn = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    }

    @Override
    public void ensureConnectionValidAfterAuthentication(LDAPConnection connection, BindResult bindResult) throws LDAPException {
        if (bindResult.getResultCode() == ResultCode.SUCCESS) {
            boolean displayResult = bindResult.hasResponseControl() ? this.displaySuccessResultWithControls : this.displaySuccessResultWithoutControls;
            if (displayResult) {
                ArrayList<String> lines = new ArrayList<String>(10);
                lines.add("# " + ToolMessages.INFO_REPORT_BIND_RESULT_HEADER.get());
                ResultUtils.formatResult(lines, bindResult, true, false, 5, this.wrapColumn);
                for (String line : lines) {
                    this.tool.out(line);
                }
                this.tool.out(new Object[0]);
            }
        } else {
            ArrayList<String> lines = new ArrayList<String>(10);
            lines.add("# " + ToolMessages.INFO_REPORT_BIND_RESULT_HEADER.get());
            ResultUtils.formatResult(lines, bindResult, true, false, 0, this.wrapColumn);
            for (String line : lines) {
                this.tool.err(line);
            }
            this.tool.err(new Object[0]);
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ReportBindResultLDAPConnectionPoolHealthCheck(displaySuccessResultWithControls=");
        buffer.append(this.displaySuccessResultWithControls);
        buffer.append(", displaySuccessResultWithoutControls=");
        buffer.append(this.displaySuccessResultWithoutControls);
        buffer.append(')');
    }
}

