/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.exec.MultiFormatPane;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class MusicPane
extends JPanel
implements MultiFormatPane.MediaPane {
    private UIFactory uif;
    private JScrollPane owner;
    private JButton btnStart;
    private JButton btnStop;
    private JButton btnLoop;
    private URL currURL;
    private Clip clip;
    private Sequencer sequencer;

    public MusicPane(UIFactory uif, String uiKey, JScrollPane owner) {
        this.uif = uif;
        this.owner = owner;
        this.initGUI(uiKey);
    }

    private void initGUI(String uiKey) {
        this.setName(uiKey);
        this.uif.setAccessibleInfo(this, uiKey);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.btnStart = this.uif.createButton(uiKey + ".btnStart");
        this.btnStop = this.uif.createButton(uiKey + ".btnStop");
        this.btnLoop = this.uif.createButton(uiKey + ".btnLoop");
        this.add((Component)this.btnStart, gbc);
        this.add((Component)this.btnStop, gbc);
        this.add((Component)this.btnLoop, gbc);
        this.btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MusicPane.isSampledAudioResource(MusicPane.this.currURL)) {
                    MusicPane.this.loadSample(MusicPane.this.currURL);
                    MusicPane.this.clip.start();
                } else if (MusicPane.isMidiAudioResource(MusicPane.this.currURL)) {
                    MusicPane.this.loadSequence(MusicPane.this.currURL);
                    MusicPane.this.sequencer.start();
                }
            }
        });
        this.btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MusicPane.this.stopAudio();
            }
        });
        this.btnLoop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MusicPane.isSampledAudioResource(MusicPane.this.currURL)) {
                    MusicPane.this.loadSample(MusicPane.this.currURL);
                    MusicPane.this.clip.loop(-1);
                }
            }
        });
    }

    public void showAudio(URL url) {
        this.changeURL(url);
        this.owner.setViewportView(this);
        this.owner.revalidate();
        this.owner.repaint();
    }

    @Override
    public void changeURL(URL url) {
        this.currURL = url;
        if (MusicPane.isMidiAudioResource(url)) {
            this.btnLoop.setEnabled(false);
        } else if (MusicPane.isSampledAudioResource(url)) {
            this.btnLoop.setEnabled(true);
        }
    }

    @Override
    public void setParent(JScrollPane owner) {
        this.owner = owner;
    }

    @Override
    public int getMode() {
        return 2;
    }

    public static boolean isAudioResource(URL url) {
        return MusicPane.isSampledAudioResource(url) || MusicPane.isMidiAudioResource(url);
    }

    public void stopAudio() {
        if (this.clip != null && this.clip.isRunning()) {
            this.clip.stop();
            this.clip.flush();
            this.clip.close();
        }
        if (this.sequencer != null && this.sequencer.isRunning()) {
            this.sequencer.stop();
        }
    }

    private void loadSample(URL url) {
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(url);
            AudioFormat format = stream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, stream.getFormat(), (int)stream.getFrameLength() * format.getFrameSize());
            this.clip = (Clip)AudioSystem.getLine(info);
            this.clip.open(stream);
            this.clip.addLineListener(new LineListener(){

                @Override
                public void update(LineEvent e) {
                    if (e.getType() == LineEvent.Type.STOP) {
                        MusicPane.this.clip.stop();
                    }
                }
            });
        }
        catch (Exception e) {
            this.clip.close();
        }
    }

    private void loadSequence(URL url) {
        try {
            Sequence sequence = MidiSystem.getSequence(url);
            this.sequencer = MidiSystem.getSequencer();
            this.sequencer.open();
            this.sequencer.setSequence(sequence);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isSampledAudioResource(URL url) {
        try {
            AudioFileFormat fformat = AudioSystem.getAudioFileFormat(url);
            return AudioSystem.isFileTypeSupported(fformat.getType());
        }
        catch (UnsupportedAudioFileException unsuppExc) {
            return false;
        }
        catch (IOException ioExc) {
            return false;
        }
    }

    private static boolean isMidiAudioResource(URL url) {
        try {
            MidiFileFormat fformat = MidiSystem.getMidiFileFormat(url);
            Sequence sequence = MidiSystem.getSequence(url);
            return MidiSystem.isFileTypeSupported(fformat.getType());
        }
        catch (InvalidMidiDataException invalidDataExc) {
            return false;
        }
        catch (IOException ioExc) {
            return false;
        }
        catch (Exception exc) {
            return false;
        }
    }
}

