/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.incubator.http.Http2Connection;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpRequestImpl;
import jdk.incubator.http.internal.common.Utils;
import jdk.incubator.http.internal.frame.SettingsFrame;

class Http2ClientImpl {
    private final HttpClientImpl client;
    private final Map<String, Http2Connection> connections = new ConcurrentHashMap<String, Http2Connection>();
    private final Set<String> opening = Collections.synchronizedSet(new HashSet());
    private static final int K = 1024;

    Http2ClientImpl(HttpClientImpl httpClientImpl) {
        this.client = httpClientImpl;
    }

    boolean haveConnectionFor(URI uRI, InetSocketAddress inetSocketAddress) {
        return this.connections.containsKey(Http2Connection.keyFor(uRI, inetSocketAddress));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Http2Connection getConnectionFor(HttpRequestImpl httpRequestImpl) throws IOException, InterruptedException {
        InetSocketAddress inetSocketAddress;
        URI uRI = httpRequestImpl.uri();
        String string = Http2Connection.keyFor(uRI, inetSocketAddress = httpRequestImpl.proxy(this.client));
        Http2Connection http2Connection = this.connections.get(string);
        if (http2Connection != null) {
            return http2Connection;
        }
        Set<String> set = this.opening;
        synchronized (set) {
            while ((http2Connection = this.connections.get(string)) == null) {
                if (!httpRequestImpl.secure()) {
                    return null;
                }
                if (!this.opening.contains(string)) {
                    this.opening.add(string);
                    break;
                }
                this.opening.wait();
            }
        }
        if (http2Connection != null) {
            return http2Connection;
        }
        try {
            http2Connection = new Http2Connection(httpRequestImpl, this);
        }
        catch (Throwable throwable) {
            Set<String> set2 = this.opening;
            synchronized (set2) {
                this.opening.remove(string);
                this.opening.notifyAll();
            }
            throw throwable;
        }
        set = this.opening;
        synchronized (set) {
            this.connections.put(string, http2Connection);
            this.opening.remove(string);
            this.opening.notifyAll();
        }
        return http2Connection;
    }

    void putConnection(Http2Connection http2Connection) {
        this.connections.put(http2Connection.key(), http2Connection);
    }

    void deleteConnection(Http2Connection http2Connection) {
        this.connections.remove(http2Connection.key());
    }

    HttpClientImpl client() {
        return this.client;
    }

    String getSettingsString() {
        SettingsFrame settingsFrame = this.getClientSettings();
        byte[] byArray = settingsFrame.toByteArray();
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        return encoder.encodeToString(byArray);
    }

    SettingsFrame getClientSettings() {
        SettingsFrame settingsFrame = new SettingsFrame();
        settingsFrame.setParameter(1, Utils.getIntegerNetProperty("jdk.httpclient.hpack.maxheadertablesize", 16384));
        settingsFrame.setParameter(2, Utils.getIntegerNetProperty("jdk.httpclient.enablepush", 1));
        settingsFrame.setParameter(3, Utils.getIntegerNetProperty("jdk.httpclient.maxstreams", 16));
        settingsFrame.setParameter(4, Utils.getIntegerNetProperty("jdk.httpclient.windowsize", 65535));
        settingsFrame.setParameter(5, Utils.getIntegerNetProperty("jdk.httpclient.maxframesize", 16384));
        return settingsFrame;
    }
}

