/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend2.lib;

import com.google.common.annotations.GwtCompatible;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public class StringConcatenation
implements CharSequence {
    public static final String DEFAULT_LINE_DELIMITER = System.getProperty("line.separator");
    private final List<String> segments;
    private String cachedToString;
    private final String lineDelimiter;

    public StringConcatenation() {
        this(DEFAULT_LINE_DELIMITER);
    }

    public StringConcatenation(String lineDelimiter) {
        if (lineDelimiter == null || lineDelimiter.length() == 0) {
            throw new IllegalArgumentException("lineDelimiter must not be null or empty");
        }
        this.lineDelimiter = lineDelimiter;
        this.segments = new ArrayList<String>(50);
    }

    public void append(Object object) {
        this.append(object, this.segments.size());
    }

    protected void append(Object object, int index) {
        if (object == null) {
            return;
        }
        if (object instanceof StringConcatenation) {
            this.segments.addAll(index, ((StringConcatenation)object).getSignificantContent());
            this.cachedToString = null;
            return;
        }
        String value = object.toString();
        List<String> newSegments = this.splitLinesAndNewLines(value);
        for (String newSegment : newSegments) {
            this.segments.add(index++, newSegment);
        }
        if (!newSegments.isEmpty()) {
            this.cachedToString = null;
        }
    }

    public void append(Object object, String indentation) {
        this.append(object, indentation, this.segments.size());
    }

    protected void append(Object object, String indentation, int index) {
        if (indentation.length() == 0) {
            this.append(object, index);
            return;
        }
        if (object == null) {
            return;
        }
        if (object instanceof StringConcatenation) {
            StringConcatenation other = (StringConcatenation)object;
            List<String> otherSegments = other.getSignificantContent();
            this.appendSegments(indentation, index, otherSegments, other.lineDelimiter);
            return;
        }
        String value = object.toString();
        List<String> newSegments = this.splitLinesAndNewLines(value);
        this.appendSegments(indentation, index, newSegments, this.lineDelimiter);
    }

    public void appendImmediate(Object object, String indentation) {
        int i = this.segments.size() - 1;
        while (i >= 0) {
            String segment = this.segments.get(i);
            int j = 0;
            while (j < segment.length()) {
                if (!Character.isWhitespace(segment.charAt(j))) {
                    this.append(object, indentation, i + 1);
                    return;
                }
                ++j;
            }
            --i;
        }
        this.append(object, indentation, 0);
    }

    protected void appendSegments(String indentation, int index, List<String> otherSegments, String otherDelimiter) {
        for (String otherSegment : otherSegments) {
            if (otherDelimiter.equals(otherSegment)) {
                this.segments.add(index++, this.lineDelimiter);
                this.segments.add(index++, indentation);
                continue;
            }
            this.segments.add(index++, otherSegment);
        }
        if (!otherSegments.isEmpty()) {
            this.cachedToString = null;
        }
    }

    public void newLine() {
        this.segments.add(this.lineDelimiter);
        this.cachedToString = null;
    }

    public void newLineIfNotEmpty() {
        int i = this.segments.size() - 1;
        while (i >= 0) {
            String segment = this.segments.get(i);
            if (this.lineDelimiter.equals(segment)) {
                this.segments.subList(i + 1, this.segments.size()).clear();
                this.cachedToString = null;
                return;
            }
            int j = 0;
            while (j < segment.length()) {
                if (!Character.isWhitespace(segment.charAt(j))) {
                    this.newLine();
                    return;
                }
                ++j;
            }
            --i;
        }
        this.segments.clear();
        this.cachedToString = null;
    }

    @Override
    public String toString() {
        if (this.cachedToString != null) {
            return this.cachedToString;
        }
        List<String> significantContent = this.getSignificantContent();
        StringBuilder builder = new StringBuilder(significantContent.size() * 4);
        for (String segment : significantContent) {
            builder.append(segment);
        }
        this.cachedToString = builder.toString();
        return this.cachedToString;
    }

    protected List<String> getSignificantContent() {
        int i = this.segments.size() - 1;
        while (i >= 0) {
            String segment = this.segments.get(i);
            if (this.lineDelimiter.equals(segment)) {
                return this.segments.subList(0, i + 1);
            }
            int j = 0;
            while (j < segment.length()) {
                if (!Character.isWhitespace(segment.charAt(j))) {
                    return this.segments;
                }
                ++j;
            }
            --i;
        }
        return this.segments;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    protected List<String> splitLinesAndNewLines(String text) {
        if (text == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(5);
        int length = text.length();
        int nextLineOffset = 0;
        int idx = 0;
        while (idx < length) {
            char currentChar = text.charAt(idx);
            if (currentChar == '\r') {
                int delimiterLength = 1;
                if (idx + 1 < length && text.charAt(idx + 1) == '\n') {
                    ++delimiterLength;
                    ++idx;
                }
                int lineLength = idx - delimiterLength - nextLineOffset + 1;
                result.add(text.substring(nextLineOffset, nextLineOffset + lineLength));
                result.add(this.lineDelimiter);
                nextLineOffset = idx + 1;
            } else if (currentChar == '\n') {
                int lineLength = idx - nextLineOffset;
                result.add(text.substring(nextLineOffset, nextLineOffset + lineLength));
                result.add(this.lineDelimiter);
                nextLineOffset = idx + 1;
            }
            ++idx;
        }
        if (nextLineOffset != length) {
            int lineLength = length - nextLineOffset;
            result.add(text.substring(nextLineOffset, nextLineOffset + lineLength));
        }
        return result;
    }
}

