/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.theme.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javafx.beans.InvalidationListener;
import javafx.scene.Scene;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerFactory;
import org.eclipse.fx.ui.services.theme.Theme;
import org.eclipse.fx.ui.services.theme.ThemeManager;
import org.eclipse.fx.ui.theme.internal.Activator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class DefaultThemeManager
implements ThemeManager {
    static final String ATT_ID = "id";
    static final String ATT_NAME = "name";
    static final String ATT_THEME_ID = "themeId";
    static final String ATT_BASETYLESHEET = "basestylesheet";
    static final String ATT_RESOURCE = "resource";
    private final @NonNull List<@NonNull Theme> themes = new ArrayList<Theme>();
    private String currentThemeId;
    List<Scene> managedScenes = new ArrayList<Scene>();
    private static Logger LOGGER;
    private EventAdmin eventAdmin;

    public DefaultThemeManager() {
        IConfigurationElement e;
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor("org.eclipse.fx.ui.theme");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            e = iConfigurationElementArray[n2];
            if (e.getName().equals("theme")) {
                this.themes.add(new ThemeImpl(e));
            }
            ++n2;
        }
        iConfigurationElementArray = registry.getConfigurationElementsFor("org.eclipse.fx.ui.theme");
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            e = iConfigurationElementArray[n2];
            if (e.getName().equals("stylesheet")) {
                String themeId = e.getAttribute(ATT_THEME_ID);
                for (Theme t : this.themes) {
                    if (!t.getId().equals(themeId) && themeId != null && !themeId.isEmpty()) continue;
                    ((ThemeImpl)t).addStylesheet(e);
                }
            }
            ++n2;
        }
    }

    public Theme getCurrentTheme() {
        if (this.themes.isEmpty()) {
            return null;
        }
        if (this.themes.size() == 1) {
            return this.themes.get(0);
        }
        String id = this.getCurrentThemeId();
        if (id != null) {
            for (Theme t : this.themes) {
                if (!t.getId().equals(id)) continue;
                return t;
            }
        }
        this.themes.get(0);
        return null;
    }

    public List<@NonNull Theme> getAvailableThemes() {
        return this.themes;
    }

    private static @NonNull String getCSSClassname(@NonNull String id) {
        return id.replace('.', '-');
    }

    public void setCurrentThemeId(String id) {
        for (Theme t : this.themes) {
            if (!t.getId().equals(id)) continue;
            this.currentThemeId = id;
            EventAdmin eventAdmin = this.getEventAdmin();
            if (eventAdmin != null) {
                eventAdmin.sendEvent(new Event("org/eclipse/fx/Theme/modified", Collections.singletonMap("org.eclipse.e4.data", id)));
            }
            for (Scene scene : this.managedScenes) {
                List<Theme> availableThemes = this.getAvailableThemes();
                for (Theme theme : availableThemes) {
                    for (URL url : theme.getStylesheetURL()) {
                        if (scene.getRoot() != null) {
                            scene.getRoot().getStyleClass().remove((Object)DefaultThemeManager.getCSSClassname(theme.getId()));
                        }
                        scene.getStylesheets().remove((Object)url.toExternalForm());
                    }
                }
                for (Theme theme : availableThemes) {
                    for (URL url : theme.getStylesheetURL()) {
                        if (!theme.getId().equals(this.currentThemeId)) continue;
                        if (scene.getRoot() != null) {
                            scene.getRoot().getStyleClass().remove((Object)DefaultThemeManager.getCSSClassname(theme.getId()));
                            scene.getRoot().getStyleClass().add((Object)DefaultThemeManager.getCSSClassname(theme.getId()));
                        }
                        scene.getStylesheets().add((Object)url.toExternalForm());
                    }
                }
            }
            return;
        }
        throw new IllegalArgumentException("Theme with id '" + id + "' is not known.");
    }

    private String getCurrentThemeId() {
        return this.currentThemeId;
    }

    static @NonNull Logger getLogger() {
        Logger logger = LOGGER;
        if (logger == null) {
            ServiceReference ref = Activator.getContext().getServiceReference(LoggerFactory.class);
            LOGGER = logger = ((LoggerFactory)Activator.getContext().getService(ref)).createLogger(DefaultThemeManager.class.getName());
        }
        return LOGGER;
    }

    @Nullable EventAdmin getEventAdmin() {
        EventAdmin eventAdmin = this.eventAdmin;
        if (eventAdmin != null) {
            return eventAdmin;
        }
        ServiceReference ref = Activator.getContext().getServiceReference(EventAdmin.class);
        if (ref != null) {
            eventAdmin = (EventAdmin)Activator.getContext().getService(ref);
        }
        return eventAdmin;
    }

    public ThemeManager.Registration registerScene(final Scene scene) {
        this.managedScenes.add(scene);
        final InvalidationListener l = o -> {
            String themeId = this.currentThemeId;
            if (scene.getRoot() != null && themeId != null) {
                scene.getRoot().getStyleClass().remove((Object)DefaultThemeManager.getCSSClassname(themeId));
                scene.getRoot().getStyleClass().add((Object)DefaultThemeManager.getCSSClassname(themeId));
            }
        };
        String themeId = this.currentThemeId;
        if (themeId != null) {
            scene.getRoot().getStyleClass().remove((Object)DefaultThemeManager.getCSSClassname(themeId));
            scene.getRoot().getStyleClass().add((Object)DefaultThemeManager.getCSSClassname(themeId));
        }
        scene.rootProperty().addListener(l);
        return new ThemeManager.Registration(){

            public void dispose() {
                scene.rootProperty().removeListener(l);
                DefaultThemeManager.this.managedScenes.remove(scene);
            }
        };
    }

    static class ThemeImpl
    implements Theme {
        private static int THEME_COUNT = 0;
        private final @NonNull IConfigurationElement element;
        private final @NonNull List<@NonNull IConfigurationElement> stylesheetElements = new ArrayList<IConfigurationElement>();
        private final @NonNull List<@NonNull URL> resolvedUrls = new ArrayList<URL>();

        public ThemeImpl(@NonNull IConfigurationElement element) {
            this.element = element;
        }

        void addStylesheet(@NonNull IConfigurationElement stylesheet) {
            this.resolvedUrls.clear();
            this.stylesheetElements.add(stylesheet);
        }

        public String getId() {
            String attribute = this.element.getAttribute(DefaultThemeManager.ATT_ID);
            if (attribute == null) {
                DefaultThemeManager.getLogger().error("The theme has to have an ID");
                attribute = String.valueOf(UUID.randomUUID().toString());
            }
            return attribute;
        }

        public String getName() {
            String attribute = this.element.getAttribute(DefaultThemeManager.ATT_NAME);
            if (attribute == null) {
                DefaultThemeManager.getLogger().warning("The theme should have a name");
                attribute = "Automatic theme " + THEME_COUNT++;
            }
            return attribute;
        }

        public List<@NonNull URL> getStylesheetURL() {
            if (this.resolvedUrls.isEmpty()) {
                URL url = ThemeImpl.getUrl(this.element, DefaultThemeManager.ATT_BASETYLESHEET);
                if (url != null) {
                    this.resolvedUrls.add(url);
                } else {
                    DefaultThemeManager.getLogger().error("Unable to load base stylesheet '" + this.element.getAttribute(DefaultThemeManager.ATT_BASETYLESHEET) + "'");
                }
                for (IConfigurationElement e : this.stylesheetElements) {
                    url = ThemeImpl.getUrl(e, DefaultThemeManager.ATT_RESOURCE);
                    if (url != null) {
                        this.resolvedUrls.add(url);
                        continue;
                    }
                    DefaultThemeManager.getLogger().error("Unable to load stylesheet '" + e.getAttribute(DefaultThemeManager.ATT_RESOURCE) + "'");
                }
            }
            return this.resolvedUrls;
        }

        private static URL getUrl(IConfigurationElement e, String attributeName) {
            String resource = e.getAttribute(attributeName);
            String contributer = e.getDeclaringExtension().getContributor().getName();
            if (resource.startsWith("platform:")) {
                try {
                    return FileLocator.find((URL)new URL(resource));
                }
                catch (MalformedURLException e1) {
                    DefaultThemeManager.getLogger().error("Unable to find css stylesheet file " + resource, (Throwable)e1);
                    return null;
                }
            }
            Bundle b = Platform.getBundle((String)contributer);
            return b.getResource(resource);
        }
    }
}

