/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.internal;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import org.eclipse.fx.core.FilesystemService;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.URI;

public class FileSystemServiceImpl
implements FilesystemService {
    private CheckThread thread;

    @Override
    public boolean applies(URI path) {
        return path.toString().startsWith("file:");
    }

    @Override
    public Subscription observePath(URI uri, BiConsumer<FilesystemService.Kind, URI> consumer) {
        try {
            return this.observePath(Paths.get(new java.net.URI(uri.toString())), (FilesystemService.Kind k, Path p) -> consumer.accept((FilesystemService.Kind)((Object)k), URI.create(p.toUri().toString())));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Subscription observePath(Path path, BiConsumer<FilesystemService.Kind, Path> consumer) {
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new CheckThread();
            this.thread.start();
        }
        try {
            return this.thread.registerURI(path, consumer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class CheckThread
    extends Thread {
        public final Map<WatchKey, List<PathSubscription>> subscriptions = new HashMap<WatchKey, List<PathSubscription>>();
        private final WatchService watcher;
        private final Executor dispatcher = Executors.newCachedThreadPool();
        private final Thread shutdownCleanup;

        public CheckThread() {
            this.setDaemon(true);
            try {
                this.watcher = FileSystems.getDefault().newWatchService();
            }
            catch (IOException iOException) {
                throw new IllegalStateException();
            }
            this.shutdownCleanup = new Thread(() -> {
                try {
                    this.watcher.close();
                }
                catch (Exception exception) {}
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownCleanup);
        }

        protected void finalize() throws Throwable {
            super.finalize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Subscription registerURI(Path path, BiConsumer<FilesystemService.Kind, Path> consumer) throws IOException {
            WatchKey register = path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            PathSubscription s = new PathSubscription(this, path, register, consumer);
            Map<WatchKey, List<PathSubscription>> map = this.subscriptions;
            synchronized (map) {
                List<PathSubscription> list = this.subscriptions.get(register);
                if (list == null) {
                    list = new CopyOnWriteArrayList<PathSubscription>();
                    this.subscriptions.put(register, list);
                }
                list.add(s);
            }
            return s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                WatchKey key;
                try {
                    key = this.watcher.take();
                }
                catch (Exception exception) {
                    return;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent<?> e = event;
                    WatchEvent.Kind<?> kind = e.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    Path context = (Path)e.context();
                    Map<WatchKey, List<PathSubscription>> map = this.subscriptions;
                    synchronized (map) {
                        List<PathSubscription> pathSubscriptionList = this.subscriptions.get(key);
                        if (pathSubscriptionList != null) {
                            Iterator<PathSubscription> iterator = pathSubscriptionList.iterator();
                            while (iterator.hasNext()) {
                                PathSubscription pathSubscription;
                                PathSubscription fp = pathSubscription = iterator.next();
                                this.dispatcher.execute(() -> pathSubscription.consumer.accept(CheckThread.toKind(kind), pathSubscription.path.resolve(context)));
                            }
                        }
                    }
                }
                key.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void removeSubscription(PathSubscription subscription) {
            Map<WatchKey, List<PathSubscription>> map = this.subscriptions;
            synchronized (map) {
                List<PathSubscription> list = this.subscriptions.get(subscription.register);
                if (list != null) {
                    list.remove(subscription);
                    if (list.isEmpty()) {
                        this.subscriptions.remove(subscription.register);
                    }
                }
                if (this.subscriptions.isEmpty()) {
                    try {
                        Runtime.getRuntime().removeShutdownHook(this.shutdownCleanup);
                        this.watcher.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private static FilesystemService.Kind toKind(WatchEvent.Kind<?> kind) {
            if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                return FilesystemService.Kind.CREATE;
            }
            if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                return FilesystemService.Kind.DELETE;
            }
            return FilesystemService.Kind.MODIFY;
        }
    }

    static class PathSubscription
    implements Subscription {
        public final Path path;
        public final WatchKey register;
        public final CheckThread thread;
        public final BiConsumer<FilesystemService.Kind, Path> consumer;

        public PathSubscription(CheckThread thread, Path path, WatchKey register, BiConsumer<FilesystemService.Kind, Path> consumer) {
            this.thread = thread;
            this.path = path;
            this.register = register;
            this.consumer = consumer;
        }

        @Override
        public void dispose() {
            this.register.cancel();
            this.thread.removeSubscription(this);
        }
    }
}

