/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.linking.lazy;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.IDiagnosticProducer;
import org.eclipse.xtext.linking.impl.AbstractCleaningLinker;
import org.eclipse.xtext.linking.impl.LinkingDiagnosticProducer;
import org.eclipse.xtext.linking.lazy.LazyURIEncoder;
import org.eclipse.xtext.linking.lazy.SettingDelegate;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.EcoreGenericsUtil;
import org.eclipse.xtext.util.OnChangeEvictingCache;
import org.eclipse.xtext.util.SimpleCache;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class LazyLinker
extends AbstractCleaningLinker {
    private static final Logger log = Logger.getLogger(LazyLinker.class);
    private SimpleCache<EClass, EClass> instantiableSubTypes = new SimpleCache((Function)new Function<EClass, EClass>(){

        public EClass apply(EClass from) {
            return LazyLinker.this.findInstantiableCompatible(from);
        }
    });
    @Inject
    private LazyURIEncoder encoder;
    @Inject
    private EPackage.Registry registry;
    @Inject
    private EcoreGenericsUtil ecoreGenericsUtil;
    @Inject
    private IGrammarAccess grammarAccess;
    @Inject
    private OnChangeEvictingCache cache;

    @Override
    protected void doLinkModel(final EObject model, IDiagnosticConsumer consumer) {
        ArrayListMultimap settingsToLink = ArrayListMultimap.create();
        final LinkingDiagnosticProducer producer = new LinkingDiagnosticProducer(consumer);
        this.cache.execWithoutCacheClear(model.eResource(), (IUnitOfWork)new IUnitOfWork.Void<Resource>((Multimap)settingsToLink){
            private final /* synthetic */ Multimap val$settingsToLink;
            {
                this.val$settingsToLink = multimap;
            }

            public void process(Resource state) throws Exception {
                TreeIterator iterator = LazyLinker.this.getAllLinkableContents(model);
                boolean clearAllReferencesRequired = LazyLinker.this.isClearAllReferencesRequired(state);
                while (iterator.hasNext()) {
                    EObject eObject = (EObject)iterator.next();
                    if (clearAllReferencesRequired) {
                        LazyLinker.this.clearReferences(eObject);
                    }
                    LazyLinker.this.installProxies(eObject, producer, (Multimap<EStructuralFeature.Setting, INode>)this.val$settingsToLink);
                }
            }
        });
        this.installQueuedLinks((Multimap<EStructuralFeature.Setting, INode>)settingsToLink);
    }

    protected void installProxies(EObject obj, IDiagnosticProducer producer, Multimap<EStructuralFeature.Setting, INode> settingsToLink) {
        ICompositeNode node = NodeModelUtils.getNode(obj);
        if (node == null) {
            return;
        }
        this.installProxies(obj, producer, settingsToLink, node, false);
    }

    private void installProxies(EObject obj, IDiagnosticProducer producer, Multimap<EStructuralFeature.Setting, INode> settingsToLink, ICompositeNode parentNode, boolean dontCheckParent) {
        EClass eClass = obj.eClass();
        if (eClass.getEAllReferences().size() - eClass.getEAllContainments().size() == 0) {
            return;
        }
        INode node = parentNode.getFirstChild();
        while (node != null) {
            RuleCall ruleCall;
            AbstractRule calledRule;
            EObject grammarElement = node.getGrammarElement();
            if (grammarElement instanceof CrossReference && this.hasLeafNodes(node)) {
                producer.setNode(node);
                CrossReference crossReference = (CrossReference)grammarElement;
                EReference eRef = GrammarUtil.getReference(crossReference, eClass);
                if (eRef == null) {
                    ParserRule parserRule = GrammarUtil.containingParserRule(crossReference);
                    String feature = GrammarUtil.containingAssignment(crossReference).getFeature();
                    throw new IllegalStateException("Couldn't find EReference for crossreference '" + eClass.getName() + "::" + feature + "' in parser rule '" + parserRule.getName() + "'.");
                }
                if (!eRef.isResolveProxies()) {
                    EStructuralFeature.Setting setting = ((InternalEObject)obj).eSetting((EStructuralFeature)eRef);
                    settingsToLink.put((Object)new SettingDelegate(setting), (Object)node);
                } else {
                    this.createAndSetProxy(obj, node, eRef);
                    this.afterCreateAndSetProxy(obj, node, eRef, crossReference, producer);
                }
            } else if (grammarElement instanceof RuleCall && node instanceof ICompositeNode && (calledRule = (ruleCall = (RuleCall)grammarElement).getRule()) instanceof ParserRule && ((ParserRule)calledRule).isFragment()) {
                this.installProxies(obj, producer, settingsToLink, (ICompositeNode)node, true);
            }
            node = node.getNextSibling();
        }
        if (!dontCheckParent && this.shouldCheckParentNode(parentNode)) {
            this.installProxies(obj, producer, settingsToLink, parentNode.getParent(), dontCheckParent);
        }
    }

    protected void afterCreateAndSetProxy(EObject obj, INode node, EReference eRef, CrossReference crossReference, IDiagnosticProducer producer) {
    }

    protected boolean hasLeafNodes(INode node) {
        return !Iterables.isEmpty(node.getLeafNodes());
    }

    protected void installQueuedLinks(Multimap<EStructuralFeature.Setting, INode> settingsToLink) {
        for (EStructuralFeature.Setting setting : settingsToLink.keySet()) {
            EObject eObject = setting.getEObject();
            EReference eRef = (EReference)setting.getEStructuralFeature();
            Collection nodes = settingsToLink.get((Object)setting);
            if (setting.getEStructuralFeature().isMany()) {
                EList list = (EList)setting.get(false);
                for (INode node : nodes) {
                    EObject proxy = this.createProxy(eObject, node, eRef);
                    list.add((Object)EcoreUtil.resolve((EObject)proxy, (EObject)eObject));
                }
                continue;
            }
            INode node = (INode)nodes.iterator().next();
            EObject proxy = this.createProxy(eObject, node, eRef);
            setting.set((Object)EcoreUtil.resolve((EObject)proxy, (EObject)eObject));
        }
    }

    protected void createAndSetProxy(EObject obj, INode node, EReference eRef) {
        EObject proxy = this.createProxy(obj, node, eRef);
        if (eRef.isMany()) {
            ((InternalEList)obj.eGet((EStructuralFeature)eRef, false)).addUnique((Object)proxy);
        } else {
            obj.eSet((EStructuralFeature)eRef, (Object)proxy);
        }
    }

    protected EObject createProxy(EObject obj, INode node, EReference eRef) {
        Resource resource = obj.eResource();
        if (resource == null) {
            throw new IllegalStateException("object must be contained in a resource");
        }
        URI uri = resource.getURI();
        URI encodedLink = uri.appendFragment(this.encoder.encode(obj, eRef, node));
        EClass referenceType = this.getProxyType(obj, eRef);
        EObject proxy = EcoreUtil.create((EClass)referenceType);
        ((InternalEObject)proxy).eSetProxyURI(encodedLink);
        return proxy;
    }

    protected EClass getProxyType(EObject obj, EReference eRef) {
        EClass referenceType = this.ecoreGenericsUtil.getReferenceType(eRef, obj.eClass());
        EClass instantiableType = (EClass)this.instantiableSubTypes.get((Object)referenceType);
        return instantiableType;
    }

    protected EClass findInstantiableCompatible(EClass eType) {
        if (!this.isInstantiatableSubType(eType, eType)) {
            EPackage ePackage = eType.getEPackage();
            EClass eClass = this.findSubTypeInEPackage(ePackage, eType);
            if (eClass != null) {
                return eClass;
            }
            return this.globalFindInstantiableCompatible(eType);
        }
        return eType;
    }

    protected EClass globalFindInstantiableCompatible(EClass eType) {
        EClass result;
        HashSet visitedPackages = Sets.newHashSet((Object[])new String[]{eType.getEPackage().getNsURI()});
        for (AbstractMetamodelDeclaration metamodel : GrammarUtil.allMetamodelDeclarations(this.grammarAccess.getGrammar())) {
            if (!visitedPackages.add(metamodel.getEPackage().getNsURI()) || (result = this.findSubTypeInEPackage(metamodel.getEPackage(), eType)) == null) continue;
            return result;
        }
        log.warn((Object)("Traversing EPackage registry to find instantiable subtype for '" + eType.getName() + "'"));
        log.warn((Object)"You may override LazyLinker#globalFindInstantiableCompatible(..) to prevent this.");
        for (String nsURI : this.getRegisteredNsUris()) {
            if (!visitedPackages.add(nsURI)) continue;
            try {
                result = this.findSubTypeInEPackage(this.getRegistry().getEPackage(nsURI), eType);
                if (result == null) continue;
                return result;
            }
            catch (WrappedException ex) {
                log.error((Object)("Error when loading EPackage '" + nsURI + "'"));
                log.error((Object)"You may override LazyLinker#globalFindInstantiableCompatible(..) to prevent this.");
                log.error((Object)("Error when loading EPackage '" + nsURI + "'"), (Throwable)ex);
            }
        }
        throw new IllegalStateException("Could not find an instantiable subtype for type: '" + eType.getName() + "' (" + eType.getEPackage().getNsURI() + ").");
    }

    private List<String> getRegisteredNsUris() {
        Set keySet = this.getRegistry().keySet();
        ArrayList copy = Lists.newArrayList((Iterable)keySet);
        return copy;
    }

    protected EClass findSubTypeInEPackage(EPackage ePackage, EClass superType) {
        EList classifiers = ePackage.getEClassifiers();
        for (EClassifier eClassifier : classifiers) {
            EClass c;
            if (!(eClassifier instanceof EClass) || !this.isInstantiatableSubType(c = (EClass)eClassifier, superType)) continue;
            return c;
        }
        return null;
    }

    private boolean isInstantiatableSubType(EClass c, EClass superType) {
        return !c.isAbstract() && !c.isInterface() && EcoreUtil2.isAssignableFrom(superType, c);
    }

    public LazyURIEncoder getEncoder() {
        return this.encoder;
    }

    public EPackage.Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(EPackage.Registry registry) {
        this.registry = registry;
    }

    public void setEncoder(LazyURIEncoder encoder) {
        this.encoder = encoder;
    }

    public void setGrammarAccess(IGrammarAccess grammarAccess) {
        this.grammarAccess = grammarAccess;
    }

    public IGrammarAccess getGrammarAccess() {
        return this.grammarAccess;
    }

    protected OnChangeEvictingCache getCache() {
        return this.cache;
    }
}

