/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Direction implements Enumerator
{
    LTR(0, "ltr", "ltr"),
    RTL(1, "rtl", "rtl"),
    INHERIT(2, "inherit", "inherit");

    public static final int LTR_VALUE = 0;
    public static final int RTL_VALUE = 1;
    public static final int INHERIT_VALUE = 2;
    private static final Direction[] VALUES_ARRAY;
    public static final List<Direction> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Direction[]{LTR, RTL, INHERIT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Direction get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Direction result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Direction getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Direction result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Direction get(int value) {
        switch (value) {
            case 0: {
                return LTR;
            }
            case 1: {
                return RTL;
            }
            case 2: {
                return INHERIT;
            }
        }
        return null;
    }

    private Direction(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

