/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.IMemoryBlockListener;
import org.eclipse.debug.core.IMemoryBlockManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;

public class MemoryBlockManager
implements IMemoryBlockManager,
IDebugEventSetListener {
    private ArrayList<IMemoryBlockListener> listeners = new ArrayList();
    private ArrayList<IMemoryBlock> memoryBlocks = new ArrayList();
    private static final int ADDED = 0;
    private static final int REMOVED = 1;

    private MemoryBlockNotifier getMemoryBlockNotifier() {
        return new MemoryBlockNotifier();
    }

    @Override
    public void addMemoryBlocks(IMemoryBlock[] mem) {
        if (this.memoryBlocks == null) {
            return;
        }
        if (mem == null) {
            DebugPlugin.logMessage("Null argument passed into IMemoryBlockManager.addMemoryBlock", null);
            return;
        }
        if (mem.length > 0) {
            ArrayList<IMemoryBlock> newMemoryBlocks = new ArrayList<IMemoryBlock>();
            int i = 0;
            while (i < mem.length) {
                if (!this.memoryBlocks.contains(mem[i])) {
                    newMemoryBlocks.add(mem[i]);
                    this.memoryBlocks.add(mem[i]);
                    if (this.memoryBlocks.size() == 1) {
                        DebugPlugin.getDefault().addDebugEventListener(this);
                    }
                }
                ++i;
            }
            this.notifyListeners(newMemoryBlocks.toArray(new IMemoryBlock[newMemoryBlocks.size()]), 0);
        }
    }

    @Override
    public void removeMemoryBlocks(IMemoryBlock[] memBlocks) {
        if (this.memoryBlocks == null) {
            return;
        }
        if (memBlocks == null) {
            DebugPlugin.logMessage("Null argument passed into IMemoryBlockManager.removeMemoryBlock", null);
            return;
        }
        if (memBlocks.length > 0) {
            int i = 0;
            while (i < memBlocks.length) {
                this.memoryBlocks.remove(memBlocks[i]);
                if (this.memoryBlocks.size() == 0) {
                    DebugPlugin.getDefault().removeDebugEventListener(this);
                }
                if (memBlocks[i] instanceof IMemoryBlockExtension) {
                    try {
                        ((IMemoryBlockExtension)memBlocks[i]).dispose();
                    }
                    catch (DebugException e) {
                        DebugPlugin.log((Throwable)((Object)e));
                    }
                }
                ++i;
            }
            this.notifyListeners(memBlocks, 1);
        }
    }

    @Override
    public void addListener(IMemoryBlockListener listener) {
        if (this.listeners == null) {
            return;
        }
        if (listener == null) {
            DebugPlugin.logMessage("Null argument passed into IMemoryBlockManager.addListener", null);
            return;
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(IMemoryBlockListener listener) {
        if (this.listeners == null) {
            return;
        }
        if (listener == null) {
            DebugPlugin.logMessage("Null argument passed into IMemoryBlockManager.removeListener", null);
            return;
        }
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public IMemoryBlock[] getMemoryBlocks() {
        return this.memoryBlocks.toArray(new IMemoryBlock[this.memoryBlocks.size()]);
    }

    @Override
    public IMemoryBlock[] getMemoryBlocks(IDebugTarget debugTarget) {
        ArrayList<IMemoryBlock> memoryBlocksList = new ArrayList<IMemoryBlock>();
        for (IMemoryBlock block : this.memoryBlocks) {
            if (block.getDebugTarget() != debugTarget) continue;
            memoryBlocksList.add(block);
        }
        return memoryBlocksList.toArray(new IMemoryBlock[memoryBlocksList.size()]);
    }

    @Override
    public IMemoryBlock[] getMemoryBlocks(IMemoryBlockRetrieval retrieve) {
        ArrayList<IMemoryBlock> memoryBlocksList = new ArrayList<IMemoryBlock>();
        for (IMemoryBlock block : this.memoryBlocks) {
            if (block instanceof IMemoryBlockExtension) {
                if (((IMemoryBlockExtension)block).getMemoryBlockRetrieval() != retrieve) continue;
                memoryBlocksList.add(block);
                continue;
            }
            IMemoryBlockRetrieval mbRetrieval = (IMemoryBlockRetrieval)block.getAdapter(IMemoryBlockRetrieval.class);
            if (mbRetrieval == null) {
                mbRetrieval = block.getDebugTarget();
            }
            if (mbRetrieval != retrieve) continue;
            memoryBlocksList.add(block);
        }
        return memoryBlocksList.toArray(new IMemoryBlock[memoryBlocksList.size()]);
    }

    private void notifyListeners(IMemoryBlock[] memBlocks, int event) {
        this.getMemoryBlockNotifier().notify(memBlocks, event);
    }

    @Override
    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            this.handleDebugEvent(events[i]);
            ++i;
        }
    }

    public void handleDebugEvent(DebugEvent event) {
        Object obj = event.getSource();
        IDebugTarget dt = null;
        if (event.getKind() == 8 && obj instanceof IDebugTarget) {
            dt = (IDebugTarget)obj;
            IMemoryBlock[] deletedMemoryBlocks = this.getMemoryBlocks(dt);
            this.removeMemoryBlocks(deletedMemoryBlocks);
        }
    }

    public void shutdown() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        if (this.memoryBlocks != null) {
            this.memoryBlocks.clear();
            this.memoryBlocks = null;
        }
    }

    class MemoryBlockNotifier
    implements ISafeRunnable {
        private IMemoryBlockListener fListener;
        private int fType;
        private IMemoryBlock[] fMemoryBlocks;

        MemoryBlockNotifier() {
        }

        public void handleException(Throwable exception) {
            DebugPlugin.log(exception);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 0: {
                    this.fListener.memoryBlocksAdded(this.fMemoryBlocks);
                    break;
                }
                case 1: {
                    this.fListener.memoryBlocksRemoved(this.fMemoryBlocks);
                    break;
                }
            }
        }

        public void notify(IMemoryBlock[] memBlocks, int update) {
            if (MemoryBlockManager.this.listeners != null) {
                this.fType = update;
                IMemoryBlockListener[] copiedListeners = MemoryBlockManager.this.listeners.toArray(new IMemoryBlockListener[MemoryBlockManager.this.listeners.size()]);
                int i = 0;
                while (i < copiedListeners.length) {
                    this.fListener = copiedListeners[i];
                    this.fMemoryBlocks = memBlocks;
                    SafeRunner.run((ISafeRunnable)this);
                    ++i;
                }
            }
            this.fListener = null;
            this.fMemoryBlocks = null;
        }
    }
}

