/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.layout.BorderPane;
import org.eclipse.fx.code.editor.Input;
import org.eclipse.fx.code.editor.fx.TextEditor;
import org.eclipse.fx.code.editor.fx.services.CompletionProposalPresenter;
import org.eclipse.fx.code.editor.fx.services.internal.DefaultSourceViewerConfiguration;
import org.eclipse.fx.code.editor.services.BehaviorContributor;
import org.eclipse.fx.code.editor.services.EditorOpener;
import org.eclipse.fx.code.editor.services.HoverInformationProvider;
import org.eclipse.fx.code.editor.services.NavigationProvider;
import org.eclipse.fx.code.editor.services.ProposalComputer;
import org.eclipse.fx.code.editor.services.SearchProvider;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.text.rules.CombinedWordRule;
import org.eclipse.fx.text.rules.JavaLikeWordDetector;
import org.eclipse.fx.text.ui.presentation.IPresentationDamager;
import org.eclipse.fx.text.ui.presentation.IPresentationRepairer;
import org.eclipse.fx.text.ui.presentation.PresentationReconciler;
import org.eclipse.fx.text.ui.rules.DefaultDamagerRepairer;
import org.eclipse.fx.text.ui.source.AnnotationPresenter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.source.IAnnotationModel;

public class SimpleSourceTextEditorBuilder {
    private List<String> keywordList = new ArrayList<String>();
    private List<String> singleLineCommentStart = new ArrayList<String>();
    private List<String> singleLineDocCommentStart = new ArrayList<String>();
    private List<MultiLine> multiLineComment = new ArrayList<MultiLine>();
    private List<MultiLine> multiLineDocComment = new ArrayList<MultiLine>();
    private List<Character> stringIdentifier = new ArrayList<Character>();
    private char stringEscapeChar;
    private ProposalComputer proposalComputer;
    private AnnotationPresenter annotationPresenter;
    private final String languageName;
    private CompletionProposalPresenter completionProposalPresenter;
    private HoverInformationProvider hoverInformationProvider;
    private SearchProvider searchProvider;
    private NavigationProvider navigationProvider;
    private EditorOpener editorOpener;
    private BehaviorContributor behaviorContributor;

    private SimpleSourceTextEditorBuilder(String languageName) {
        this.languageName = languageName;
    }

    public SimpleSourceTextEditorBuilder addKeyWord(String keyword) {
        this.keywordList.add(keyword);
        return this;
    }

    public SimpleSourceTextEditorBuilder addSingleLineCommentStart(String start) {
        this.singleLineCommentStart.add(start);
        return this;
    }

    public SimpleSourceTextEditorBuilder addSingleLineDocCommentStart(String start) {
        this.singleLineDocCommentStart.add(start);
        return this;
    }

    public SimpleSourceTextEditorBuilder addMultiLineComment(String start, String end) {
        this.multiLineComment.add(new MultiLine(start, end));
        return this;
    }

    public SimpleSourceTextEditorBuilder addMultiLineDocComment(String start, String end) {
        this.multiLineDocComment.add(new MultiLine(start, end));
        return this;
    }

    public SimpleSourceTextEditorBuilder addStringStartEnd(char c) {
        this.stringIdentifier.add(Character.valueOf(c));
        return this;
    }

    public SimpleSourceTextEditorBuilder setProposalComputer(ProposalComputer proposalComputer) {
        this.proposalComputer = proposalComputer;
        return this;
    }

    public SimpleSourceTextEditorBuilder setAnnotationPresenter(AnnotationPresenter annotationPresenter) {
        this.annotationPresenter = annotationPresenter;
        return this;
    }

    public SimpleSourceTextEditorBuilder setCompletionProposalPresenter(CompletionProposalPresenter completionProposalPresenter) {
        this.completionProposalPresenter = completionProposalPresenter;
        return this;
    }

    public SimpleSourceTextEditorBuilder setHoverInformationProvider(HoverInformationProvider hoverInformationProvider) {
        this.hoverInformationProvider = hoverInformationProvider;
        return this;
    }

    public SimpleSourceTextEditorBuilder setStringEscapeChar(char c) {
        this.stringEscapeChar = c;
        return this;
    }

    public TextEditor build(ThreadSynchronize threadSynchronize, BorderPane pane, IDocument document, Input<?> input) {
        return this.build(threadSynchronize, pane, document, input, null);
    }

    public TextEditor build(ThreadSynchronize threadSynchronize, BorderPane pane, IDocument document, Input<?> input, IAnnotationModel annotationModel) {
        TextEditor editor = new TextEditor();
        editor.setInput(input);
        editor.setDocument(document);
        ArrayList<String> contentTypes = new ArrayList<String>();
        if (this.singleLineCommentStart.isEmpty()) {
            contentTypes.add("__" + this.languageName + "_singlelinecomment");
        }
        if (this.singleLineDocCommentStart.isEmpty()) {
            contentTypes.add("__" + this.languageName + "_singlelinedoccomment");
        }
        if (this.multiLineComment.isEmpty()) {
            contentTypes.add("__" + this.languageName + "_multilinecomment");
        }
        if (this.multiLineDocComment.isEmpty()) {
            contentTypes.add("__" + this.languageName + "_multilinedoccomment");
        }
        if (this.stringIdentifier.isEmpty()) {
            contentTypes.add("__" + this.languageName + "_string");
        }
        editor.setPartitioner((IDocumentPartitioner)new FastPartitioner((IPartitionTokenScanner)new PartitionerImpl(this), contentTypes.toArray(new String[0])));
        editor.setSourceViewerConfiguration(new DefaultSourceViewerConfiguration(threadSynchronize, input, new ReconcilerImpl(this), null, this.proposalComputer, annotationModel, this.annotationPresenter, this.hoverInformationProvider, this.completionProposalPresenter, this.searchProvider, this.navigationProvider, this.editorOpener, this.behaviorContributor, null));
        return editor;
    }

    public static SimpleSourceTextEditorBuilder create(String languageName) {
        return new SimpleSourceTextEditorBuilder(languageName);
    }

    static class CodeRuleScanner
    extends RuleBasedScanner {
        public CodeRuleScanner(SimpleSourceTextEditorBuilder textEditorBuilder) {
            Token defaultToken = new Token((Object)(String.valueOf(textEditorBuilder.languageName) + "_default"));
            IRule[] rules = new IRule[2];
            rules[0] = new WhitespaceRule(new IWhitespaceDetector(){

                public boolean isWhitespace(char c) {
                    return Character.isWhitespace(c);
                }
            });
            JavaLikeWordDetector wordDetector = new JavaLikeWordDetector();
            CombinedWordRule combinedWordRule = new CombinedWordRule((IWordDetector)wordDetector, (IToken)defaultToken);
            Token keywordToken = new Token((Object)(String.valueOf(textEditorBuilder.languageName) + "_keyword"));
            CombinedWordRule.WordMatcher wordRule = new CombinedWordRule.WordMatcher();
            for (String keyword : textEditorBuilder.keywordList) {
                wordRule.addWord(keyword, (IToken)keywordToken);
            }
            combinedWordRule.addWordMatcher(wordRule);
            rules[1] = combinedWordRule;
            this.setRules(rules);
            this.setDefaultReturnToken((IToken)defaultToken);
        }
    }

    static class MultiLine {
        private final String start;
        private final String end;

        public MultiLine(String start, String end) {
            this.start = start;
            this.end = end;
        }
    }

    static class NoRuleRuleScanner
    extends RuleBasedScanner {
        public NoRuleRuleScanner(String defaultTokenName) {
            this.setDefaultReturnToken((IToken)new Token((Object)defaultTokenName));
        }
    }

    static class PartitionerImpl
    extends RuleBasedPartitionScanner {
        public PartitionerImpl(SimpleSourceTextEditorBuilder textEditorBuilder) {
            Token token;
            ArrayList<Object> rules = new ArrayList<Object>();
            if (textEditorBuilder.singleLineCommentStart.isEmpty()) {
                token = new Token((Object)("__" + textEditorBuilder.languageName + "_singlelinecomment"));
                for (String s : textEditorBuilder.singleLineCommentStart) {
                    rules.add(new SingleLineRule(s, null, (IToken)token));
                }
            }
            if (textEditorBuilder.singleLineDocCommentStart.isEmpty()) {
                token = new Token((Object)("__" + textEditorBuilder.languageName + "_singlelinedoccomment"));
                for (String s : textEditorBuilder.singleLineDocCommentStart) {
                    rules.add(new SingleLineRule(s, null, (IToken)token));
                }
            }
            if (textEditorBuilder.multiLineComment.isEmpty()) {
                token = new Token((Object)("__" + textEditorBuilder.languageName + "_multilinecomment"));
                for (MultiLine m : textEditorBuilder.multiLineComment) {
                    rules.add(new MultiLineRule(m.start, m.end, (IToken)token));
                }
            }
            if (textEditorBuilder.multiLineDocComment.isEmpty()) {
                token = new Token((Object)("__" + textEditorBuilder.languageName + "_multilinedoccomment"));
                for (MultiLine m : textEditorBuilder.multiLineDocComment) {
                    rules.add(new MultiLineRule(m.start, m.end, (IToken)token));
                }
            }
            if (textEditorBuilder.stringIdentifier.isEmpty()) {
                token = new Token((Object)("__" + textEditorBuilder.languageName + "_string"));
                for (Character c : textEditorBuilder.stringIdentifier) {
                    rules.add(new SingleLineRule(c.toString(), c.toString(), (IToken)token, textEditorBuilder.stringEscapeChar));
                }
            }
            this.setPredicateRules(rules.toArray(new IPredicateRule[0]));
        }
    }

    static class ReconcilerImpl
    extends PresentationReconciler {
        public ReconcilerImpl(SimpleSourceTextEditorBuilder textEditorBuilder) {
            DefaultDamagerRepairer dr;
            if (textEditorBuilder.singleLineCommentStart.isEmpty()) {
                dr = new DefaultDamagerRepairer((ITokenScanner)new NoRuleRuleScanner(String.valueOf(textEditorBuilder.languageName) + "_comment"));
                this.setDamager((IPresentationDamager)dr, "__" + textEditorBuilder.languageName + "_singlelinecomment");
                this.setRepairer((IPresentationRepairer)dr, "__" + textEditorBuilder.languageName + "_singlelinecomment");
            }
            if (textEditorBuilder.singleLineDocCommentStart.isEmpty()) {
                dr = new DefaultDamagerRepairer((ITokenScanner)new NoRuleRuleScanner(String.valueOf(textEditorBuilder.languageName) + "_doccomment"));
                this.setDamager((IPresentationDamager)dr, "__" + textEditorBuilder.languageName + "_singlelinedoccomment");
                this.setRepairer((IPresentationRepairer)dr, "__" + textEditorBuilder.languageName + "_singlelinedoccomment");
            }
            if (textEditorBuilder.multiLineComment.isEmpty()) {
                dr = new DefaultDamagerRepairer((ITokenScanner)new NoRuleRuleScanner(String.valueOf(textEditorBuilder.languageName) + "_comment"));
                this.setDamager((IPresentationDamager)dr, "__" + textEditorBuilder.languageName + "_multilinecomment");
                this.setRepairer((IPresentationRepairer)dr, "__" + textEditorBuilder.languageName + "_multilinecomment");
            }
            if (textEditorBuilder.multiLineDocComment.isEmpty()) {
                dr = new DefaultDamagerRepairer((ITokenScanner)new NoRuleRuleScanner(String.valueOf(textEditorBuilder.languageName) + "_doccomment"));
                this.setDamager((IPresentationDamager)dr, "__" + textEditorBuilder.languageName + "_multilinedoccomment");
                this.setRepairer((IPresentationRepairer)dr, "__" + textEditorBuilder.languageName + "_multilinedoccomment");
            }
            if (textEditorBuilder.stringIdentifier.isEmpty()) {
                dr = new DefaultDamagerRepairer((ITokenScanner)new NoRuleRuleScanner(String.valueOf(textEditorBuilder.languageName) + "_string"));
                this.setDamager((IPresentationDamager)dr, "__" + textEditorBuilder.languageName + "_string");
                this.setRepairer((IPresentationRepairer)dr, "__" + textEditorBuilder.languageName + "_string");
            }
        }
    }
}

