/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.configuration.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.fx.code.editor.configuration.CompositeCondition;
import org.eclipse.fx.code.editor.configuration.Condition;
import org.eclipse.fx.code.editor.configuration.EditorGModel;
import org.eclipse.fx.code.editor.configuration.gson.GsonBase;
import org.eclipse.fx.code.editor.configuration.gson.GsonConditionImpl;
import org.eclipse.fx.code.editor.configuration.gson.GsonElementFactory;

public final class GsonCompositeConditionImpl
implements GsonBase,
CompositeCondition,
Condition {
    private final boolean and;
    private final List<Condition> elementList;
    private final String name;

    public GsonCompositeConditionImpl(JsonObject jsonObject) {
        this.and = jsonObject.has("and") ? jsonObject.get("and").getAsBoolean() : false;
        this.elementList = jsonObject.has("elementList") ? Collections.unmodifiableList(StreamSupport.stream(jsonObject.getAsJsonArray("elementList").spliterator(), false).map(e -> GsonElementFactory.createCondition(e.getAsJsonObject())).collect(Collectors.toList())) : Collections.emptyList();
        this.name = jsonObject.has("name") ? jsonObject.get("name").getAsString() : null;
    }

    public GsonCompositeConditionImpl(boolean and, List<Condition> elementList, String name) {
        this.and = and;
        this.elementList = elementList;
        this.name = name;
    }

    @Override
    public JsonObject toJSONObject() {
        JsonObject o = new JsonObject();
        o.addProperty("$gtype", "CompositeCondition");
        o.addProperty("and", Boolean.valueOf(this.isAnd()));
        o.add("elementList", (JsonElement)GsonBase.toDomainJsonArray(this.getElementList()));
        o.addProperty("name", this.getName());
        return o;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " { and : " + this.and + ", elementList : " + String.valueOf(this.elementList.stream().map(e -> e.getClass().getSimpleName() + "@" + Integer.toHexString(e.hashCode())).collect(Collectors.toList())) + ", name : " + this.name + " }";
    }

    @Override
    public boolean isAnd() {
        return this.and;
    }

    @Override
    public List<Condition> getElementList() {
        return this.elementList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static class Builder
    implements CompositeCondition.Builder {
        private final EditorGModel instance;
        private boolean and;
        private final List<Condition> elementList = new ArrayList<Condition>();
        private String name;

        public Builder(EditorGModel instance) {
            this.instance = instance;
        }

        @Override
        public Builder and(boolean and) {
            this.and = and;
            return this;
        }

        @Override
        public Builder elementList(List<Condition> elementList) {
            this.elementList.addAll(elementList);
            return this;
        }

        @Override
        public Builder appendElementList(Condition elementList) {
            this.elementList.add(elementList);
            return this;
        }

        @Override
        public Builder elementList(Function<EditorGModel, List<Condition>> provider) {
            this.elementList((List)provider.apply(this.instance));
            return this;
        }

        @Override
        public Builder appendElementList(Function<Condition.Builder, Condition> provider) {
            this.appendElementList(provider.apply(new GsonConditionImpl.Builder(this.instance)));
            return this;
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public CompositeCondition build() {
            return new GsonCompositeConditionImpl(this.and, this.elementList, this.name);
        }
    }
}

