/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.StandardClasspathProvider;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.jdt.IClassifierClasspathProvider;
import org.eclipse.m2e.jdt.IClasspathManager;
import org.eclipse.m2e.jdt.IMavenClassifierManager;
import org.eclipse.m2e.jdt.MavenJdtPlugin;
import org.eclipse.m2e.jdt.internal.MavenClasspathHelpers;
import org.eclipse.m2e.jdt.internal.Messages;
import org.eclipse.osgi.util.NLS;

public class MavenRuntimeClasspathProvider
extends StandardClasspathProvider {
    public static final String MAVEN_SOURCEPATH_PROVIDER = "org.eclipse.m2e.launchconfig.sourcepathProvider";
    public static final String MAVEN_CLASSPATH_PROVIDER = "org.eclipse.m2e.launchconfig.classpathProvider";
    private static final String TESTS_PROJECT_CLASSIFIER = "tests";
    private static final String THIS_PROJECT_CLASSIFIER = "";
    public static final String JDT_JUNIT_TEST = "org.eclipse.jdt.junit.launchconfig";
    public static final String JDT_JAVA_APPLICATION = "org.eclipse.jdt.launching.localJavaApplication";
    public static final String JDT_TESTNG_TEST = "org.testng.eclipse.launchconfig";
    private static final Set<String> supportedTypes = new HashSet<String>();
    IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();

    static {
        supportedTypes.add(JDT_JAVA_APPLICATION);
        supportedTypes.add(JDT_JUNIT_TEST);
        supportedTypes.add(JDT_TESTNG_TEST);
    }

    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
        boolean useDefault = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        if (useDefault) {
            IJavaProject javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
            IRuntimeClasspathEntry jreEntry = JavaRuntime.computeJREEntry((ILaunchConfiguration)configuration);
            IRuntimeClasspathEntry projectEntry = JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)javaProject);
            IRuntimeClasspathEntry mavenEntry = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)new Path("org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER"), (int)3);
            if (jreEntry == null) {
                return new IRuntimeClasspathEntry[]{projectEntry, mavenEntry};
            }
            return new IRuntimeClasspathEntry[]{jreEntry, projectEntry, mavenEntry};
        }
        return this.recoverRuntimePath(configuration, IJavaLaunchConfigurationConstants.ATTR_CLASSPATH);
    }

    public IRuntimeClasspathEntry[] resolveClasspath(final IRuntimeClasspathEntry[] entries, final ILaunchConfiguration configuration) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        return (IRuntimeClasspathEntry[])MavenPlugin.getMaven().execute((ICallable)new ICallable<IRuntimeClasspathEntry[]>(){

            public IRuntimeClasspathEntry[] call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                return MavenRuntimeClasspathProvider.this.resolveClasspath0(entries, configuration, monitor);
            }
        }, (IProgressMonitor)monitor);
    }

    IRuntimeClasspathEntry[] resolveClasspath0(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        int scope = this.getArtifactScope(configuration);
        LinkedHashSet<IRuntimeClasspathEntry> all = new LinkedHashSet<IRuntimeClasspathEntry>(entries.length);
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n2];
            if (entry.getType() == 4 && MavenClasspathHelpers.isMaven2ClasspathContainer(entry.getPath())) {
                this.addMavenClasspathEntries(all, entry, configuration, scope, monitor);
            } else if (entry.getType() == 1) {
                IJavaProject javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
                if (javaProject.getPath().equals((Object)entry.getPath())) {
                    this.addProjectEntries(all, entry.getPath(), scope, THIS_PROJECT_CLASSIFIER, configuration, monitor);
                } else {
                    this.addStandardClasspathEntries(all, entry, configuration);
                }
            } else {
                this.addStandardClasspathEntries(all, entry, configuration);
            }
            ++n2;
        }
        return all.toArray(new IRuntimeClasspathEntry[all.size()]);
    }

    private void addStandardClasspathEntries(Set<IRuntimeClasspathEntry> all, IRuntimeClasspathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entry, (ILaunchConfiguration)configuration);
        int j = 0;
        while (j < resolved.length) {
            all.add(resolved[j]);
            ++j;
        }
    }

    private void addMavenClasspathEntries(Set<IRuntimeClasspathEntry> resolved, IRuntimeClasspathEntry runtimeClasspathEntry, ILaunchConfiguration configuration, int scope, IProgressMonitor monitor) throws CoreException {
        IClasspathEntry[] cp;
        IJavaProject javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
        MavenJdtPlugin plugin = MavenJdtPlugin.getDefault();
        IClasspathManager buildpathManager = plugin.getBuildpathManager();
        IClasspathEntry[] iClasspathEntryArray = cp = buildpathManager.getClasspath(javaProject.getProject(), scope, false, monitor);
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            switch (entry.getEntryKind()) {
                case 2: {
                    this.addProjectEntries(resolved, entry.getPath(), scope, MavenRuntimeClasspathProvider.getArtifactClassifier(entry), configuration, monitor);
                    break;
                }
                case 1: {
                    resolved.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)entry.getPath()));
                }
            }
            ++n2;
        }
    }

    protected int getArtifactScope(ILaunchConfiguration configuration) throws CoreException {
        String typeid = configuration.getType().getAttribute("id");
        if (JDT_JAVA_APPLICATION.equals(typeid)) {
            IResource[] resources = configuration.getMappedResources();
            if (resources == null || resources.length == 0) {
                return 1;
            }
            HashSet<IPath> testSources = new HashSet<IPath>();
            IJavaProject javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
            IMavenProjectFacade facade = this.projectManager.create(javaProject.getProject(), (IProgressMonitor)new NullProgressMonitor());
            if (facade == null) {
                return 1;
            }
            testSources.addAll(Arrays.asList(facade.getTestCompileSourceLocations()));
            int i = 0;
            while (i < resources.length) {
                for (IPath testPath : testSources) {
                    if (!testPath.isPrefixOf(resources[i].getProjectRelativePath())) continue;
                    return 0;
                }
                ++i;
            }
            return 1;
        }
        if (JDT_JUNIT_TEST.equals(typeid) || JDT_TESTNG_TEST.equals(typeid)) {
            return 0;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", 0, NLS.bind((String)Messages.MavenRuntimeClasspathProvider_error_unsupported, (Object)typeid), null));
    }

    protected void addProjectEntries(Set<IRuntimeClasspathEntry> resolved, IPath path, int scope, String classifier, ILaunchConfiguration launchConfiguration, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(path.segment(0));
        IMavenProjectFacade projectFacade = this.projectManager.create(project, monitor);
        if (projectFacade == null) {
            return;
        }
        ResolverConfiguration configuration = projectFacade.getResolverConfiguration();
        if (configuration == null) {
            return;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        boolean projectResolved = false;
        IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            IRuntimeClasspathEntry rce = null;
            switch (entry.getEntryKind()) {
                case 3: {
                    if (projectResolved) break;
                    IMavenClassifierManager mavenClassifierManager = MavenJdtPlugin.getDefault().getMavenClassifierManager();
                    IClassifierClasspathProvider classifierClasspathProvider = mavenClassifierManager.getClassifierClasspathProvider(projectFacade, classifier);
                    if (scope == 0) {
                        classifierClasspathProvider.setTestClasspath(resolved, projectFacade, monitor);
                    } else {
                        classifierClasspathProvider.setRuntimeClasspath(resolved, projectFacade, monitor);
                    }
                    projectResolved = true;
                    break;
                }
                case 5: {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProject);
                    if (container == null || MavenClasspathHelpers.isMaven2ClasspathContainer(entry.getPath())) break;
                    switch (container.getKind()) {
                        case 1: {
                            rce = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)container.getPath(), (int)3, (IJavaProject)javaProject);
                        }
                    }
                    break;
                }
                case 1: {
                    rce = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)entry.getPath());
                    break;
                }
                case 4: {
                    if ("JRE_LIB".equals(entry.getPath().segment(0))) break;
                    rce = JavaRuntime.newVariableRuntimeClasspathEntry((IPath)entry.getPath());
                    break;
                }
                case 2: {
                    IJavaProject otherProject;
                    IProject res = root.getProject(entry.getPath().segment(0));
                    if (res == null || (otherProject = JavaCore.create((IProject)res)) == null) break;
                    rce = JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)otherProject);
                    break;
                }
            }
            if (rce != null) {
                this.addStandardClasspathEntries(resolved, rce, launchConfiguration);
            }
            ++n2;
        }
    }

    public static boolean isSupportedType(String id) {
        return supportedTypes.contains(id);
    }

    public static void enable(ILaunchConfiguration config) throws CoreException {
        if (config instanceof ILaunchConfigurationWorkingCopy) {
            MavenRuntimeClasspathProvider.enable((ILaunchConfigurationWorkingCopy)config);
        } else {
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            MavenRuntimeClasspathProvider.enable(wc);
            wc.doSave();
        }
    }

    private static void enable(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, MAVEN_CLASSPATH_PROVIDER);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, MAVEN_SOURCEPATH_PROVIDER);
    }

    public static void disable(ILaunchConfiguration config) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, null);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, null);
        wc.doSave();
    }

    private static String getArtifactClassifier(IClasspathEntry entry) {
        IClasspathAttribute[] attributes;
        IClasspathAttribute[] iClasspathAttributeArray = attributes = entry.getExtraAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            if ("maven.classifier".equals(attribute.getName())) {
                return attribute.getValue();
            }
            ++n2;
        }
        return null;
    }

    public static void enable(IProject project) throws CoreException {
        for (ILaunchConfiguration config : MavenRuntimeClasspathProvider.getLaunchConfiguration(project)) {
            if (!MavenRuntimeClasspathProvider.isSupportedType(config.getType().getIdentifier())) continue;
            MavenRuntimeClasspathProvider.enable(config);
        }
    }

    public static void disable(IProject project) throws CoreException {
        for (ILaunchConfiguration config : MavenRuntimeClasspathProvider.getLaunchConfiguration(project)) {
            if (!MavenRuntimeClasspathProvider.isSupportedType(config.getType().getIdentifier())) continue;
            MavenRuntimeClasspathProvider.disable(config);
        }
    }

    private static List<ILaunchConfiguration> getLaunchConfiguration(IProject project) throws CoreException {
        ILaunchConfiguration[] configurations;
        ArrayList<ILaunchConfiguration> result = new ArrayList<ILaunchConfiguration>();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] iLaunchConfigurationArray = configurations = launchManager.getLaunchConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            String projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
            if (project.getName().equals(projectName)) {
                result.add(config);
            }
            ++n2;
        }
        return result;
    }
}

