/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext;

import javafx.scene.layout.Pane;
import javafx.scene.shape.Line;
import org.eclipse.fx.ui.controls.styledtext.DecorationStrategyFactory;
import org.eclipse.fx.ui.controls.styledtext.internal.TextNode;
import org.eclipse.fx.ui.controls.styledtext.model.DecorationStrategy;
import org.eclipse.jdt.annotation.NonNull;
import org.osgi.service.component.annotations.Component;

@Component
public class UnderlineStrategyFactory
implements DecorationStrategyFactory {
    public int getRanking() {
        return 0;
    }

    @Override
    public @NonNull String getDecorationStrategyName() {
        return "underline";
    }

    @Override
    public DecorationStrategy create(String definition) {
        return new UnderlineStrategy();
    }

    static class UnderlineStrategy
    implements DecorationStrategy {
        UnderlineStrategy() {
        }

        @Override
        public void attach(Pane node, TextNode textNode) {
            Line l = (Line)textNode.getUserData();
            if (l == null) {
                l = new Line();
                l.setMouseTransparent(true);
                l.setManaged(false);
                l.setStartY(textNode.getBoundsInLocal().getHeight() - 2.0);
                l.strokeProperty().bind(textNode.fillProperty());
                l.setEndY(textNode.getBoundsInLocal().getHeight() - 2.0);
                l.setEndX(textNode.getBoundsInLocal().getWidth());
                textNode.setUserData(l);
            }
            node.getChildren().add((Object)l);
        }

        @Override
        public void unattach(Pane node, TextNode textNode) {
            Line l = (Line)textNode.getUserData();
            if (l != null) {
                textNode.setUserData(null);
                node.getChildren().remove((Object)l);
                l.fillProperty().unbind();
            }
        }

        @Override
        public void layout(Pane node, TextNode textNode) {
            Line l = (Line)textNode.getUserData();
            if (l != null) {
                l.setEndX(node.getWidth());
            }
        }
    }
}

