/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.index.nexus;

import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.index.nexus.NexusIndexManager;
import org.eclipse.m2e.core.internal.jobs.IBackgroundProcessingQueue;

class IndexUpdaterJob
extends Job
implements IBackgroundProcessingQueue {
    private final Stack<IndexCommand> updateQueue = new Stack();

    public IndexUpdaterJob(NexusIndexManager indexManager) {
        super(Messages.IndexUpdaterJob_title);
        this.setRule(new IndexUpdaterRule());
    }

    public void addCommand(IndexCommand indexCommand) {
        this.updateQueue.add(indexCommand);
    }

    @Override
    public IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(this.getName(), -1);
        ArrayList<IStatus> problems = new ArrayList<IStatus>();
        while (!this.updateQueue.isEmpty()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IndexCommand command = this.updateQueue.pop();
            try {
                command.run(monitor);
            }
            catch (CoreException ex) {
                problems.add(ex.getStatus());
            }
        }
        monitor.done();
        return problems.isEmpty() ? Status.OK_STATUS : new MultiStatus("org.eclipse.m2e.core", -1, problems.toArray(new IStatus[problems.size()]), null, null);
    }

    @Override
    public boolean isEmpty() {
        return this.updateQueue.isEmpty();
    }

    public static interface IndexCommand {
        public void run(IProgressMonitor var1) throws CoreException;
    }

    public static class IndexUpdaterRule
    implements ISchedulingRule {
        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

