/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.ecore;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenRuntimeVersion;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenModelImpl;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenPackageImpl;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.emf.mwe.utils.GenModelHelper;
import org.eclipse.emf.mwe.utils.Mapping;
import org.eclipse.emf.mwe2.ecore.CvsIdFilteringGeneratorAdapterFactoryDescriptor;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandFacade;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.generator.AbstractGeneratorFragment;
import org.eclipse.xtext.generator.BindFactory;
import org.eclipse.xtext.generator.Binding;
import org.eclipse.xtext.generator.GenModelAccess;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtext.generator.util.GenModelUtil2;

public class EMFGeneratorFragment
extends AbstractGeneratorFragment {
    private static final Logger log = Logger.getLogger(EMFGeneratorFragment.class);
    private static final String MODEL_PLUGIN_ID = "modelPluginID";
    private String basePackage = null;
    private String editDirectory = null;
    private String editorDirectory = null;
    private String editorPluginID = null;
    private String editPluginID = null;
    private boolean generateEdit = false;
    private boolean generateEditor = false;
    private String genModel = null;
    private String javaModelDirectory = null;
    private String modelPluginID = null;
    private boolean skipGenerate = false;
    private String xmiModelDirectory = "/generated";
    private boolean xmiModelDirectorySet = false;
    private boolean updateBuildProperties = true;
    private String fileExtensions = null;
    private boolean longFileNames = false;
    private GenRuntimeVersion emfRuntimeVerison;
    private boolean suppressLoadInitialization = false;
    private GenJDKLevel jdkLevel = GenJDKLevel.JDK60_LITERAL;
    private boolean bindEPackageAndEFactory = false;

    public EMFGeneratorFragment() {
        if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("genmodel")) {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("genmodel", new EcoreResourceFactoryImpl());
        }
        GenModelPackage.eINSTANCE.getGenAnnotation();
    }

    private String getLineDelimiter() {
        return this.getNaming().getLineDelimiter();
    }

    protected Resource createResourceForEPackages(Grammar grammar, XpandExecutionContext ctx, List<EPackage> packs, ResourceSet rs) {
        URI ecoreFileUri = this.getEcoreFileUri(grammar, ctx);
        Resource existing = rs.getResource(ecoreFileUri = EMFGeneratorFragment.toPlatformResourceURI(ecoreFileUri), false);
        if (existing != null) {
            existing.unload();
            rs.getResources().remove((Object)existing);
        }
        Resource ecoreFile = rs.createResource(ecoreFileUri, "");
        ecoreFile.getContents().addAll(packs);
        return ecoreFile;
    }

    protected void doGenerate(GenModel genModel) {
        Diagnostic editorDiag;
        Diagnostic editDiag;
        Generator generator = new Generator(){

            public JControlModel getJControlModel() {
                if (this.jControlModel == null) {
                    this.jControlModel = new JControlModel();
                    this.jControlModel.initialize(null, this.options.mergeRulesURI);
                }
                return this.jControlModel;
            }
        };
        generator.getAdapterFactoryDescriptorRegistry().addDescriptor("http://www.eclipse.org/emf/2002/GenModel", (GeneratorAdapterFactory.Descriptor)new CvsIdFilteringGeneratorAdapterFactoryDescriptor(this.getLineDelimiter()));
        genModel.setCanGenerate(true);
        generator.setInput((Object)genModel);
        Diagnostic diagnostic = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)new BasicMonitor());
        if (diagnostic.getSeverity() != 0) {
            log.info((Object)diagnostic);
        }
        if (this.isGenerateEdit() && (editDiag = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", (Monitor)new BasicMonitor())).getSeverity() != 0) {
            log.info((Object)editDiag);
        }
        if (this.isGenerateEditor() && (editorDiag = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", (Monitor)new BasicMonitor())).getSeverity() != 0) {
            log.info((Object)editorDiag);
        }
    }

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        try {
            if (!this.hasGeneratedMetamodel(grammar)) {
                return;
            }
            Grammar clonedGrammar = this.cloneGrammarIntoNewResourceSet(grammar);
            ResourceSet workingResourceSet = clonedGrammar.eResource().getResourceSet();
            List<EPackage> generatedPackages = this.getGeneratedEPackages(clonedGrammar);
            this.registerUsedGenModel(workingResourceSet.getURIConverter());
            if (!generatedPackages.isEmpty()) {
                Map<String, EPackage> usedEPackages = this.findAllUsedEPackages(generatedPackages);
                Map<String, EPackage> loadedEPackages = this.findEPackagesInGenPackages(usedEPackages.keySet(), workingResourceSet);
                Map<EObject, EObject> eNamedElementMapping = this.createENamedElementMapping(usedEPackages, loadedEPackages);
                this.replaceReferencesInGeneratedPackages(generatedPackages, eNamedElementMapping);
                Resource ePackageResource = this.createResourceForEPackages(clonedGrammar, ctx, generatedPackages, workingResourceSet);
                if (!this.skipGenerate) {
                    GenModel genModel = this.getSaveAndReconcileGenModel(workingResourceSet, clonedGrammar, ctx, generatedPackages);
                    genModel.reconcile();
                    this.doGenerate(genModel);
                    if (this.basePackage == null) {
                        this.basePackage = ((GenPackage)genModel.getGenPackages().get(0)).getBasePackage();
                    }
                    super.generate(clonedGrammar, ctx);
                }
                this.saveResource(ePackageResource);
            }
            this.updateBuildProperties(ctx);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateBuildProperties(XpandExecutionContext ctx) throws Exception {
        if (!this.updateBuildProperties || this.modelPluginID != null) {
            return;
        }
        Outlet rootOutlet = ctx.getOutput().getOutlet("PLUGIN");
        Outlet modelOutlet = ctx.getOutput().getOutlet("MODEL");
        String buildPropertiesPath = rootOutlet.getPath() + "/build.properties";
        String modelPath = modelOutlet.getPath().substring(rootOutlet.getPath().length() + 1) + "/";
        Properties buildProperties = new Properties();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(new File(buildPropertiesPath)), Charset.forName(rootOutlet.getFileEncoding()));){
            String existingContent = CharStreams.toString((Readable)reader);
            buildProperties.load((InputStream)new StringInputStream(existingContent, "ISO-8859-1"));
            String binIncludes = buildProperties.getProperty("bin.includes");
            boolean changed = false;
            if (binIncludes == null) {
                existingContent = existingContent + "bin.includes = " + modelPath + Strings.newLine() + "               ";
                changed = true;
            } else if (!binIncludes.contains(modelPath)) {
                existingContent = existingContent.replace("bin.includes = ", "bin.includes = " + modelPath + ",\\" + Strings.newLine() + "               ");
                changed = true;
            }
            if (changed) {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(buildPropertiesPath)), Charset.forName(rootOutlet.getFileEncoding()));
                writer.write(existingContent);
                ((Writer)writer).close();
            }
        }
    }

    private void saveResource(Resource resource) throws IOException {
        HashMap saveOptions = Maps.newHashMap();
        saveOptions.put("URI_HANDLER", new ToPlatformResourceDeresolvingURIHandler());
        saveOptions.put("LINE_DELIMITER", this.getLineDelimiter());
        resource.save((Map)saveOptions);
    }

    private void registerUsedGenModel(URIConverter converter) {
        if (this.genModel == null) {
            return;
        }
        URI genModelUri = URI.createURI((String)this.genModel);
        if (converter.exists(genModelUri = EMFGeneratorFragment.toPlatformResourceURI(genModelUri), null)) {
            try {
                new GenModelHelper().registerGenModel((ResourceSet)new XtextResourceSet(), genModelUri);
            }
            catch (ConfigurationException ce) {
                throw ce;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    private void replaceReferencesInGeneratedPackages(List<EPackage> generatedPackages, Map<EObject, EObject> eNamedElementMapping) {
        TreeIterator packageContentIterator = EcoreUtil.getAllContents(generatedPackages);
        while (packageContentIterator.hasNext()) {
            EObject current = (EObject)packageContentIterator.next();
            EStructuralFeature[] crossReferenceFeatures = ((EClassImpl.FeatureSubsetSupplier)current.eClass().getEAllStructuralFeatures()).crossReferences();
            if (crossReferenceFeatures == null) continue;
            for (EStructuralFeature crossReferenceFeature : crossReferenceFeatures) {
                if (!crossReferenceFeature.isChangeable()) continue;
                EReference reference = (EReference)crossReferenceFeature;
                if (reference.isMany()) {
                    List values = (List)current.eGet((EStructuralFeature)reference);
                    for (int i = 0; i < values.size(); ++i) {
                        EObject value = (EObject)values.get(i);
                        if (!eNamedElementMapping.containsKey(value)) continue;
                        EcoreUtil.replace((EObject)current, (EStructuralFeature)reference, (Object)value, (Object)eNamedElementMapping.get(value));
                    }
                    continue;
                }
                EObject value = (EObject)current.eGet((EStructuralFeature)reference);
                if (!eNamedElementMapping.containsKey(value)) continue;
                EcoreUtil.replace((EObject)current, (EStructuralFeature)reference, (Object)value, (Object)eNamedElementMapping.get(value));
            }
        }
    }

    private Map<EObject, EObject> createENamedElementMapping(Map<String, EPackage> usedEPackages, Map<String, EPackage> loadedEPackages) {
        HashMap result = Maps.newHashMap();
        for (String nsURI : usedEPackages.keySet()) {
            EPackage usedEPackage = usedEPackages.get(nsURI);
            EPackage loadedEPackage = loadedEPackages.get(nsURI);
            this.putMappingData(result, usedEPackage, loadedEPackage);
        }
        return result;
    }

    private void putMappingData(Map<EObject, EObject> result, EPackage usedEPackage, EPackage loadedEPackage) {
        if (loadedEPackage != null && usedEPackage != loadedEPackage) {
            result.put((EObject)usedEPackage, (EObject)loadedEPackage);
            for (EClassifier usedClassifier : usedEPackage.getEClassifiers()) {
                EClassifier loadedClassifier = loadedEPackage.getEClassifier(usedClassifier.getName());
                if (loadedClassifier == null) {
                    throw new RuntimeException("Cannot find classifier '" + usedClassifier.getName() + "' in loaded EPackage from " + loadedEPackage.eResource().getURI());
                }
                result.put((EObject)usedClassifier, (EObject)loadedClassifier);
            }
            block1: for (EPackage usedNestedPackage : usedEPackage.getESubpackages()) {
                for (EPackage loadedNestedPackage : loadedEPackage.getESubpackages()) {
                    if (!usedNestedPackage.getName().equals(loadedNestedPackage.getName())) continue;
                    this.putMappingData(result, usedNestedPackage, loadedNestedPackage);
                    continue block1;
                }
            }
        }
    }

    private Map<String, EPackage> findAllUsedEPackages(List<EPackage> generatedPackages) {
        HashMap result = Maps.newHashMap();
        TreeIterator packageContentIterator = EcoreUtil.getAllContents(generatedPackages);
        while (packageContentIterator.hasNext()) {
            EObject current = (EObject)packageContentIterator.next();
            for (EObject referenced : current.eCrossReferences()) {
                EPackage referencedPackage;
                if (referenced.eIsProxy()) {
                    throw new RuntimeException("Unresolved proxy: " + referenced + " in " + current);
                }
                if (!(referenced instanceof EClassifier) || generatedPackages.contains(referencedPackage = ((EClassifier)referenced).getEPackage())) continue;
                result.put(referencedPackage.getNsURI(), referencedPackage);
            }
        }
        return result;
    }

    private Map<String, EPackage> findEPackagesInGenPackages(Set<String> packageNsURIs, ResourceSet resourceSet) {
        HashMap result = Maps.newHashMap();
        block0: for (String nsURI : packageNsURIs) {
            Resource resource = GenModelAccess.getGenModelResource(null, nsURI, resourceSet);
            if (resource == null) continue;
            for (EObject content : resource.getContents()) {
                if (!(content instanceof GenModel)) continue;
                GenModel loadedGenModel = (GenModel)content;
                GenPackage genPackage = this.findGenPackageByNsURI(loadedGenModel, nsURI);
                result.put(nsURI, genPackage.getEcorePackage());
                continue block0;
            }
        }
        return result;
    }

    private GenPackage findGenPackageByNsURI(GenModel genModel, String nsURI) {
        List allGenPackages = genModel.getAllGenUsedAndStaticGenPackagesWithClassifiers();
        for (GenPackage genPackage : allGenPackages) {
            EPackage ecorePackage = genPackage.getEcorePackage();
            if (ecorePackage == null || ecorePackage.eIsProxy()) {
                throw new RuntimeException("Unresolved proxy: " + ecorePackage + " in " + genModel.eResource().getURI());
            }
            if (!nsURI.equals(ecorePackage.getNsURI())) continue;
            return genPackage;
        }
        throw new RuntimeException("No GenPackage for NsURI " + nsURI + " found in " + genModel.eResource().getURI());
    }

    private boolean hasGeneratedMetamodel(Grammar grammar) {
        Iterable generatedMetamodels = Iterables.filter((Iterable)grammar.getMetamodelDeclarations(), GeneratedMetamodel.class);
        return generatedMetamodels.iterator().hasNext();
    }

    private Grammar cloneGrammarIntoNewResourceSet(Grammar original) {
        Resource originalResource = original.eResource();
        ResourceSet clonedResourceSet = EcoreUtil2.clone((ResourceSet)new XtextResourceSet(), (ResourceSet)originalResource.getResourceSet());
        Resource clonedResource = clonedResourceSet.getResource(originalResource.getURI(), false);
        Grammar clonedGrammar = (Grammar)clonedResource.getContents().get(0);
        return clonedGrammar;
    }

    protected static URI toPlatformResourceURI(URI uri) {
        if (uri.isPlatform()) {
            return uri;
        }
        Map map = EcorePlugin.getPlatformResourceMap();
        for (Map.Entry entries : map.entrySet()) {
            URI newPrefix = URI.createURI((String)("platform:/resource/" + (String)entries.getKey() + "/"));
            URI uri2 = uri.replacePrefix((URI)entries.getValue(), newPrefix);
            if (uri2 == null) continue;
            return uri2;
        }
        return uri;
    }

    protected Set<EPackage> getReferencedEPackages(List<EPackage> packs) {
        HashSet result = Sets.newHashSet();
        for (EPackage pkg : packs) {
            TreeIterator it = pkg.eAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                for (EObject crossRef : obj.eCrossReferences()) {
                    if (crossRef.eIsProxy()) {
                        log.error((Object)("Proxy '" + ((InternalEObject)crossRef).eProxyURI() + "' could not be resolved"));
                        continue;
                    }
                    EPackage p = (EPackage)EcoreUtil2.getContainerOfType((EObject)crossRef, EPackage.class);
                    if (p == null) continue;
                    result.add(p);
                }
            }
        }
        for (EPackage pkg : packs) {
            result.remove(pkg);
        }
        result.remove(EcorePackage.eINSTANCE);
        result.remove(XMLTypePackage.eINSTANCE);
        result.remove(XMLNamespacePackage.eINSTANCE);
        return result;
    }

    protected List<GenPackage> getGenPackagesForPackages(GenModel existingGenModel, Collection<EPackage> packs) {
        ArrayList result = Lists.newArrayList();
        for (EPackage pkg : packs) {
            boolean found = false;
            for (GenPackage gp : existingGenModel.getGenPackages()) {
                if (gp.getEcorePackage() == null || gp.getEcorePackage().getNsURI() == null || !gp.getEcorePackage().getNsURI().equals(pkg.getNsURI())) continue;
                found = true;
            }
            if (found) continue;
            result.add(GenModelAccess.getGenPackage(pkg, existingGenModel.eResource().getResourceSet()));
        }
        Collections.sort(result, new Comparator<GenPackage>(){

            @Override
            public int compare(GenPackage o1, GenPackage o2) {
                return EcoreUtil.getURI((EObject)o1).toString().compareTo(EcoreUtil.getURI((EObject)o2).toString());
            }
        });
        return result;
    }

    public String getBasePackage(Grammar g) {
        if (this.basePackage == null) {
            return GrammarUtil.getNamespace((Grammar)g);
        }
        return this.basePackage;
    }

    protected URI getEcoreFileUri(Grammar grammar, XpandExecutionContext ctx) {
        String javaPath = this.getJavaModelDirectory(ctx);
        String xmiPath = this.getXmiModelDirectory(grammar, javaPath, ctx);
        try {
            String prefix = new File(xmiPath).getCanonicalPath() + File.separator + this.getModelName(grammar);
            URI ecoreFileUri = URI.createFileURI((String)(prefix + ".ecore"));
            return ecoreFileUri;
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't compute canonical path for " + new File(xmiPath).getAbsolutePath());
        }
    }

    public String getEditDirectory(XpandExecutionContext ctx) {
        if (this.editDirectory == null || "".equals(this.editDirectory)) {
            return ctx.getOutput().getOutlet("PLUGIN").getPath() + ".edit/src";
        }
        return this.editDirectory;
    }

    public String getEditorDirectory(XpandExecutionContext ctx) {
        if (this.editorDirectory == null || "".equals(this.editorDirectory)) {
            return ctx.getOutput().getOutlet("PLUGIN").getPath() + ".editor/src";
        }
        return this.editorDirectory;
    }

    protected String getEditorPluginID(XpandExecutionContext ctx) {
        if ((this.editorPluginID == null || "".equals(this.editorPluginID)) && this.getModelPluginID(ctx) != null) {
            return this.getModelPluginID(ctx) + ".editor";
        }
        return this.editorPluginID;
    }

    public String getEditPluginID(XpandExecutionContext ctx) {
        if ((this.editPluginID == null || "".equals(this.editPluginID)) && this.getModelPluginID(ctx) != null) {
            return this.getModelPluginID(ctx) + ".edit";
        }
        return this.editPluginID;
    }

    @Override
    public String[] getExportedPackagesRt(Grammar grammar) {
        List typeSelect = EcoreUtil2.typeSelect((List)grammar.getMetamodelDeclarations(), GeneratedMetamodel.class);
        LinkedHashSet<String> exportedPackages = new LinkedHashSet<String>();
        if (this.modelPluginID == null) {
            for (GeneratedMetamodel generatedMetamodel : typeSelect) {
                String modelPackage = Strings.skipLastToken((String)this.getGeneratedEPackageName(grammar, generatedMetamodel.getEPackage()), (String)".");
                exportedPackages.add(modelPackage);
                exportedPackages.add(modelPackage + ".impl");
                exportedPackages.add(modelPackage + ".util");
            }
        }
        return exportedPackages.toArray(new String[exportedPackages.size()]);
    }

    public String getGeneratedEPackageName(Grammar g, EPackage pack) {
        return this.getBasePackage(g) + "." + pack.getName() + "." + Strings.toFirstUpper((String)pack.getName()) + "Package";
    }

    protected List<EPackage> getGeneratedEPackages(Grammar grammar) {
        List list = EcoreUtil2.typeSelect((List)grammar.getMetamodelDeclarations(), GeneratedMetamodel.class);
        List packs = EcoreUtil2.collect((Collection)list, (int)0, EPackage.class);
        return packs;
    }

    protected GenModel getGenModel(ResourceSet rs, Grammar grammar, XpandExecutionContext ctx, List<EPackage> packs) {
        GenModelImpl genModel;
        URI genModelUri = this.getGenModelUri(grammar, ctx);
        Resource resource = rs.getResource(genModelUri = EMFGeneratorFragment.toPlatformResourceURI(genModelUri), false);
        if (resource != null) {
            resource.unload();
            rs.getResources().remove((Object)resource);
        }
        Resource genModelFile = rs.createResource(genModelUri, "");
        if (rs.getURIConverter().exists(genModelUri, null)) {
            try {
                genModelFile.load(null);
            }
            catch (IOException e) {
                throw new WrappedException((Exception)e);
            }
            genModel = genModelUri.hasFragment() ? (GenModel)genModelFile.getEObject(genModelUri.fragment()) : (GenModel)genModelFile.getContents().get(0);
        } else {
            genModel = new GenModelImpl(){

                public GenPackage createGenPackage() {
                    return new GenPackageImpl(){

                        public String getSerializedPackageFilename() {
                            return this.getName() + ".loadinitialization_ecore";
                        }
                    };
                }
            };
            genModel.setModelDirectory(this.toGenModelProjectPath(this.getJavaModelDirectory(ctx)));
            genModel.setModelName(this.getModelName(grammar));
            genModel.setModelPluginID(this.getModelPluginID(ctx));
            genModel.setEditDirectory(this.toGenModelProjectPath(this.getEditDirectory(ctx)));
            genModel.setEditorDirectory(this.toGenModelProjectPath(this.getEditorDirectory(ctx)));
            genModel.setEditPluginID(this.getEditPluginID(ctx));
            genModel.setEditorPluginID(this.getEditorPluginID(ctx));
            genModel.setValidateModel(false);
            genModel.setForceOverwrite(true);
            genModel.setCanGenerate(true);
            genModel.setFacadeHelperClass(null);
            genModel.setBundleManifest(true);
            genModel.setUpdateClasspath(false);
            genModel.setComplianceLevel(this.jdkLevel);
            genModel.setRuntimeVersion(this.emfRuntimeVerison);
            genModel.setRootExtendsClass("org.eclipse.emf.ecore.impl.MinimalEObjectImpl$Container");
            genModel.setLineDelimiter(this.getLineDelimiter());
        }
        genModelFile.getContents().add((Object)genModel);
        return genModel;
    }

    protected URI getGenModelUri(Grammar grammar, XpandExecutionContext ctx) {
        String prefix;
        if (this.genModel != null) {
            return URI.createURI((String)this.genModel);
        }
        try {
            prefix = new File(this.getXmiModelDirectory(grammar, this.getJavaModelDirectory(ctx), ctx)).getCanonicalPath() + File.separator + this.getModelName(grammar);
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
        URI genModelUri = URI.createFileURI((String)(prefix + ".genmodel"));
        return genModelUri;
    }

    protected String getJavaModelDirectory(XpandExecutionContext ctx) {
        String javaPath = this.javaModelDirectory == null || "".equals(this.javaModelDirectory) ? ctx.getOutput().getOutlet("SRC_GEN").getPath() : this.javaModelDirectory;
        return javaPath;
    }

    protected String getModelName(Grammar grammar) {
        String grammarName = grammar.getName();
        if (this.isLongFileNames()) {
            return grammarName.replace('.', '_');
        }
        return grammarName.substring(grammarName.lastIndexOf(46) + 1);
    }

    public String getModelPluginID(XpandExecutionContext ctx) {
        if ((this.modelPluginID == null || "".equals(this.modelPluginID)) && ctx.getVariable(MODEL_PLUGIN_ID) != null) {
            return (String)ctx.getVariable(MODEL_PLUGIN_ID).getValue();
        }
        return this.modelPluginID;
    }

    @Override
    protected List<Object> getParameters(Grammar grammar) {
        return Collections.singletonList(this.getBasePackage(grammar));
    }

    private List<Object> getParameters(Grammar grammar, XpandExecutionContext ctx) {
        try {
            File projectRootFile = new File(ctx.getOutput().getOutlet("PLUGIN").getPath());
            String projectRoot = projectRootFile.getCanonicalPath();
            URI genmodelURI = this.getGenModelUri(grammar, ctx);
            if (genmodelURI.toFileString().startsWith(projectRoot)) {
                URI relative = genmodelURI.deresolve(URI.createFileURI((String)projectRoot).appendSegment(""));
                String genModelPath = relative.toString();
                return Lists.newArrayList((Object[])new Object[]{this.getBasePackage(grammar), genModelPath});
            }
            throw new ConfigurationException("Invalid configuration of genmodel location: " + genmodelURI + "  and project root: " + projectRoot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addToPluginXmlRt(Grammar grammar, XpandExecutionContext ctx) {
        XpandFacade.create((XpandExecutionContext)ctx).evaluate2(this.getTemplate() + "::addToPluginXmlRt", (Object)grammar, this.getParameters(grammar, ctx));
    }

    @Override
    public String[] getRequiredBundlesRt(Grammar grammar) {
        return new String[]{"org.eclipse.emf.ecore", "org.eclipse.emf.common"};
    }

    protected GenModel getSaveAndReconcileGenModel(ResourceSet rs, Grammar grammar, XpandExecutionContext ctx, List<EPackage> packs) throws ConfigurationException {
        GenModel genModel = this.getGenModel(rs, grammar, ctx, packs);
        genModel.initialize(packs);
        for (GenPackage genPackage : genModel.getGenPackages()) {
            genPackage.setBasePackage(this.getBasePackage(grammar));
            if (this.isSuppressLoadInitialization()) {
                genPackage.setLoadInitialization(false);
            }
            if (this.getFileExtensions() == null || !packs.contains(genPackage.getEcorePackage())) continue;
            genPackage.setFileExtensions(this.getFileExtensions());
        }
        Set<EPackage> referencedEPackages = this.getReferencedEPackages(packs);
        List<GenPackage> usedGenPackages = this.getGenPackagesForPackages(genModel, referencedEPackages);
        this.reconcileMissingGenPackagesInUsedModels(usedGenPackages);
        genModel.getUsedGenPackages().addAll(usedGenPackages);
        try {
            this.saveResource(genModel.eResource());
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
        new GenModelHelper().registerGenModel(genModel);
        return genModel;
    }

    private void reconcileMissingGenPackagesInUsedModels(List<GenPackage> usedGenPackages) {
        HashSet processedModels = Sets.newHashSet();
        for (GenPackage usedGenPackage : usedGenPackages) {
            GenModel genModel = usedGenPackage.getGenModel();
            if (!processedModels.add(genModel)) continue;
            List missingPackages = genModel.getMissingPackages();
            List<GenPackage> missingGenPackages = this.getGenPackagesForPackages(genModel, missingPackages);
            genModel.getUsedGenPackages().addAll(missingGenPackages);
        }
    }

    public String getXmiModelDirectory() {
        return this.xmiModelDirectory;
    }

    protected String getXmiModelDirectory(Grammar grammar, String javaPath, XpandExecutionContext ctx) {
        String xmiPath = this.getXmiModelDirectory() == null || "".equals(this.getXmiModelDirectory()) ? javaPath + "/" + grammar.getName().substring(0, grammar.getName().lastIndexOf(46)).replace('.', '/') : (this.xmiModelDirectorySet ? this.getXmiModelDirectory() : ctx.getOutput().getOutlet("MODEL").getPath() + this.getXmiModelDirectory());
        return xmiPath;
    }

    public boolean isGenerateEdit() {
        return this.generateEdit;
    }

    public boolean isGenerateEditor() {
        return this.generateEditor;
    }

    public boolean isSkipGenerate() {
        return this.skipGenerate;
    }

    public void setBasePackage(String basePackage) {
        if ("".equals(basePackage.trim())) {
            return;
        }
        this.basePackage = basePackage;
    }

    public void setEmfRuntimeVersion(String emfRuntimeVersion) {
        this.emfRuntimeVerison = GenRuntimeVersion.get((String)emfRuntimeVersion);
        if (this.emfRuntimeVerison == null) {
            log.warn((Object)("Illegal EMF runtime verison " + emfRuntimeVersion + ". Using default version instead."));
        }
    }

    public void setEditDirectory(String editDirectory) {
        this.editDirectory = editDirectory;
    }

    public void setEditorDirectory(String editorDirectory) {
        this.editorDirectory = editorDirectory;
    }

    public void setEditorPluginID(String editorPluginId) {
        this.editorPluginID = editorPluginId;
    }

    public void setEditPluginID(String editPluginId) {
        this.editPluginID = editPluginId;
    }

    public void setGenerateEdit(boolean gen) {
        this.generateEdit = gen;
    }

    public void setGenerateEditor(boolean gen) {
        this.generateEditor = gen;
    }

    public void setGenModel(String genModel) {
        if ("".equals(genModel)) {
            return;
        }
        this.genModel = genModel;
    }

    public void setJavaModelDirectory(String dir) {
        this.javaModelDirectory = dir;
    }

    public void setModelPluginID(String modelPluginId) {
        this.modelPluginID = modelPluginId;
    }

    public void setSkipGenerate(boolean skipGenerate) {
        this.skipGenerate = skipGenerate;
    }

    public void setXmiModelDirectory(String dir) {
        this.xmiModelDirectory = dir;
        this.xmiModelDirectorySet = true;
    }

    public void setLongFileNames(boolean longFileNames) {
        this.longFileNames = longFileNames;
    }

    public boolean isLongFileNames() {
        return this.longFileNames;
    }

    public void setUpdateBuildProperties(boolean updateBuildProperties) {
        this.updateBuildProperties = updateBuildProperties;
    }

    public boolean isUpdateBuildProperties() {
        return this.updateBuildProperties;
    }

    protected String toGenModelProjectPath(String path) {
        return null == path || "".equals(path) || path.startsWith("/") || !path.contains("/") ? path : path.substring(path.indexOf("/"));
    }

    @Deprecated
    public void addSaveMapping(Mapping mapping) {
        log.warn((Object)"Save mappings are no longer supported. The EcoreGeneratorFragment will use the uri that is given in the referenced genmodel or create a platform resource uri for new files.");
    }

    public void setFileExtensions(String fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public String getFileExtensions() {
        return this.fileExtensions;
    }

    public void setSuppressLoadInitialization(boolean suppressLoadInitialization) {
        this.suppressLoadInitialization = suppressLoadInitialization;
    }

    public boolean isSuppressLoadInitialization() {
        return this.suppressLoadInitialization;
    }

    public void setJdkLevel(String jdkLevel) {
        GenJDKLevel l = GenJDKLevel.getByName((String)jdkLevel);
        Assert.isNotNull((Object)l, (String)"Invalid JDK level");
        this.jdkLevel = l;
    }

    public String getJdkLevel() {
        return this.jdkLevel.getName();
    }

    public void setBindEPackageAndEFactory(boolean bindEPackageAndEFactory) {
        this.bindEPackageAndEFactory = bindEPackageAndEFactory;
    }

    public boolean isBindEPackageAndEFactory() {
        return this.bindEPackageAndEFactory;
    }

    @Override
    public Set<Binding> getGuiceBindingsRt(Grammar grammar) {
        if (this.isBindEPackageAndEFactory()) {
            BindFactory bindFactory = new BindFactory();
            for (EPackage pkg : this.getGeneratedEPackages(grammar)) {
                GenPackage genPkg = GenModelUtil2.getGenPackage((EPackage)pkg, (ResourceSet)grammar.eResource().getResourceSet());
                bindFactory.addTypeToInstance(genPkg.getQualifiedPackageInterfaceName(), genPkg.getQualifiedPackageInterfaceName() + ".eINSTANCE").addTypeToInstance(genPkg.getQualifiedFactoryInterfaceName(), genPkg.getQualifiedFactoryInterfaceName() + ".eINSTANCE");
            }
            return bindFactory.getBindings();
        }
        return Collections.emptySet();
    }

    public static class ToPlatformResourceDeresolvingURIHandler
    extends URIHandlerImpl.AbsoluteCrossBundleAware {
        public URI deresolve(URI uri) {
            return super.deresolve(EMFGeneratorFragment.toPlatformResourceURI(uri));
        }
    }
}

