package org.eclipse.fx.formats.svg.fx;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fx.formats.svg.fx.FXToSvgUtils;
import org.eclipse.fx.formats.svg.svg.PresentationAttributes;
import org.eclipse.fx.formats.svg.svg.SpreadMethod;
import org.eclipse.fx.formats.svg.svg.SvgDefsElement;
import org.eclipse.fx.formats.svg.svg.SvgElement;
import org.eclipse.fx.formats.svg.svg.SvgFactory;
import org.eclipse.fx.formats.svg.svg.SvgLinearGradientElement;
import org.eclipse.fx.formats.svg.svg.SvgPathElement;
import org.eclipse.fx.formats.svg.svg.SvgRectElement;
import org.eclipse.fx.formats.svg.svg.SvgStopElement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class PresentationAttributesUtil {
  private Supplier<SvgDefsElement> defSupplier;
  
  public PresentationAttributesUtil(final Supplier<SvgDefsElement> defSupplier) {
    this.defSupplier = defSupplier;
  }
  
  public List<SvgElement> createBorder(final Border b, final Region r) {
    boolean _equals = Objects.equal(b, null);
    if (_equals) {
      return Collections.<SvgElement>emptyList();
    } else {
      final Function1<BorderStroke, List<SvgElement>> _function = new Function1<BorderStroke, List<SvgElement>>() {
        @Override
        public List<SvgElement> apply(final BorderStroke it) {
          return PresentationAttributesUtil.this.createBorderStroke(it, r);
        }
      };
      return IterableExtensions.<SvgElement>toList(Iterables.<SvgElement>concat(ListExtensions.<BorderStroke, List<SvgElement>>map(b.getStrokes(), _function)));
    }
  }
  
  public List<SvgElement> createBorderStroke(final BorderStroke s, final Region r) {
    final boolean w = (((s.getWidths().getBottom() == s.getWidths().getLeft()) && (s.getWidths().getBottom() == s.getWidths().getRight())) && (s.getWidths().getBottom() == s.getWidths().getTop()));
    final boolean c = ((Objects.equal(s.getBottomStroke(), s.getLeftStroke()) && Objects.equal(s.getBottomStroke(), s.getRightStroke())) && Objects.equal(s.getBottomStroke(), s.getTopStroke()));
    final boolean st = ((Objects.equal(s.getBottomStyle(), s.getLeftStyle()) && Objects.equal(s.getBottomStyle(), s.getRightStyle())) && Objects.equal(s.getBottomStyle(), s.getTopStyle()));
    if ((((w && c) && st) && PresentationAttributesUtil.checkRadii(s.getRadii()))) {
      final SvgRectElement rv = SvgFactory.eINSTANCE.createSvgRectElement();
      rv.setFill("transparent");
      double _minX = r.getLayoutBounds().getMinX();
      double _left = s.getInsets().getLeft();
      rv.setX(Double.valueOf((_minX + _left)).toString());
      double _minY = r.getLayoutBounds().getMinY();
      double _top = s.getInsets().getTop();
      rv.setY(Double.valueOf((_minY + _top)).toString());
      double _width = r.getLayoutBounds().getWidth();
      double _left_1 = s.getInsets().getLeft();
      double _minus = (_width - _left_1);
      double _right = s.getInsets().getRight();
      rv.setWidth(Double.valueOf((_minus - _right)).toString());
      double _height = r.getLayoutBounds().getHeight();
      double _top_1 = s.getInsets().getTop();
      double _minus_1 = (_height - _top_1);
      double _bottom = s.getInsets().getBottom();
      rv.setHeight(Double.valueOf((_minus_1 - _bottom)).toString());
      rv.setStroke_width(Double.valueOf(s.getWidths().getBottom()).toString());
      this.applyStroke(rv, s.getBottomStroke());
      return Collections.<SvgElement>singletonList(rv);
    } else {
      InputOutput.<String>println("====> Dup actions");
    }
    return Collections.<SvgElement>emptyList();
  }
  
  public static boolean checkRadii(final CornerRadii r) {
    final boolean rx = (((r.getBottomLeftHorizontalRadius() == r.getBottomRightHorizontalRadius()) && (r.getBottomLeftHorizontalRadius() == r.getTopLeftHorizontalRadius())) && (r.getBottomLeftHorizontalRadius() == r.getTopRightHorizontalRadius()));
    final boolean ry = (((r.getBottomLeftVerticalRadius() == r.getBottomRightVerticalRadius()) && (r.getBottomLeftVerticalRadius() == r.getTopLeftVerticalRadius())) && (r.getBottomLeftVerticalRadius() == r.getTopRightVerticalRadius()));
    return (rx && ry);
  }
  
  public SvgElement createBackgroundFill(final BackgroundFill f, final Region r) {
    boolean _checkRadii = PresentationAttributesUtil.checkRadii(f.getRadii());
    if (_checkRadii) {
      final SvgRectElement rv = SvgFactory.eINSTANCE.createSvgRectElement();
      rv.setRx(Double.valueOf(f.getRadii().getBottomLeftHorizontalRadius()).toString());
      rv.setRy(Double.valueOf(f.getRadii().getBottomLeftVerticalRadius()).toString());
      rv.setX(Double.valueOf(f.getInsets().getLeft()).toString());
      rv.setY(Double.valueOf(f.getInsets().getTop()).toString());
      double _width = r.getLayoutBounds().getWidth();
      double _left = f.getInsets().getLeft();
      double _minus = (_width - _left);
      double _right = f.getInsets().getRight();
      rv.setWidth(Double.valueOf((_minus - _right)).toString());
      double _height = r.getLayoutBounds().getHeight();
      double _top = f.getInsets().getTop();
      double _minus_1 = (_height - _top);
      double _bottom = f.getInsets().getBottom();
      rv.setHeight(Double.valueOf((_minus_1 - _bottom)).toString());
      rv.setFill("transparent");
      this.applyFill(rv, f.getFill());
      String _plus = (r + " ===> ");
      String _fill = rv.getFill();
      String _plus_1 = (_plus + _fill);
      String _plus_2 = (_plus_1 + "; ");
      Paint _fill_1 = f.getFill();
      String _plus_3 = (_plus_2 + _fill_1);
      InputOutput.<String>println(_plus_3);
      return rv;
    } else {
      final SvgPathElement rv_1 = SvgFactory.eINSTANCE.createSvgPathElement();
      return rv_1;
    }
  }
  
  protected void _applyFill(final PresentationAttributes e, final Color p) {
    e.setFill(FXToSvgUtils.toRGBHex(p));
    double _opacity = p.getOpacity();
    boolean _notEquals = (_opacity != 1.0);
    if (_notEquals) {
      e.setFill_opacity(Double.valueOf(p.getOpacity()).toString());
    }
  }
  
  protected void _applyFill(final PresentationAttributes e, final ImagePattern p) {
    System.err.println("ImagePattern not yet supported");
  }
  
  protected void _applyFill(final PresentationAttributes e, final LinearGradient p) {
    SvgLinearGradientElement l = SvgFactory.eINSTANCE.createSvgLinearGradientElement();
    l.setId(EcoreUtil.generateUUID());
    String _xifexpression = null;
    boolean _isProportional = p.isProportional();
    if (_isProportional) {
      _xifexpression = FXToSvgUtils.toProportion(p.getStartX());
    } else {
      _xifexpression = Double.valueOf(p.getStartX()).toString();
    }
    l.setX1(_xifexpression);
    String _xifexpression_1 = null;
    boolean _isProportional_1 = p.isProportional();
    if (_isProportional_1) {
      _xifexpression_1 = FXToSvgUtils.toProportion(p.getEndX());
    } else {
      _xifexpression_1 = Double.valueOf(p.getEndX()).toString();
    }
    l.setX2(_xifexpression_1);
    String _xifexpression_2 = null;
    boolean _isProportional_2 = p.isProportional();
    if (_isProportional_2) {
      _xifexpression_2 = FXToSvgUtils.toProportion(p.getStartY());
    } else {
      _xifexpression_2 = Double.valueOf(p.getStartY()).toString();
    }
    l.setY1(_xifexpression_2);
    String _xifexpression_3 = null;
    boolean _isProportional_3 = p.isProportional();
    if (_isProportional_3) {
      _xifexpression_3 = FXToSvgUtils.toProportion(p.getEndY());
    } else {
      _xifexpression_3 = Double.valueOf(p.getEndY()).toString();
    }
    l.setY2(_xifexpression_3);
    l.setSpreadMethod(PresentationAttributesUtil.toSpread(p.getCycleMethod()));
    List<Stop> _stops = p.getStops();
    for (final Stop s : _stops) {
      EList<SvgElement> _children = l.getChildren();
      SvgStopElement _stop = PresentationAttributesUtil.toStop(s);
      _children.add(_stop);
    }
    EList<SvgElement> _children_1 = this.defSupplier.get().getChildren();
    _children_1.add(l);
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("url(#");
    String _id = l.getId();
    _builder.append(_id);
    _builder.append(")");
    e.setFill(_builder.toString());
  }
  
  protected void _applyFill(final PresentationAttributes e, final RadialGradient p) {
    System.err.println("RadialGradient not yet supported");
  }
  
  protected void _applyStroke(final PresentationAttributes e, final Color p) {
    e.setStroke(FXToSvgUtils.toRGBHex(p));
    double _opacity = p.getOpacity();
    boolean _notEquals = (_opacity != 0.0);
    if (_notEquals) {
      e.setStroke_opacity(Double.valueOf(p.getOpacity()).toString());
    }
  }
  
  protected void _applyStroke(final PresentationAttributes e, final ImagePattern p) {
    System.err.println("ImagePattern not yet supported");
  }
  
  protected void _applyStroke(final PresentationAttributes e, final LinearGradient p) {
    SvgLinearGradientElement l = SvgFactory.eINSTANCE.createSvgLinearGradientElement();
    l.setId(EcoreUtil.generateUUID());
    String _xifexpression = null;
    boolean _isProportional = p.isProportional();
    if (_isProportional) {
      _xifexpression = FXToSvgUtils.toProportion(p.getStartX());
    } else {
      _xifexpression = Double.valueOf(p.getStartX()).toString();
    }
    l.setX1(_xifexpression);
    String _xifexpression_1 = null;
    boolean _isProportional_1 = p.isProportional();
    if (_isProportional_1) {
      _xifexpression_1 = FXToSvgUtils.toProportion(p.getEndX());
    } else {
      _xifexpression_1 = Double.valueOf(p.getEndX()).toString();
    }
    l.setX2(_xifexpression_1);
    String _xifexpression_2 = null;
    boolean _isProportional_2 = p.isProportional();
    if (_isProportional_2) {
      _xifexpression_2 = FXToSvgUtils.toProportion(p.getStartY());
    } else {
      _xifexpression_2 = Double.valueOf(p.getStartY()).toString();
    }
    l.setY1(_xifexpression_2);
    String _xifexpression_3 = null;
    boolean _isProportional_3 = p.isProportional();
    if (_isProportional_3) {
      _xifexpression_3 = FXToSvgUtils.toProportion(p.getEndY());
    } else {
      _xifexpression_3 = Double.valueOf(p.getEndY()).toString();
    }
    l.setY2(_xifexpression_3);
    l.setSpreadMethod(PresentationAttributesUtil.toSpread(p.getCycleMethod()));
    List<Stop> _stops = p.getStops();
    for (final Stop s : _stops) {
      EList<SvgElement> _children = l.getChildren();
      SvgStopElement _stop = PresentationAttributesUtil.toStop(s);
      _children.add(_stop);
    }
    EList<SvgElement> _children_1 = this.defSupplier.get().getChildren();
    _children_1.add(l);
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("url(#");
    String _id = l.getId();
    _builder.append(_id);
    _builder.append(")");
    e.setStroke(_builder.toString());
  }
  
  protected void _applyStroke(final PresentationAttributes e, final RadialGradient p) {
    System.err.println("RadialGradient not yet supported");
  }
  
  public static SvgStopElement toStop(final Stop s) {
    SvgStopElement e = SvgFactory.eINSTANCE.createSvgStopElement();
    e.setStop_color(FXToSvgUtils.toRGBHex(s.getColor()));
    e.setOffset(Double.valueOf(s.getOffset()).toString());
    return e;
  }
  
  public static SpreadMethod toSpread(final CycleMethod cm) {
    SpreadMethod _switchResult = null;
    if (cm != null) {
      switch (cm) {
        case NO_CYCLE:
          _switchResult = SpreadMethod.PAD;
          break;
        case REFLECT:
          _switchResult = SpreadMethod.REFLECT;
          break;
        case REPEAT:
          _switchResult = SpreadMethod.REPEAT;
          break;
        default:
          break;
      }
    }
    return _switchResult;
  }
  
  public void applyFill(final PresentationAttributes e, final Paint p) {
    if (p instanceof Color) {
      _applyFill(e, (Color)p);
      return;
    } else if (p instanceof ImagePattern) {
      _applyFill(e, (ImagePattern)p);
      return;
    } else if (p instanceof LinearGradient) {
      _applyFill(e, (LinearGradient)p);
      return;
    } else if (p instanceof RadialGradient) {
      _applyFill(e, (RadialGradient)p);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(e, p).toString());
    }
  }
  
  public void applyStroke(final PresentationAttributes e, final Paint p) {
    if (p instanceof Color) {
      _applyStroke(e, (Color)p);
      return;
    } else if (p instanceof ImagePattern) {
      _applyStroke(e, (ImagePattern)p);
      return;
    } else if (p instanceof LinearGradient) {
      _applyStroke(e, (LinearGradient)p);
      return;
    } else if (p instanceof RadialGradient) {
      _applyStroke(e, (RadialGradient)p);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(e, p).toString());
    }
  }
}
