/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.ui.mobile.sim.device;

import java.util.Collection;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.eclipse.fx.ide.ui.mobile.sim.device.BasicDevice;
import org.eclipse.fx.ide.ui.mobile.sim.device.android.galaxyNote2.AndroidTabletHorizontalDevice;
import org.eclipse.fx.ide.ui.mobile.sim.device.android.galaxyNote2.AndroidTabletVerticalDevice;
import org.eclipse.fx.ide.ui.mobile.sim.device.android.galaxyS3.AndroidPhoneHorizontalDevice;
import org.eclipse.fx.ide.ui.mobile.sim.device.android.galaxyS3.AndroidPhoneVerticalDevice;
import org.eclipse.fx.ide.ui.mobile.sim.device.ios.ipad.AppleIPadHorizontalDevice;
import org.eclipse.fx.ide.ui.mobile.sim.device.ios.ipad.AppleIPadVerticalDevice;
import org.eclipse.fx.ide.ui.mobile.sim.device.ios.iphone.AppleIPhone4HorizontalDevice;
import org.eclipse.fx.ide.ui.mobile.sim.device.ios.iphone.AppleIPhone4VerticalDevice;
import org.eclipse.fx.ui.mobile.MobileApp;

public class MobileDeviceSimulator
extends Application {
    public static final String DEVICE_TYPE = "-deviceType";
    public static final String DEVICE_ORIENTATION = "-deviceOrientation";
    public static final String DISPLAYSIZE = "-displaySize";
    public static final String APPLICATION_CLASS = "-applicationClass";
    private static String[] ARGS;

    public static void main(String[] args) {
        ARGS = args;
        MobileDeviceSimulator.launch((String[])args);
    }

    public void start(Stage primaryStage) throws Exception {
        BasicDevice dev = this.createDevice();
        Parent root = (Parent)dev.getSimulatorNode();
        String mainClass = MobileDeviceSimulator.findParam(APPLICATION_CLASS, null);
        if (mainClass != null) {
            Class<?> clazz = Class.forName(mainClass);
            MobileApp app = (MobileApp)clazz.newInstance();
            root.getStylesheets().addAll((Collection)app.getInitialStylesheets());
            dev.setContent((Node)app.createUI());
        }
        primaryStage.setScene(new Scene(root));
        primaryStage.show();
    }

    private BasicDevice createDevice() {
        String type = MobileDeviceSimulator.findParam(DEVICE_TYPE, "IPHONE");
        String orientation = MobileDeviceSimulator.findParam(DEVICE_ORIENTATION, "VERTICAL");
        String displaySize = MobileDeviceSimulator.findParam(DISPLAYSIZE, "768x1024");
        int width = Integer.parseInt(displaySize.substring(0, displaySize.indexOf(120)));
        int height = Integer.parseInt(displaySize.substring(displaySize.indexOf(120) + 1));
        if (orientation.equals("VERTICAL")) {
            if ("ANDROID_PHONE".equals(type)) {
                return new AndroidPhoneVerticalDevice(width, height);
            }
            if ("ANDROID_TABLET".equals(type)) {
                return new AndroidTabletVerticalDevice(width, height);
            }
            if ("IPAD".equals(type)) {
                return new AppleIPadVerticalDevice(width, height);
            }
            return new AppleIPhone4VerticalDevice(width, height);
        }
        if ("ANDROID_PHONE".equals(type)) {
            return new AndroidPhoneHorizontalDevice(width, height);
        }
        if ("ANDROID_TABLET".equals(type)) {
            return new AndroidTabletHorizontalDevice(width, height);
        }
        if ("IPAD".equals(type)) {
            return new AppleIPadHorizontalDevice(width, height);
        }
        return new AppleIPhone4HorizontalDevice(width, height);
    }

    private static String findParam(String name, String defaultValue) {
        int i = 0;
        while (i < ARGS.length) {
            if (name.equals(ARGS[i])) {
                return ARGS[i + 1];
            }
            ++i;
        }
        return defaultValue;
    }
}

