/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.ui.util;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class RelativeFileLocator {
    public static File locateFile(IFile file, String filePath) {
        URI uri = URI.createPlatformResourceURI((String)(String.valueOf(file.getProject().getName()) + "/" + file.getProjectRelativePath().toString()), (boolean)true);
        return RelativeFileLocator.locateFile(uri, filePath);
    }

    public static File locateFile(URI uri, String filePath) {
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(uri.segment(1));
        IJavaProject jp = JavaCore.create((IProject)p);
        if (filePath.startsWith("/")) {
            IFile f = p.getFile(filePath = filePath.substring(1));
            if (f.exists()) {
                return f.getLocation().toFile().getAbsoluteFile();
            }
            if (jp != null) {
                try {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = jp.getPackageFragmentRoots();
                    int n = iPackageFragmentRootArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFolder folder;
                        IPackageFragmentRoot r = iPackageFragmentRootArray[n2];
                        if (!r.isArchive() && r.getResource() instanceof IFolder && (folder = (IFolder)r.getResource()).exists() && (f = folder.getFile(filePath)).exists()) {
                            return f.getLocation().toFile().getAbsoluteFile();
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        } else {
            URI fileUri = null;
            try {
                fileUri = URI.createURI((String)filePath);
            }
            catch (Exception exception) {}
            if (fileUri != null && fileUri.isPlatformResource()) {
                Path path = new Path(fileUri.toPlatformString(true));
                IWorkspaceRoot root = jp.getProject().getWorkspace().getRoot();
                IFile file = root.getFile((IPath)path);
                if (file.exists()) {
                    return file.getLocation().toFile().getAbsoluteFile();
                }
            } else {
                IFile f;
                Object path = null;
                int i = 2;
                while (i < uri.segmentCount() - 1) {
                    path = path == null ? new Path(uri.segment(i)) : path.append(uri.segment(i));
                    ++i;
                }
                if (path != null && (f = p.getFile(path.append(filePath))).exists()) {
                    return f.getLocation().toFile().getAbsoluteFile();
                }
            }
        }
        return null;
    }
}

