/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.model.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.fx.ide.model.FXPlugin;
import org.eclipse.fx.ide.model.IFXClass;
import org.eclipse.fx.ide.model.IFXProperty;
import org.eclipse.fx.ide.model.internal.utils.PropertiesUtil;
import org.eclipse.fx.ide.model.internal.utils.Util;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class FXClass
implements IFXClass {
    private static final int STATE_DEFAULT_RESOLVED = 1;
    private IFXClass superClass;
    private IType type;
    private IJavaProject javaProject;
    private int state = 0;
    private IFXProperty defaultProperty;
    private Map<String, IFXProperty> properties;
    private Map<String, IFXProperty> staticProperties;
    private IMethod valueOfMethod;

    public FXClass(IJavaProject jp, IType type) {
        this.type = type;
        this.javaProject = jp;
        try {
            String s = type.getSuperclassName();
            if (s != null) {
                s = Util.getFQNType(type, Signature.getTypeErasure((String)s));
                this.superClass = FXPlugin.getClassmodel().findClass(jp, jp.findType(s));
            }
        }
        catch (JavaModelException e) {
            FXPlugin.getLogger().log(1, "Unable to retrieve superclass name of '" + type.getFullyQualifiedName() + "'", (Throwable)e);
        }
    }

    @Override
    public String getFQN() {
        return this.type.getFullyQualifiedName();
    }

    @Override
    public IType getType() {
        return this.type;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    @Override
    public String getSimpleName() {
        return this.type.getElementName();
    }

    @Override
    public IFXProperty getDefaultProperty() {
        if (!Util.checkStatemask(this.state, 1)) {
            IAnnotation annotation = this.type.getAnnotation("javafx.beans.DefaultProperty");
            if (annotation.exists()) {
                try {
                    String v = (String)Util.getAnnotationMemberValue(annotation, "value");
                    if (v != null) {
                        this.defaultProperty = this.getProperty(v);
                    }
                }
                catch (JavaModelException e) {
                    FXPlugin.getLogger().log(1, "Unable to retrieve default annotation value for '" + this.type.getFullyQualifiedName() + "'", (Throwable)e);
                }
            }
            this.state |= 1;
        }
        if (this.defaultProperty == null && this.superClass != null) {
            return this.superClass.getDefaultProperty();
        }
        return this.defaultProperty;
    }

    @Override
    public IFXProperty getProperty(String name) {
        Map<String, IFXProperty> props = this.getAllProperties();
        return props.get(name);
    }

    @Override
    public Map<String, IFXProperty> getAllProperties() {
        HashMap<String, IFXProperty> rv = new HashMap<String, IFXProperty>();
        if (this.superClass != null) {
            rv.putAll(this.superClass.getAllProperties());
        }
        rv.putAll(this.getLocalProperties());
        return Collections.unmodifiableMap(rv);
    }

    @Override
    public Map<String, IFXProperty> getLocalProperties() {
        if (this.properties == null) {
            try {
                this.properties = PropertiesUtil.resolveProperties(this);
            }
            catch (JavaModelException e) {
                FXPlugin.getLogger().log(1, "Unable to retrieve properties of '" + this.type.getFullyQualifiedName() + "'", (Throwable)e);
            }
        }
        return this.properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.properties);
    }

    @Override
    public Map<String, IFXProperty> getAllStaticProperties() {
        HashMap<String, IFXProperty> rv = new HashMap<String, IFXProperty>();
        if (this.superClass != null) {
            rv.putAll(this.superClass.getAllStaticProperties());
        }
        rv.putAll(this.getLocalStaticProperties());
        return Collections.unmodifiableMap(rv);
    }

    @Override
    public Map<String, IFXProperty> getLocalStaticProperties() {
        if (this.staticProperties == null) {
            try {
                this.staticProperties = PropertiesUtil.resolveStaticProperties(this);
            }
            catch (JavaModelException e) {
                FXPlugin.getLogger().log(1, "Unable to static retrieve properties of '" + this.type.getFullyQualifiedName() + "'", (Throwable)e);
            }
        }
        return Collections.unmodifiableMap(this.staticProperties);
    }

    @Override
    public IFXProperty getStaticProperty(String name) {
        Map<String, IFXProperty> map = this.getLocalStaticProperties();
        return map.get(name);
    }

    @Override
    public IMethod getValueOf() {
        try {
            IMethod[] iMethodArray = this.type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod m = iMethodArray[n2];
                if (Flags.isStatic((int)m.getFlags()) && Flags.isPublic((int)m.getFlags()) && "valueOf".equals(m.getElementName()) && m.getParameterTypes().length == 1) {
                    this.valueOfMethod = m;
                    break;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return this.valueOfMethod;
    }
}

