/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FileSetType implements Enumerator
{
    AUTO(0, "auto", "auto"),
    JAR(1, "jar", "jar"),
    JNLP(2, "jnlp", "jnlp"),
    NATIVE(3, "native", "native"),
    ICON(4, "icon", "icon");

    public static final int AUTO_VALUE = 0;
    public static final int JAR_VALUE = 1;
    public static final int JNLP_VALUE = 2;
    public static final int NATIVE_VALUE = 3;
    public static final int ICON_VALUE = 4;
    private static final FileSetType[] VALUES_ARRAY;
    public static final List<FileSetType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FileSetType[]{AUTO, JAR, JNLP, NATIVE, ICON};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FileSetType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FileSetType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FileSetType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FileSetType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FileSetType get(int value) {
        switch (value) {
            case 0: {
                return AUTO;
            }
            case 1: {
                return JAR;
            }
            case 2: {
                return JNLP;
            }
            case 3: {
                return NATIVE;
            }
            case 4: {
                return ICON;
            }
        }
        return null;
    }

    private FileSetType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

