/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.cssext.parser.result;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.fx.ide.css.cssDsl.CssTok;
import org.eclipse.fx.ide.css.cssext.parser.ParserInputCursor;
import org.eclipse.fx.ide.css.cssext.parser.result.NodeType;
import org.eclipse.fx.ide.css.cssext.parser.result.State;
import org.eclipse.fx.ide.css.extapi.Proposal;

public class ResultNode {
    public ParserInputCursor remainingInput;
    public State status;
    public final NodeType nodeType;
    public CssTok matched;
    public final List<ResultNode> next = new ArrayList<ResultNode>();
    public Proposal proposal;
    public String message;
    public boolean partial = false;

    public ResultNode(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public String toString() {
        return (Object)((Object)this.status) + "|" + this.remainingInput + "|" + this.proposal + "|" + this.partial + " (" + this.message + ")";
    }

    public List<ResultNode> findLast() {
        ArrayList<ResultNode> last = new ArrayList<ResultNode>();
        LinkedList<ResultNode> toCheck = new LinkedList<ResultNode>();
        toCheck.add(this);
        while (!toCheck.isEmpty()) {
            ResultNode check = (ResultNode)toCheck.poll();
            if (check.next.isEmpty()) {
                last.add(check);
                continue;
            }
            toCheck.addAll(check.next);
        }
        return last;
    }

    public List<ResultNode> findByState(State state) {
        ArrayList<ResultNode> found = new ArrayList<ResultNode>();
        LinkedList<ResultNode> toCheck = new LinkedList<ResultNode>();
        toCheck.add(this);
        while (!toCheck.isEmpty()) {
            ResultNode check = (ResultNode)toCheck.poll();
            if (!check.next.isEmpty()) {
                toCheck.addAll(check.next);
            }
            if (check.status != state) continue;
            found.add(check);
        }
        return found;
    }

    public boolean isValid() {
        return this.status != null && this.status != State.INVALID && this.status != State.PROPOSE;
    }

    public static ResultNode createSkipNode(ResultNode src) {
        ResultNode r = new ResultNode(src.nodeType);
        r.status = State.SKIP;
        r.remainingInput = src.remainingInput.copy();
        return r;
    }

    private static void dbg(ResultNode cur, int depth, StringBuffer s) {
        boolean lastMode = false;
        if (cur.next.isEmpty()) {
            lastMode = true;
        }
        int i = 0;
        while (i < depth) {
            if (lastMode) {
                if (i < "-->".length()) {
                    s.append("-->".charAt(i));
                } else {
                    s.append(" ");
                }
            } else {
                s.append(" ");
            }
            ++i;
        }
        s.append("(");
        s.append((Object)cur.nodeType);
        s.append(") ");
        s.append(" ");
        s.append((Object)cur.status);
        s.append(" ");
        switch (cur.status) {
            case PROPOSE: {
                s.append(cur.proposal);
                break;
            }
            case INVALID: {
                s.append(cur.message);
                break;
            }
            default: {
                s.append(cur.remainingInput);
            }
        }
        s.append("\n");
        for (ResultNode n : cur.next) {
            ResultNode.dbg(n, depth + 1, s);
        }
    }

    public static void dbg(ResultNode node) {
        StringBuffer buf = new StringBuffer();
        ResultNode.dbg(node, 0, buf);
        System.err.println(buf.toString());
    }
}

