/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.osgi.util.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.fx.core.Memento;
import org.eclipse.fx.core.MementoStore;
import org.eclipse.fx.core.ObjectSerializer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.prefs.BackingStoreException;

@Component
public class MementoStoreImpl
implements MementoStore {
    List<ObjectSerializer> serializers = new ArrayList<ObjectSerializer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)
    public void registerObjectSerializer(ObjectSerializer serializer) {
        List<ObjectSerializer> list = this.serializers;
        synchronized (list) {
            this.serializers.add(serializer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObjectSerializer(ObjectSerializer serializer) {
        List<ObjectSerializer> list = this.serializers;
        synchronized (list) {
            this.serializers.remove(serializer);
        }
    }

    public @NonNull Memento getMemento(String path) {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(path);
        return new MementoImpl(node);
    }

    public void remove(String path) {
        try {
            InstanceScope.INSTANCE.getNode(path).removeNode();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    class MementoImpl
    implements Memento {
        private final IEclipsePreferences node;
        private static final String TYPE_PREFIX = "__type_";

        private void flush() {
            try {
                this.node.flush();
            }
            catch (BackingStoreException e) {
                throw new RuntimeException(e);
            }
        }

        public MementoImpl(IEclipsePreferences node) {
            this.node = node;
        }

        public void put(@NonNull String key, String value) {
            this.node.put(key, value);
            this.flush();
        }

        public void put(@NonNull String key, boolean value) {
            this.node.putBoolean(key, value);
            this.flush();
        }

        public void put(@NonNull String key, int value) {
            this.node.putInt(key, value);
            this.flush();
        }

        public void put(@NonNull String key, double value) {
            this.node.putDouble(key, value);
            this.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(@NonNull String key, Object value, String serializer) {
            if (value == null) {
                this.node.put(key, null);
                this.node.put(TYPE_PREFIX + key, "serialized:" + serializer);
            }
            List<ObjectSerializer> list = MementoStoreImpl.this.serializers;
            synchronized (list) {
                for (ObjectSerializer s : MementoStoreImpl.this.serializers) {
                    if (!s.getId().equals(serializer)) continue;
                    this.node.put(key, s.serialize(value));
                    this.node.put(TYPE_PREFIX + key, "serialized:" + serializer);
                    this.flush();
                    return;
                }
            }
            throw new IllegalArgumentException("The serializer '" + serializer + "' is not known");
        }

        public void remove(@NonNull String key) {
            this.node.remove(key);
            this.flush();
        }

        public boolean exists(@NonNull String key) {
            try {
                return Arrays.asList(this.node.keys()).contains(key);
            }
            catch (BackingStoreException e) {
                throw new RuntimeException(e);
            }
        }

        public @Nullable String get(@NonNull String key, @Nullable String defaultValue) {
            return this.node.get(key, defaultValue);
        }

        public boolean get(@NonNull String key, boolean defaultValue) {
            return this.node.getBoolean(key, defaultValue);
        }

        public int get(@NonNull String key, int defaultValue) {
            return this.node.getInt(key, defaultValue);
        }

        public double get(@NonNull String key, double defaultValue) {
            return this.node.getDouble(key, defaultValue);
        }

        public <O> @Nullable O get(String key, Class<O> clazz, @Nullable O defaultValue) {
            List<ObjectSerializer> list = MementoStoreImpl.this.serializers;
            synchronized (list) {
                String serializer = this.node.get(TYPE_PREFIX + key, null);
                if (serializer == null) {
                    return defaultValue;
                }
                String value = this.node.get(key, null);
                if (value == null) {
                    return defaultValue;
                }
                serializer = serializer.substring("serialized:".length());
                for (ObjectSerializer s : MementoStoreImpl.this.serializers) {
                    if (!s.getId().equals(serializer)) continue;
                    return (O)s.deserialize(clazz, value);
                }
                throw new IllegalArgumentException("The serializer '" + serializer + "' is not known");
            }
        }
    }
}

