/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.rrobot.impl.generators;

import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.fx.ide.rrobot.model.bundle.FeatureFile;
import org.eclipse.fx.ide.rrobot.model.bundle.FeaturePlugin;
import org.eclipse.fx.ide.rrobot.model.bundle.IncludedFeature;
import org.eclipse.fx.ide.rrobot.model.bundle.LinkedString;
import org.eclipse.fx.ide.rrobot.model.bundle.MatchRule;
import org.eclipse.fx.ide.rrobot.model.bundle.RequiredFeature;
import org.eclipse.fx.ide.rrobot.model.task.BooleanExpression;
import org.eclipse.fx.ide.rrobot.model.task.ExcludeableElementMixin;
import org.eclipse.fx.ide.rrobot.model.task.Generator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.framework.Version;

public class FeatureGenerator
implements Generator<FeatureFile> {
    public InputStream generate(FeatureFile file, Map<String, Object> data) {
        byte[] _bytes = this.generateContent(file, data).toString().getBytes();
        return new ByteArrayInputStream(_bytes);
    }

    public CharSequence generateContent(FeatureFile file, final Map<String, Object> data) {
        boolean _not;
        boolean _notEquals_4;
        boolean _notEquals_2;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append("<feature");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("id=\"");
        String _featureid = file.getFeatureid();
        _builder.append(_featureid, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("label=\"");
        String _featurename = file.getFeaturename();
        _builder.append(_featurename, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("version=\"");
        String _version = file.getVersion();
        _builder.append(_version, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("provider-name=\"");
        String _vendor = file.getVendor();
        _builder.append(_vendor, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        if (!Objects.equal((Object)file.getLicense_feature(), null) && !Objects.equal((Object)file.getLicense_feature_version(), null)) {
            _builder.append("license-feature=\"");
            String _license_feature = file.getLicense_feature();
            _builder.append(_license_feature, "\t");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("license-feature-version=\"");
            Version _license_feature_version = file.getLicense_feature_version();
            _builder.append((Object)_license_feature_version, "\t");
            _builder.append("\"");
        }
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        LinkedString _description = file.getDescription();
        boolean bl = _notEquals = !Objects.equal((Object)_description, null);
        if (_notEquals) {
            boolean _notEquals_1;
            _builder.append("\t\t");
            _builder.append("<description ");
            String _weburl = file.getDescription().getWeburl();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_weburl, null);
            if (_notEquals_1) {
                _builder.append("url=\"");
                String _weburl_1 = file.getDescription().getWeburl();
                _builder.append(_weburl_1, "\t\t");
                _builder.append("\"");
            } else {
                _builder.append("url=\"http://www.example.com/description\"");
            }
            _builder.append(">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            String _value = file.getDescription().getValue();
            _builder.append(_value, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("</description>");
            _builder.newLine();
        } else {
            _builder.append("\t\t");
            _builder.append("<description url=\"http://www.example.com/description\">");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("[Enter Feature Description here.]");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("</description>");
            _builder.newLine();
        }
        _builder.newLine();
        LinkedString _copyright = file.getCopyright();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_copyright, null);
        if (_notEquals_2) {
            boolean _notEquals_3;
            _builder.append("\t\t");
            _builder.append("<copyright ");
            LinkedString _copyright_1 = file.getCopyright();
            boolean bl4 = _notEquals_3 = !Objects.equal((Object)_copyright_1, null);
            if (_notEquals_3) {
                _builder.append("url=\"");
                String _weburl_2 = file.getCopyright().getWeburl();
                _builder.append(_weburl_2, "\t\t");
                _builder.append("\"");
            } else {
                _builder.append("url=\"http://www.example.com/copyright\"");
            }
            _builder.append(">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            String _value_1 = file.getCopyright().getValue();
            _builder.append(_value_1, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("</copyright>");
            _builder.newLine();
        } else {
            _builder.append("\t\t");
            _builder.append("<copyright url=\"http://www.example.com/copyright\">");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("[Enter Copyright Description here.]");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("</copyright>");
            _builder.newLine();
        }
        _builder.newLine();
        LinkedString _license = file.getLicense();
        boolean bl5 = _notEquals_4 = !Objects.equal((Object)_license, null);
        if (_notEquals_4) {
            boolean _notEquals_5;
            _builder.append("\t\t");
            _builder.append("<license ");
            LinkedString _license_1 = file.getLicense();
            boolean bl6 = _notEquals_5 = !Objects.equal((Object)_license_1, null);
            if (_notEquals_5) {
                _builder.append("url=\"");
                String _weburl_3 = file.getLicense().getWeburl();
                _builder.append(_weburl_3, "\t\t");
                _builder.append("\"");
            } else {
                _builder.append("url=\"http://www.example.com/license\"");
            }
            _builder.append(">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            String _value_2 = file.getLicense().getValue();
            _builder.append(_value_2, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("</license>");
            _builder.newLine();
        } else {
            _builder.append("\t\t");
            _builder.append("<license url=\"http://www.example.com/license\">");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("[Enter License Description here.]");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("</license>");
            _builder.newLine();
        }
        _builder.newLine();
        Functions.Function1<FeaturePlugin, Boolean> _function = new Functions.Function1<FeaturePlugin, Boolean>(){

            public Boolean apply(FeaturePlugin e) {
                return FeatureGenerator.this.excludeExpression((ExcludeableElementMixin)e, data);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)file.getPlugins(), (Functions.Function1)_function);
        for (FeaturePlugin p : _filter) {
            _builder.append("   \t\t");
            _builder.append("<plugin id=\"");
            String _id = p.getId();
            _builder.append(_id, "   \t\t");
            _builder.append("\" install-size=\"0\" version=\"0.0.0\" unpack=\"");
            boolean _isUnpack = p.isUnpack();
            _builder.append((Object)_isUnpack, "   \t\t");
            _builder.append("\" ");
            boolean _isFragment = p.isFragment();
            if (_isFragment) {
                _builder.append("fragment=\"true\"");
            }
            _builder.append("/>");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Functions.Function1<IncludedFeature, Boolean> _function_1 = new Functions.Function1<IncludedFeature, Boolean>(){

            public Boolean apply(IncludedFeature e) {
                return FeatureGenerator.this.excludeExpression((ExcludeableElementMixin)e, data);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)file.getIncludedfeatures(), (Functions.Function1)_function_1);
        for (IncludedFeature i : _filter_1) {
            boolean _notEquals_6;
            _builder.append("   \t\t");
            _builder.append("<includes id=\"");
            String _id_1 = i.getId();
            _builder.append(_id_1, "   \t\t");
            _builder.append("\" version=\"");
            Version _version_1 = i.getVersion();
            boolean bl7 = _notEquals_6 = !Objects.equal((Object)_version_1, null);
            if (_notEquals_6) {
                Version _version_2 = i.getVersion();
                _builder.append((Object)_version_2, "   \t\t");
            } else {
                _builder.append("0.0.0");
            }
            _builder.append("\" />");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Functions.Function1<RequiredFeature, Boolean> _function_2 = new Functions.Function1<RequiredFeature, Boolean>(){

            public Boolean apply(RequiredFeature e) {
                return FeatureGenerator.this.excludeExpression((ExcludeableElementMixin)e, data);
            }
        };
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)file.getRequiredfeatures(), (Functions.Function1)_function_2));
        boolean bl8 = _not = !_isEmpty;
        if (_not) {
            _builder.append("   \t\t");
            _builder.append("<requires>");
            _builder.newLine();
            Functions.Function1<RequiredFeature, Boolean> _function_3 = new Functions.Function1<RequiredFeature, Boolean>(){

                public Boolean apply(RequiredFeature e) {
                    return FeatureGenerator.this.excludeExpression((ExcludeableElementMixin)e, data);
                }
            };
            Iterable _filter_2 = IterableExtensions.filter((Iterable)file.getRequiredfeatures(), (Functions.Function1)_function_3);
            for (RequiredFeature rf : _filter_2) {
                boolean _notEquals_7;
                _builder.append("   \t\t");
                _builder.append("\t");
                _builder.append("<import feature=\"");
                String _id_2 = rf.getId();
                _builder.append(_id_2, "   \t\t\t");
                _builder.append("\" ");
                Version _version_3 = rf.getVersion();
                boolean bl9 = _notEquals_7 = !Objects.equal((Object)_version_3, null);
                if (_notEquals_7) {
                    boolean _notEquals_8;
                    _builder.append("version=\"");
                    Version _version_4 = rf.getVersion();
                    _builder.append((Object)_version_4, "   \t\t\t");
                    _builder.append("\" ");
                    MatchRule _match = rf.getMatch();
                    boolean bl10 = _notEquals_8 = !Objects.equal((Object)_match, (Object)MatchRule.NONE);
                    if (_notEquals_8) {
                        _builder.append("match=\"");
                        String _literal = rf.getMatch().getLiteral();
                        _builder.append(_literal, "   \t\t\t");
                        _builder.append("\"");
                    }
                }
                _builder.append(" />");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("   \t\t");
            _builder.append("</requires>");
            _builder.newLine();
        }
        _builder.append("</feature>");
        _builder.newLine();
        return _builder;
    }

    public boolean excludeExpression(ExcludeableElementMixin mixin, Map<String, Object> data) {
        boolean _notEquals;
        BooleanExpression _excludeExpression = mixin.getExcludeExpression();
        boolean bl = _notEquals = !Objects.equal((Object)_excludeExpression, null);
        if (_notEquals) {
            boolean _execute = mixin.getExcludeExpression().execute(data);
            return !_execute;
        }
        return true;
    }
}

