/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal.handler;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.ide.jdt.ui.internal.Util;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.CorextMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2Core;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddFXBeanGetterSetterHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell s = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IType type = null;
        if (selection instanceof ITextSelection) {
            JavaEditor editor = (JavaEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
            try {
                IJavaElement[] items = SelectionConverter.codeResolveForked((JavaEditor)editor, (boolean)true);
                if (items.length > 0) {
                    type = (IType)items[0].getAncestor(7);
                } else {
                    IJavaElement element = SelectionConverter.getElementAtOffset((JavaEditor)editor);
                    if (element != null) {
                        type = (IType)element.getAncestor(7);
                    }
                }
            }
            catch (InterruptedException | InvocationTargetException | JavaModelException e) {
                e.printStackTrace();
            }
        } else if (selection instanceof IStructuredSelection) {
            IStructuredSelection selected = (IStructuredSelection)selection;
            Object firstelement = selected.getFirstElement();
            try {
                if (firstelement instanceof IType) {
                    type = (IType)firstelement;
                } else if (firstelement instanceof ICompilationUnit) {
                    type = ((ICompilationUnit)firstelement).findPrimaryType();
                } else if (firstelement instanceof IField) {
                    type = ((IField)firstelement).getDeclaringType();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (type != null) {
            GetterSetterDialog dialog = new GetterSetterDialog(s, type);
            dialog.open();
        } else {
            MessageDialog.openInformation((Shell)s, (String)ActionMessages.AddGetterSetterAction_error_title, (String)ActionMessages.AddGetterSetterAction_not_applicable);
        }
        return null;
    }

    private static void applyEdit(ICompilationUnit cu, TextEdit edit, boolean save, IProgressMonitor monitor) throws CoreException {
        IFile file = (IFile)cu.getResource();
        if (!save || !file.exists()) {
            cu.applyTextEdit(edit, monitor);
        } else {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(CorextMessages.JavaModelUtil_applyedit_operation, 2);
            try {
                IStatus status = Resources.makeCommittable((IResource)file, null);
                if (!status.isOK()) {
                    throw new CoreException(status);
                }
                cu.applyTextEdit(edit, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                cu.save((IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
            }
            finally {
                monitor.done();
            }
        }
    }

    static IMethodBinding findMethodBinding(ITypeBinding type, String name) throws JavaModelException {
        IMethodBinding[] iMethodBindingArray = type.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding b = iMethodBindingArray[n2];
            if (name.equals(b.getName()) && b.getParameterTypes().length == 0) {
                return b;
            }
            ++n2;
        }
        iMethodBindingArray = type.getInterfaces();
        n = iMethodBindingArray.length;
        n2 = 0;
        while (n2 < n) {
            IMethodBinding tp = iMethodBindingArray[n2];
            IMethodBinding b = AddFXBeanGetterSetterHandler.findMethodBinding((ITypeBinding)tp, name);
            if (b != null) {
                return b;
            }
            ++n2;
        }
        if ("java.lang.Object".equals(type.getQualifiedName())) {
            return null;
        }
        ITypeBinding superclass = type.getSuperclass();
        if (superclass != null) {
            return AddFXBeanGetterSetterHandler.findMethodBinding(superclass, name);
        }
        return null;
    }

    static void generateAccessors(CompilationUnit cu, IType ownerType, IType propertyType, ListRewrite rewrite, IField f, IJavaElement sibling, boolean makeFinal) throws JavaModelException {
        ASTNode astNode = ASTNodeSearchUtil.getAstNode((CompilationUnit)cu, (int)f.getSourceRange().getOffset(), (int)f.getSourceRange().getLength());
        FieldDeclaration fDec = (FieldDeclaration)astNode;
        ITypeBinding tp = fDec.getType().resolveBinding();
        IMethodBinding accessMethod = AddFXBeanGetterSetterHandler.findMethodBinding(tp, "get");
        if (accessMethod == null) {
            accessMethod = AddFXBeanGetterSetterHandler.findMethodBinding(tp, "getValue");
        }
        if (accessMethod == null) {
            return;
        }
        IMethodBinding readonlyMethod = AddFXBeanGetterSetterHandler.findMethodBinding(tp, "getReadOnlyProperty");
        HashSet<String> imports = new HashSet<String>();
        String propertyContent = AddFXBeanGetterSetterHandler.generatePropertyAccessContent(f, makeFinal, readonlyMethod, imports);
        String getterContent = AddFXBeanGetterSetterHandler.generateGetAccessContent(f, makeFinal, accessMethod, imports);
        String setterContent = null;
        IType fieldType = Util.toType(ownerType, f.getTypeSignature());
        if (readonlyMethod == null && !AddFXBeanGetterSetterHandler.isReadonly(fieldType, propertyType)) {
            setterContent = AddFXBeanGetterSetterHandler.generateSetAccessContent(f, makeFinal, accessMethod, imports);
        }
        ASTNode insertion = StubUtility2Core.getNodeToInsertBefore((ListRewrite)rewrite, (IJavaElement)sibling);
        AddFXBeanGetterSetterHandler.addNewAccessor(ownerType, f, propertyContent, rewrite, insertion);
        insertion = StubUtility2Core.getNodeToInsertBefore((ListRewrite)rewrite, (IJavaElement)sibling);
        AddFXBeanGetterSetterHandler.addNewAccessor(ownerType, f, getterContent, rewrite, insertion);
        if (setterContent != null) {
            insertion = StubUtility2Core.getNodeToInsertBefore((ListRewrite)rewrite, (IJavaElement)sibling);
            AddFXBeanGetterSetterHandler.addNewAccessor(ownerType, f, setterContent, rewrite, insertion);
        }
    }

    static String generateSetAccessContent(IField f, boolean makeFinal, IMethodBinding accessMethod, Set<String> imports) throws JavaModelException {
        String lineDelim = "\n";
        StringBuffer buf = new StringBuffer();
        buf.append("public " + (makeFinal ? "final " : "") + " void");
        String sig = Signature.getSimpleName((String)accessMethod.getReturnType().getQualifiedName());
        buf.append(" set" + Util.toFirstUpper(f.getElementName()) + "(final " + sig + " " + f.getElementName() + ") {");
        buf.append(lineDelim);
        buf.append("this." + f.getElementName() + "Property()." + accessMethod.getName().replace("get", "set") + "(" + f.getElementName() + ");");
        buf.append(lineDelim);
        buf.append("}");
        buf.append(lineDelim);
        return buf.toString();
    }

    static String generateGetAccessContent(IField f, boolean makeFinal, IMethodBinding accessMethod, Set<String> imports) throws JavaModelException {
        String lineDelim = "\n";
        StringBuffer buf = new StringBuffer();
        buf.append("public " + (makeFinal ? "final " : ""));
        String sig = Signature.getSimpleName((String)accessMethod.getReturnType().getQualifiedName());
        buf.append(sig);
        if ("boolean".equals(sig)) {
            buf.append(" is" + Util.toFirstUpper(f.getElementName()) + "() {");
        } else {
            buf.append(" get" + Util.toFirstUpper(f.getElementName()) + "() {");
        }
        buf.append(lineDelim);
        buf.append("return this." + f.getElementName() + "Property()." + accessMethod.getName() + "();");
        buf.append(lineDelim);
        buf.append("}");
        buf.append(lineDelim);
        return buf.toString();
    }

    static String generatePropertyAccessContent(IField f, boolean makeFinal, IMethodBinding readonlyBinding, Set<String> imports) throws IllegalArgumentException, JavaModelException {
        String lineDelim = "\n";
        StringBuffer buf = new StringBuffer();
        buf.append("public " + (makeFinal ? "final " : ""));
        if (readonlyBinding != null) {
            buf.append(readonlyBinding.getReturnType().getQualifiedName());
        } else {
            buf.append(Signature.toString((String)f.getTypeSignature()));
        }
        buf.append(" " + f.getElementName() + "Property() {");
        buf.append(lineDelim);
        buf.append("return this." + f.getElementName() + (readonlyBinding != null ? ".getReadOnlyProperty()" : "") + ";");
        buf.append(lineDelim);
        buf.append("}");
        buf.append(lineDelim);
        return buf.toString();
    }

    static boolean isReadonlyWrapper(IType fieldType) throws JavaModelException {
        return fieldType.getMethod("getReadOnlyProperty", new String[0]).exists();
    }

    static boolean isReadonly(IType fieldType, IType propertyType) {
        return !Util.assignable(fieldType, propertyType);
    }

    private static void addNewAccessor(IType type, IField field, String contents, ListRewrite rewrite, ASTNode insertion) throws JavaModelException {
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaElement)type);
        MethodDeclaration declaration = (MethodDeclaration)rewrite.getASTRewrite().createStringPlaceholder(CodeFormatterUtil.format((int)4, (String)contents, (int)0, (String)delimiter, (IJavaProject)field.getJavaProject()), 31);
        if (insertion != null) {
            rewrite.insertBefore((ASTNode)declaration, insertion, null);
        } else {
            rewrite.insertLast((ASTNode)declaration, null);
        }
    }

    static String getSimpleName(String value, Set<String> imports) {
        if (value.startsWith("java.lang.")) {
            return value.substring("java.lang.".length());
        }
        if (imports.contains(value)) {
            String[] split = value.split("\\.");
            return split[split.length - 1];
        }
        imports.add(value);
        String[] split = value.split("\\.");
        return split[split.length - 1];
    }

    public static class GetterSetterDialog
    extends TitleAreaDialog {
        private Logger logger = LoggerCreator.createLogger(((Object)((Object)this)).getClass());
        private final IType type;
        private Util util;
        private CheckboxTableViewer viewer;
        private Button makeMethodsFinal;

        public GetterSetterDialog(Shell parentShell, IType type) {
            super(parentShell);
            this.type = type;
            this.util = new Util(type.getJavaProject());
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            this.getShell().setText("Generate JavaFX Property accessors");
            this.setTitle("Generate JavaFX Property accessors");
            this.setMessage("Select the items you want the accessors created");
            Composite content = new Composite(container, 0);
            content.setLayoutData((Object)new GridData(1808));
            content.setLayout((Layout)new GridLayout(2, false));
            this.viewer = new CheckboxTableViewer(new Table(content, 68384));
            GridData gd = new GridData(1808);
            gd.heightHint = 200;
            this.viewer.getControl().setLayoutData((Object)gd);
            this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            final JavaElementLabelProvider provider = new JavaElementLabelProvider();
            this.viewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

                public Image getImage(Object element) {
                    return provider.getImage((Object)((PropertyItem)element).field);
                }

                public String getText(Object element) {
                    PropertyItem i = (PropertyItem)element;
                    return provider.getText((Object)i.field);
                }
            });
            try {
                ArrayList<PropertyItem> candidates = new ArrayList<PropertyItem>();
                IField[] iFieldArray = this.type.getFields();
                int n = iFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IField f = iFieldArray[n2];
                    if (this.util.isPropertyField(this.type, f) && !this.type.getMethod("get" + Util.toFirstUpper(f.getElementName()), new String[0]).exists() && !this.type.getMethod("is" + Util.toFirstUpper(f.getElementName()), new String[0]).exists() && !this.type.getMethod(String.valueOf(f.getElementName()) + "Property", new String[0]).exists()) {
                        candidates.add(new PropertyItem(f));
                    }
                    ++n2;
                }
                this.viewer.setInput(candidates);
            }
            catch (JavaModelException e2) {
                this.logger.error("Failure while analyzing the class", (Throwable)e2);
            }
            Composite buttonContainer = new Composite(content, 0);
            buttonContainer.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
            buttonContainer.setLayoutData((Object)new GridData(2));
            Button b = new Button(buttonContainer, 8);
            b.setText("Select All");
            b.addListener(13, e -> this.viewer.setAllChecked(true));
            b.setLayoutData((Object)new GridData(4, -1, false, false));
            b = new Button(buttonContainer, 8);
            b.setText("Deselect All");
            b.addListener(13, e -> this.viewer.setAllChecked(false));
            b.setLayoutData((Object)new GridData(4, -1, false, false));
            IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.fx.ide.jdt.ui");
            String key = "beans.final.api";
            this.makeMethodsFinal = new Button(buttonContainer, 32);
            this.makeMethodsFinal.setText("make methods final");
            this.makeMethodsFinal.addListener(13, e -> {
                try {
                    node.putBoolean(key, this.makeMethodsFinal.getSelection());
                    node.flush();
                }
                catch (Exception e1) {
                    this.logger.error("Unable to store preference", (Throwable)e1);
                }
            });
            this.makeMethodsFinal.setSelection(node.getBoolean(key, true));
            this.makeMethodsFinal.setLayoutData((Object)new GridData(4, -1, false, false));
            return container;
        }

        protected void okPressed() {
            try {
                CompilationUnit astRoot = new RefactoringASTParser(11).parse((ITypeRoot)this.type.getCompilationUnit(), true);
                ICompilationUnit unit = this.type.getCompilationUnit();
                ASTRewrite astRewrite = ASTRewrite.create((AST)astRoot.getAST());
                ListRewrite listRewriter = null;
                if (this.type.isAnonymous()) {
                    AnonymousClassDeclaration declaration;
                    ClassInstanceCreation creation = (ClassInstanceCreation)ASTNodes.getParent((ASTNode)NodeFinder.perform((ASTNode)astRoot, (ISourceRange)this.type.getNameRange()), ClassInstanceCreation.class);
                    if (creation != null && (declaration = creation.getAnonymousClassDeclaration()) != null) {
                        listRewriter = astRewrite.getListRewrite((ASTNode)declaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
                    }
                } else {
                    AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)NodeFinder.perform((ASTNode)astRoot, (ISourceRange)this.type.getNameRange()), AbstractTypeDeclaration.class);
                    if (declaration != null) {
                        listRewriter = astRewrite.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty());
                    }
                }
                IType propertyType = this.type.getJavaProject().findType("javafx.beans.property.Property");
                Object[] objectArray = this.viewer.getCheckedElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    PropertyItem i = (PropertyItem)o;
                    AddFXBeanGetterSetterHandler.generateAccessors(astRoot, this.type, propertyType, listRewriter, i.field, null, this.makeMethodsFinal.getSelection());
                    ++n2;
                }
                TextEdit fEdit = astRewrite.rewriteAST();
                AddFXBeanGetterSetterHandler.applyEdit(unit, fEdit, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)new NullProgressMonitor(), 1));
            }
            catch (CoreException e) {
                this.logger.error("Failure while generating accessor code", (Throwable)e);
            }
            super.okPressed();
        }
    }

    static class PropertyItem {
        final IField field;

        public PropertyItem(IField field) {
            this.field = field;
        }
    }
}

