/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.mvnosgi.launching;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.fx.core.SystemUtils;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;

public class MVNOSGiApplicationLaunchConfiguration
extends LaunchConfigurationDelegate {
    private static final String OSGI_FRAMEWORK_EXTENSIONS = "osgi.framework.extensions";
    private static final String LF = System.getProperty("line.separator");

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = null;
        wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
        String id = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, null);
        if (!"org.eclipse.fx.ide.mvnosgi.launching.classpathProvider".equals(id)) {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.fx.ide.mvnosgi.launching.classpathProvider");
            wc.doSave();
        }
        IMavenProjectFacade facade = this.getMavenFacade(configuration);
        MavenProject mavenProject = facade.getMavenProject(null);
        Optional<Plugin> osgiLauncherPlugin = mavenProject.getBuildPlugins().stream().filter(b -> "at.bestsolution".equals(b.getGroupId()) && "maven-osgi-exec-plugin".equals(b.getArtifactId())).findFirst();
        Optional<String> launcherJar = mavenProject.getArtifacts().stream().filter(a -> "org.eclipse.equinox.launcher".equals(a.getArtifactId())).findFirst().map(a -> a.getFile().toString());
        if (launcherJar.isPresent()) {
            String extensionClasspath;
            VMRunnerConfiguration runnerConfig = new VMRunnerConfiguration("org.eclipse.equinox.launcher.Main", new String[]{launcherJar.get()});
            Map<String, String> vmArguments = this.getVMArguments(osgiLauncherPlugin, configuration);
            HashSet<Path> extensionPaths = new HashSet<Path>();
            Path configIni = this.generateConfigIni(osgiLauncherPlugin, configuration, vmArguments, extensionPaths);
            if (vmArguments.containsKey(OSGI_FRAMEWORK_EXTENSIONS) && !(extensionClasspath = extensionPaths.stream().map(Path::toString).collect(Collectors.joining(",", "file:", ""))).trim().isEmpty()) {
                vmArguments.put("osgi.frameworkClassPath", ".," + extensionClasspath);
            }
            String[] vmArgs = (String[])vmArguments.entrySet().stream().map(e -> "-D" + (String)e.getKey() + "=" + (String)e.getValue()).toArray(String[]::new);
            String[] additionalArgs = this.getVMExecArguments(osgiLauncherPlugin, configuration);
            if (additionalArgs != null) {
                String[] nArgs = new String[vmArgs.length + additionalArgs.length];
                System.arraycopy(vmArgs, 0, nArgs, 0, vmArgs.length);
                System.arraycopy(additionalArgs, 0, nArgs, vmArgs.length, additionalArgs.length);
                vmArgs = nArgs;
            }
            runnerConfig.setVMArguments(vmArgs);
            runnerConfig.setProgramArguments(this.getProgramArgs(osgiLauncherPlugin, configIni, configuration));
            IVMInstall vmInstall = JavaRuntime.getVMInstall((IJavaProject)this.getJavaProject(facade.getProject().getName()));
            vmInstall.getVMRunner(mode).run(runnerConfig, launch, (IProgressMonitor)new NullProgressMonitor());
        } else {
            System.err.println("NOT FOUND");
        }
    }

    private String[] getVMExecArguments(Optional<Plugin> osgiLauncherPlugin, ILaunchConfiguration configuration) throws CoreException {
        ArrayList arguments = new ArrayList();
        if (osgiLauncherPlugin.isPresent()) {
            Xpp3Dom d = (Xpp3Dom)osgiLauncherPlugin.get().getConfiguration();
            Xpp3Dom[] xpp3DomArray = d.getChildren();
            int n = xpp3DomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Xpp3Dom c = xpp3DomArray[n2];
                if ("exec.args".equals(c.getName())) {
                    String value = c.getValue();
                    Stream.of(value.split(" ")).forEach(arguments::add);
                }
                ++n2;
            }
        }
        Optional<String> launchConfigVmArgsOpt = Optional.ofNullable((String)configuration.getAttributes().get(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS));
        launchConfigVmArgsOpt.ifPresent(launchConfigVmArgs -> {
            String[] launchConfigVMArguments = new ExecutionArguments(launchConfigVmArgs, "").getVMArgumentsArray();
            Stream.of(launchConfigVMArguments).forEach(arguments::add);
        });
        return arguments.isEmpty() ? null : arguments.toArray(new String[arguments.size()]);
    }

    private Map<String, String> getVMArguments(Optional<Plugin> osgiLauncherPlugin, ILaunchConfiguration configuration) {
        HashMap<String, String> vmArgs = new HashMap<String, String>();
        if (osgiLauncherPlugin.isPresent()) {
            Xpp3Dom d = (Xpp3Dom)osgiLauncherPlugin.get().getConfiguration();
            Xpp3Dom[] xpp3DomArray = d.getChildren();
            int n = xpp3DomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Xpp3Dom c = xpp3DomArray[n2];
                if ("vmProperties".equals(c.getName())) {
                    Xpp3Dom[] xpp3DomArray2 = c.getChildren();
                    int n3 = xpp3DomArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Xpp3Dom cc = xpp3DomArray2[n4];
                        if ("property".equals(cc.getName())) {
                            String name = null;
                            String value = null;
                            Xpp3Dom[] xpp3DomArray3 = cc.getChildren();
                            int n5 = xpp3DomArray3.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                Xpp3Dom ccc = xpp3DomArray3[n6];
                                if ("name".equals(ccc.getName())) {
                                    name = ccc.getValue();
                                } else if ("value".equals(ccc.getName())) {
                                    value = ccc.getValue();
                                }
                                ++n6;
                            }
                            if (name != null && value != null) {
                                vmArgs.put(name, value);
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return vmArgs;
    }

    private String[] getProgramArgs(Optional<Plugin> osgiLauncherPlugin, Path configIni, ILaunchConfiguration configuration) throws CoreException {
        ArrayList<String> programArgs = new ArrayList<String>();
        programArgs.add("-configuration");
        programArgs.add("file:" + configIni.toString());
        if (osgiLauncherPlugin.isPresent()) {
            Xpp3Dom d = (Xpp3Dom)osgiLauncherPlugin.get().getConfiguration();
            Xpp3Dom[] xpp3DomArray = d.getChildren();
            int n = xpp3DomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Xpp3Dom c = xpp3DomArray[n2];
                if ("programArguments".equals(c.getName())) {
                    Xpp3Dom[] xpp3DomArray2 = c.getChildren();
                    int n3 = xpp3DomArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Xpp3Dom cc = xpp3DomArray2[n4];
                        if ("programArgument".equals(cc.getName())) {
                            programArgs.add(cc.getValue());
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        Optional<String> launchConfigProgramArgsOpt = Optional.ofNullable((String)configuration.getAttributes().get(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS));
        launchConfigProgramArgsOpt.ifPresent(launchConfigProgramArgs -> {
            String[] launchConfigVMArguments = new ExecutionArguments("", launchConfigProgramArgs).getProgramArgumentsArray();
            Stream.of(launchConfigVMArguments).forEach(programArgs::add);
        });
        return programArgs.toArray(new String[0]);
    }

    protected IJavaProject getJavaProject(String projectName) {
        return this.getJavaModel().getJavaProject(projectName);
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IMavenProjectFacade getMavenFacade(ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        IJavaProject project = this.getJavaProject(projectName);
        return MavenPlugin.getMavenProjectRegistry().getProject(project.getProject());
    }

    private Path generateConfigIni(Optional<Plugin> osgiLauncherPlugin, ILaunchConfiguration configuration, Map<String, String> vmConfiguration, Set<Path> extensionPaths) throws CoreException {
        Path p;
        block14: {
            IMavenProjectFacade facade = this.getMavenFacade(configuration);
            String projectName = facade.getProject().getName();
            Set<Bundle> bundles = facade.getMavenProject((IProgressMonitor)new NullProgressMonitor()).getArtifacts().stream().map(a -> this.map(osgiLauncherPlugin, (Artifact)a)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
            IJavaProject project = this.getJavaProject(projectName);
            Path path = this.getWorkspaceRoot().getFolder(project.getOutputLocation()).getLocation().toFile().toPath();
            bundles.add(new Bundle(osgiLauncherPlugin, this.getManifest(path).get(), path));
            p = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve(projectName).resolve("configuration");
            Optional<Bundle> simpleConfigurator = bundles.stream().filter(b -> "org.eclipse.equinox.simpleconfigurator".equals(b.symbolicName)).findFirst();
            Optional<Bundle> equinox = bundles.stream().filter(b -> "org.eclipse.osgi".equals(b.symbolicName)).findFirst();
            try {
                Files.createDirectories(p, new FileAttribute[0]);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (simpleConfigurator.isPresent()) {
                Path configIni = p.resolve("config.ini");
                try {
                    Throwable throwable = null;
                    Object var15_18 = null;
                    try (BufferedWriter writer = Files.newBufferedWriter(configIni, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                        Path explosionPath = p.resolve(".explode");
                        Path bundlesInfo = this.generateBundlesInfo(p, explosionPath, bundles, vmConfiguration, extensionPaths);
                        writer.append("osgi.bundles=" + this.toReferenceURL(simpleConfigurator.get(), false));
                        writer.append(LF);
                        writer.append("osgi.bundles.defaultStartLevel=4");
                        writer.append(LF);
                        writer.append("osgi.install.area=" + MVNOSGiApplicationLaunchConfiguration.toInstallAreaURL(p));
                        writer.append(LF);
                        writer.append("osgi.framework=" + MVNOSGiApplicationLaunchConfiguration.toFrameworkURL(equinox.get(), explosionPath, vmConfiguration));
                        writer.append(LF);
                        writer.append("eclipse.p2.data.area=@config.dir/.p2");
                        writer.append(LF);
                        writer.append("org.eclipse.equinox.simpleconfigurator.configUrl=" + MVNOSGiApplicationLaunchConfiguration.toSimpleConfigurationURL(bundlesInfo));
                        writer.append(LF);
                        writer.append("osgi.configuration.cascaded=false");
                        writer.append(LF);
                        break block14;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.fx.ide.mvnosgi.launching", e.getMessage(), (Throwable)e));
                }
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.fx.ide.mvnosgi.launching", "Only simple-configurator is supported currently"));
        }
        return p;
    }

    private static String toInstallAreaURL(Path p) {
        String rv = p.getParent().resolve("install").toString();
        if (SystemUtils.isWindows()) {
            rv = rv.replace("\\", "\\\\").replace(":", "\\:");
        }
        return "file\\:" + rv;
    }

    private static String toFrameworkURL(Bundle bundle, Path explodePath, Map<String, String> vmConfiguration) {
        String rv = bundle.path.toString();
        if (vmConfiguration.containsKey(OSGI_FRAMEWORK_EXTENSIONS)) {
            try {
                if (!Files.exists(explodePath, new LinkOption[0])) {
                    Files.createDirectories(explodePath, new FileAttribute[0]);
                }
                Path targetPath = explodePath.resolve(bundle.path.getFileName());
                Files.copy(bundle.path, targetPath, StandardCopyOption.REPLACE_EXISTING);
                rv = targetPath.toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (SystemUtils.isWindows()) {
            rv = rv.replace('\\', '/').replace(":", "\\:");
        }
        return "file\\:" + rv;
    }

    private static String toSimpleConfigurationURL(Path bundlesInfo) {
        String rv = bundlesInfo.toAbsolutePath().toString();
        if (SystemUtils.isWindows()) {
            rv = rv.replace('\\', '/').replace(":", "\\:");
        }
        return "file\\:" + rv;
    }

    private Optional<Manifest> getManifest(Path p) {
        if (Files.isDirectory(p, new LinkOption[0])) {
            Path mf = p.resolve("META-INF").resolve("MANIFEST.MF");
            if (!Files.exists(mf, new LinkOption[0])) {
                return Optional.empty();
            }
            try {
                Throwable throwable = null;
                Object var4_11 = null;
                try (InputStream in = Files.newInputStream(mf, new OpenOption[0]);){
                    return Optional.of(new Manifest(in));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Throwable mf = null;
            Object var3_9 = null;
            try (JarFile f = new JarFile(p.toFile());){
                return Optional.ofNullable(f.getManifest());
            }
            catch (Throwable throwable) {
                if (mf == null) {
                    mf = throwable;
                } else if (mf != throwable) {
                    mf.addSuppressed(throwable);
                }
                throw mf;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path generateBundlesInfo(Path configurationDir, Path explosionPath, Set<Bundle> bundles, Map<String, String> vmConfiguration, Set<Path> extensionPaths) throws CoreException {
        Path bundleInfo = configurationDir.resolve("org.eclipse.equinox.simpleconfigurator").resolve("bundles.info");
        try {
            Files.createDirectories(bundleInfo.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.fx.ide.mvnosgi.launching", e.getMessage(), (Throwable)e));
        }
        try {
            Throwable e = null;
            Object var8_11 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(bundleInfo, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                writer.append("#encoding=UTF-8");
                writer.append(LF);
                writer.append("#version=1");
                writer.append(LF);
                for (Bundle b : bundles) {
                    if ("org.eclipse.osgi".equals(b.symbolicName)) {
                        writer.append(b.symbolicName);
                        writer.append("," + b.version);
                        writer.append("," + this.generateLocalPath(b, explosionPath, vmConfiguration, extensionPaths).toUri().toASCIIString());
                        writer.append(",-1");
                        writer.append(",true");
                        writer.append(LF);
                        continue;
                    }
                    writer.append(b.symbolicName);
                    writer.append("," + b.version);
                    writer.append("," + this.generateLocalPath(b, explosionPath, vmConfiguration, extensionPaths).toUri().toASCIIString());
                    writer.append("," + b.startLevel);
                    writer.append("," + b.autoStart);
                    writer.append(LF);
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.fx.ide.mvnosgi.launching", e.getMessage(), (Throwable)e));
        }
        return bundleInfo;
    }

    private Path generateLocalPath(Bundle b, Path explodeDir, Map<String, String> vmConfiguration, Set<Path> extensionPaths) {
        if (b.dirShape && Files.isRegularFile(b.path, new LinkOption[0])) {
            Path p = explodeDir.resolve(String.valueOf(b.symbolicName) + "_" + b.version);
            if (!Files.exists(p, new LinkOption[0])) {
                try {
                    Throwable throwable = null;
                    Object var7_12 = null;
                    try (ZipFile z = new ZipFile(b.path.toFile());){
                        z.stream().forEach(e -> {
                            Path ep = p.resolve(e.getName());
                            if (e.isDirectory()) {
                                try {
                                    Files.createDirectories(ep, new FileAttribute[0]);
                                    return;
                                }
                                catch (IOException e1) {
                                    throw new RuntimeException(e1);
                                }
                            }
                            if (!Files.exists(ep.getParent(), new LinkOption[0])) {
                                try {
                                    Files.createDirectories(ep.getParent(), new FileAttribute[0]);
                                }
                                catch (IOException e1) {
                                    throw new RuntimeException(e1);
                                }
                            }
                            try {
                                Throwable e1 = null;
                                Object var5_9 = null;
                                try {
                                    OutputStream out = Files.newOutputStream(ep, new OpenOption[0]);
                                    try {
                                        try (InputStream in = z.getInputStream((ZipEntry)e);){
                                            int l;
                                            byte[] buf = new byte[1024];
                                            while ((l = in.read(buf)) != -1) {
                                                out.write(buf, 0, l);
                                            }
                                        }
                                        if (out == null) return;
                                    }
                                    catch (Throwable throwable) {
                                        if (e1 == null) {
                                            e1 = throwable;
                                        } else if (e1 != throwable) {
                                            e1.addSuppressed(throwable);
                                        }
                                        if (out == null) throw e1;
                                        out.close();
                                        throw e1;
                                    }
                                    out.close();
                                    return;
                                }
                                catch (Throwable throwable) {
                                    if (e1 == null) {
                                        e1 = throwable;
                                        throw e1;
                                    } else {
                                        if (e1 == throwable) throw e1;
                                        e1.addSuppressed(throwable);
                                    }
                                    throw e1;
                                }
                            }
                            catch (IOException e2) {
                                throw new RuntimeException(e2);
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            return p;
        }
        if (vmConfiguration.containsKey(OSGI_FRAMEWORK_EXTENSIONS)) {
            List<String> extensions = Arrays.asList(vmConfiguration.get(OSGI_FRAMEWORK_EXTENSIONS).split(","));
            if ("org.eclipse.osgi".equals(b.symbolicName) || extensions.stream().anyMatch(v -> v.trim().equals(bundle.symbolicName))) {
                try {
                    if (!Files.exists(explodeDir, new LinkOption[0])) {
                        Files.createDirectories(explodeDir, new FileAttribute[0]);
                    }
                    Path targetFile = explodeDir.resolve(b.path.getFileName());
                    Files.copy(b.path, targetFile, StandardCopyOption.REPLACE_EXISTING);
                    if (!"org.eclipse.osgi".equals(b.symbolicName)) {
                        extensionPaths.add(targetFile);
                    }
                    return targetFile;
                }
                catch (IOException e3) {
                    throw new RuntimeException(e3);
                }
            }
        }
        return b.path.toAbsolutePath();
    }

    private Optional<Bundle> map(Optional<Plugin> osgiLauncherPlugin, Artifact a) {
        return this.getManifest(a.getFile().toPath()).filter(MVNOSGiApplicationLaunchConfiguration::isBundle).map(m -> new Bundle(osgiLauncherPlugin, (Manifest)m, a.getFile().toPath()));
    }

    private static boolean isBundle(Manifest m) {
        return m.getMainAttributes().getValue("Bundle-SymbolicName") != null;
    }

    private static String bundleName(Manifest m) {
        String name = m.getMainAttributes().getValue("Bundle-SymbolicName");
        return name.split(";")[0];
    }

    private Integer getStartLevel(Optional<Plugin> osgiLauncherPlugin, Manifest m) {
        String name = MVNOSGiApplicationLaunchConfiguration.bundleName(m);
        if (osgiLauncherPlugin.isPresent()) {
            Xpp3Dom d = (Xpp3Dom)osgiLauncherPlugin.get().getConfiguration();
            Xpp3Dom[] xpp3DomArray = d.getChildren();
            int n = xpp3DomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Xpp3Dom c = xpp3DomArray[n2];
                if ("startLevels".equals(c.getName())) {
                    Xpp3Dom[] xpp3DomArray2 = c.getChildren();
                    int n3 = xpp3DomArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Xpp3Dom cc = xpp3DomArray2[n4];
                        if (name.equals(cc.getName())) {
                            return Integer.valueOf(cc.getValue());
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        switch (name) {
            case "org.eclipse.core.runtime": {
                return 4;
            }
            case "org.eclipse.equinox.common": {
                return 2;
            }
            case "org.eclipse.equinox.ds": {
                return 2;
            }
            case "org.eclipse.equinox.event": {
                return 2;
            }
            case "org.eclipse.equinox.simpleconfigurator": {
                return 1;
            }
            case "org.eclipse.osgi": {
                return -1;
            }
        }
        return null;
    }

    private String toReferenceURL(Bundle element, boolean project) throws IOException {
        StringBuilder w = new StringBuilder();
        String path = element.path.toString();
        if (SystemUtils.isWindows()) {
            path = path.replace('\\', '/').replace(":", "\\:");
        }
        w.append("reference\\:file\\:" + path);
        if (element.startLevel != null) {
            w.append("@" + element.startLevel + "\\:start");
        } else {
            w.append("@start");
        }
        return w.toString();
    }

    public class Bundle {
        public final String symbolicName;
        public final String version;
        public final Integer startLevel;
        public final Path path;
        public final boolean dirShape;
        public final boolean autoStart;

        public Bundle(Optional<Plugin> osgiLauncherPlugin, Manifest m, Path path) {
            this(MVNOSGiApplicationLaunchConfiguration.bundleName(m), m.getMainAttributes().getValue("Bundle-Version"), mVNOSGiApplicationLaunchConfiguration.getStartLevel(osgiLauncherPlugin, m), path, mVNOSGiApplicationLaunchConfiguration.getStartLevel(osgiLauncherPlugin, m) != null, "dir".equals(m.getMainAttributes().getValue("Eclipse-BundleShape")));
        }

        public Bundle(String symbolicName, String version, Integer startLevel, Path path, boolean autoStart, boolean dirShape) {
            this.symbolicName = symbolicName;
            this.version = version;
            this.startLevel = startLevel == null ? 4 : startLevel;
            this.path = path;
            this.autoStart = autoStart;
            this.dirShape = dirShape;
        }
    }
}

