/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.internal;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SetProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleSetProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.StyledTextContent;
import org.eclipse.fx.ui.controls.styledtext.TextChangedEvent;
import org.eclipse.fx.ui.controls.styledtext.TextChangingEvent;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.fx.ui.controls.styledtext.events.HoverTarget;
import org.eclipse.fx.ui.controls.styledtext.internal.LineHelper;
import org.eclipse.fx.ui.controls.styledtext.internal.LineNode;
import org.eclipse.fx.ui.controls.styledtext.internal.TextNode;
import org.eclipse.fx.ui.controls.styledtext.internal.VFlow;
import org.eclipse.fx.ui.controls.styledtext.model.TextAnnotationPresenter;

public class ContentView
extends Pane {
    private SetProperty<TextAnnotationPresenter> textAnnotationPresenter = new SimpleSetProperty(FXCollections.observableSet((Object[])new TextAnnotationPresenter[0]));
    private StackPane contentBody = new StackPane();
    private final LineLayer lineLayer;
    private Map<Integer, Double> yOffsetData = new HashMap<Integer, Double>();
    private DoubleProperty lineHeigth = new SimpleDoubleProperty((Object)this, "lineHeight", 16.0);
    IntegerProperty numberOfLines = new SimpleIntegerProperty((Object)this, "numberOfLines", 0);
    private IntegerProperty caretOffset = new SimpleIntegerProperty((Object)this, "caretOffset", 0);
    private ObjectProperty<TextSelection> textSelection = new SimpleObjectProperty((Object)this, "textSelection", (Object)new TextSelection(0, 0));
    private ObjectProperty<StyledTextContent> content = new SimpleObjectProperty((Object)this, "content");
    private LineHelper lineHelper;
    ObjectProperty<Range<Integer>> visibleLines = new SimpleObjectProperty((Object)this, "visibleLines", (Object)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0)));
    private Range<Integer> curVisibleLines;
    private StyledTextArea area;
    private boolean skipCSSApply;
    private DoubleBinding charWidth;
    private StyledTextContent.TextChangeListener textChangeListener = new StyledTextContent.TextChangeListener(){
        private Function<Integer, Integer> mapping;
        private RangeSet<Integer> toUpdate = TreeRangeSet.create();
        private RangeSet<Integer> toRelease = TreeRangeSet.create();

        @Override
        public void textSet(TextChangedEvent event) {
            if (!this.toUpdate.isEmpty()) {
                ContentView.this.updateNodesNow(this.toUpdate);
                this.toUpdate.clear();
            }
            ContentView.this.numberOfLines.set(ContentView.this.getContent().getLineCount());
            ContentView.this.getLineLayer().requestLayout();
        }

        private int computeFirstUnchangedLine(TextChangingEvent event) {
            int endOffset = event.offset + event.replaceCharCount;
            int endLineIndex = ContentView.this.getContent().getLineAtOffset(endOffset);
            int endLineBegin = ContentView.this.getContent().getOffsetAtLine(endLineIndex);
            int firstSafeLine = endLineBegin == event.offset ? endLineIndex : endLineIndex + 1;
            return firstSafeLine;
        }

        @Override
        public void textChanging(TextChangingEvent event) {
            int changeBeginLine = ContentView.this.getContent().getLineAtOffset(event.offset);
            int firstUnchangedLine = this.computeFirstUnchangedLine(event);
            int deltaLines = event.newLineCount - event.replaceLineCount;
            if (deltaLines < 0) {
                this.toRelease.add(Range.closedOpen((Comparable)Integer.valueOf(firstUnchangedLine + deltaLines), (Comparable)Integer.valueOf(firstUnchangedLine)));
            }
            this.mapping = idx -> {
                if (idx >= firstUnchangedLine) {
                    return idx + deltaLines;
                }
                return idx;
            };
            this.toUpdate.add(Range.closedOpen((Comparable)Integer.valueOf(changeBeginLine), (Comparable)Integer.valueOf(firstUnchangedLine + deltaLines)));
            if (this.toUpdate.isEmpty()) {
                this.toUpdate.add(Range.closed((Comparable)Integer.valueOf(changeBeginLine), (Comparable)Integer.valueOf(changeBeginLine)));
            }
        }

        @Override
        public void textChanged(TextChangedEvent event) {
            if (!this.toRelease.isEmpty()) {
                ContentView.this.releaseNodesNow(this.toRelease);
                this.toRelease.clear();
            }
            if (this.mapping != null) {
                ContentView.this.getLineLayer().permutateNodes(this.mapping);
                this.mapping = null;
            }
            if (!this.toUpdate.isEmpty()) {
                ContentView.this.updateNodesNow(this.toUpdate);
                this.toUpdate.clear();
            }
            ContentView.this.numberOfLines.set(ContentView.this.getContent().getLineCount());
            ContentView.this.getLineLayer().requestLayout();
        }
    };
    private double cachedLongestLine;
    private int lastContentLength;
    private DoubleProperty offsetY = new SimpleDoubleProperty();
    private DoubleProperty offsetX = new SimpleDoubleProperty();
    private int insertionMarkerIndex = -1;
    private DoubleBinding maxValue;
    private DoubleBinding visibleAmount;

    public SetProperty<TextAnnotationPresenter> textAnnotationPresenterProperty() {
        return this.textAnnotationPresenter;
    }

    public List<HoverTarget> findHoverTargets(Point2D localLocation) {
        return this.lineLayer.findHoverTargets(localLocation);
    }

    public Optional<TextNode> findTextNode(Point2D localLocation) {
        localLocation = this.lineLayer.sceneToLocal(this.localToScene(localLocation));
        return this.lineLayer.findTextNode(localLocation);
    }

    public DoubleProperty lineHeightProperty() {
        return this.lineHeigth;
    }

    public double getLineHeight() {
        return this.lineHeigth.get();
    }

    public void setLineHeight(double lineHeight) {
        this.lineHeigth.set(lineHeight);
    }

    public ReadOnlyIntegerProperty numberOfLinesProperty() {
        return this.numberOfLines;
    }

    public int getNumberOfLines() {
        return this.numberOfLines.get();
    }

    public IntegerProperty caretOffsetProperty() {
        return this.caretOffset;
    }

    public ObjectProperty<TextSelection> textSelectionProperty() {
        return this.textSelection;
    }

    public ObjectProperty<StyledTextContent> contentProperty() {
        return this.content;
    }

    public StyledTextContent getContent() {
        return (StyledTextContent)this.content.get();
    }

    protected LineLayer getLineLayer() {
        return this.lineLayer;
    }

    protected LineHelper getLineHelper() {
        return this.lineHelper;
    }

    public ObjectProperty<Range<Integer>> visibleLinesProperty() {
        return this.visibleLines;
    }

    public Range<Integer> getVisibleLines() {
        return (Range)this.visibleLines.get();
    }

    public void setVisibleLines(Range<Integer> visibleLines) {
        this.visibleLines.set(visibleLines);
    }

    public ContentView(LineHelper lineHelper, StyledTextArea area) {
        this.lineLayer = new LineLayer(() -> new LineNode(area.tabAvanceProperty()), (n, m) -> {
            n.caretLayerVisibleProperty().bind((ObservableValue)area.focusedProperty());
            n.setLineHelper(this.getLineHelper());
            n.updateInsertionMarkerIndex(this.insertionMarkerIndex);
            n.update((Set)this.textAnnotationPresenter.get());
        });
        this.area = area;
        this.lineHelper = lineHelper;
        this.contentBody.setPadding(new Insets(0.0, 0.0, 0.0, 2.0));
        this.contentBody.getChildren().setAll((Object[])new Node[]{this.lineLayer});
        this.getChildren().setAll((Object[])new Node[]{this.contentBody});
        this.setMinWidth(200.0);
        this.setMinHeight(200.0);
        this.visibleLines.addListener(this::onLineChange);
        this.offsetX.addListener(this::onLineChange);
        this.lineLayer.lineHeightProperty().bind((ObservableValue)this.lineHeigth);
        this.lineLayer.yOffsetProperty().bind((ObservableValue)this.offsetY);
        this.lineLayer.visibleLinesProperty().bind(this.visibleLines);
        this.lineLayer.numberOfLinesProperty().bind((ObservableValue)this.numberOfLines);
        this.bindContentListener();
        this.bindCaretListener();
        this.bindSelectionListener();
        this.initBindings();
        this.charWidth.addListener(o -> {
            double d = this.cachedLongestLine = 0.0;
        });
    }

    private void initBindings() {
        DoubleBinding b0 = Util.createTextWidthBinding("M", this.area.fontProperty(), (ObservableValue<Number>)this.area.fontZoomFactorProperty());
        this.charWidth = Bindings.createDoubleBinding(() -> Math.ceil(b0.get()), (Observable[])new Observable[]{b0});
    }

    private void bindCaretListener() {
        this.caretOffset.addListener((x, o, n) -> {
            int oldCaretLine = this.getContent().getLineAtOffset(o.intValue());
            int newCaretLine = this.getContent().getLineAtOffset(n.intValue());
            TreeRangeSet toUpdate = TreeRangeSet.create();
            toUpdate.add(Range.closed((Comparable)Integer.valueOf(oldCaretLine), (Comparable)Integer.valueOf(oldCaretLine)));
            toUpdate.add(Range.closed((Comparable)Integer.valueOf(newCaretLine), (Comparable)Integer.valueOf(newCaretLine)));
            this.updateNodesNow((RangeSet<Integer>)toUpdate);
        });
    }

    private Range<Integer> getAffectedLines(TextSelection selection) {
        int firstLine = this.getContent().getLineAtOffset(selection.offset);
        int lastLine = this.getContent().getLineAtOffset(selection.offset + selection.length);
        if (lastLine == -1) {
            lastLine = this.numberOfLines.get();
        }
        return Range.closed((Comparable)Integer.valueOf(firstLine), (Comparable)Integer.valueOf(Math.min(lastLine, this.numberOfLines.get())));
    }

    private void bindSelectionListener() {
        this.textSelection.addListener((x, o, n) -> {
            TreeRangeSet toUpdate = TreeRangeSet.create();
            if (o != null) {
                toUpdate.add(this.getAffectedLines((TextSelection)o));
            }
            if (n != null) {
                toUpdate.add(this.getAffectedLines((TextSelection)n));
            }
            this.updateNodesNow((RangeSet<Integer>)toUpdate);
        });
    }

    private void bindContentListener() {
        this.content.addListener((x, o, n) -> {
            if (o != null) {
                o.removeTextChangeListener(this.textChangeListener);
            }
            if (n != null) {
                n.addTextChangeListener(this.textChangeListener);
                this.numberOfLines.set(n.getLineCount());
            }
        });
        StyledTextContent current = (StyledTextContent)this.content.get();
        if (current != null) {
            current.addTextChangeListener(this.textChangeListener);
            this.numberOfLines.set(current.getLineCount());
        }
    }

    private void onLineChange(Observable o) {
        TreeRangeSet toUpdate = TreeRangeSet.create();
        TreeRangeSet toRelease = TreeRangeSet.create();
        double offsetY = this.offsetYProperty().get();
        Range visibleLines = (Range)this.visibleLinesProperty().get();
        ContiguousSet set = ContiguousSet.create((Range)visibleLines, (DiscreteDomain)DiscreteDomain.integers());
        double lineHeight = this.lineHeightProperty().get();
        if (this.curVisibleLines == null) {
            toUpdate.add(visibleLines);
        } else {
            TreeRangeSet hiddenLines = TreeRangeSet.create();
            hiddenLines.add(this.curVisibleLines);
            hiddenLines.remove(visibleLines);
            TreeRangeSet shownLines = TreeRangeSet.create();
            shownLines.add(visibleLines);
            shownLines.remove(this.curVisibleLines);
            toUpdate.addAll((RangeSet)shownLines);
            toRelease.addAll((RangeSet)hiddenLines);
        }
        this.curVisibleLines = visibleLines;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            double y = (double)index * lineHeight - offsetY;
            this.yOffsetData.put(index, y);
        }
        this.releaseNodesNow((RangeSet<Integer>)toRelease);
        this.updateNodesNow((RangeSet<Integer>)toUpdate);
        this.lineLayer.requestLayout();
    }

    private double computeLongestLine() {
        if (this.cachedLongestLine != 0.0 && this.lastContentLength == this.getContent().getCharCount()) {
            return Math.max(this.cachedLongestLine, this.getWidth());
        }
        OptionalInt longestLine = IntStream.range(0, this.getNumberOfLines()).map(index -> this.lineHelper.getLengthCountTabsAsChars(index)).max();
        if (longestLine.isPresent()) {
            int lineLength = longestLine.getAsInt() + 2;
            this.cachedLongestLine = (double)lineLength * this.getCharWidth();
            this.lastContentLength = this.getContent().getCharCount();
            return Math.max(this.getWidth(), this.cachedLongestLine);
        }
        this.cachedLongestLine = 0.0;
        return this.getWidth();
    }

    public double getCharWidth() {
        if (!this.skipCSSApply) {
            this.applyCss();
            if (this.getParent() != null) {
                this.skipCSSApply = true;
            }
        }
        return this.charWidth.get();
    }

    protected void layoutChildren() {
        double scrollX = -this.offsetX.get();
        if (Double.isNaN(scrollX)) {
            scrollX = 0.0;
        }
        this.contentBody.resizeRelocate(scrollX, 0.0, this.computeLongestLine(), this.getHeight());
    }

    public void bindHorizontalScrollbar(ScrollBar bar) {
        bar.setMin(0.0);
        DoubleBinding max = this.contentBody.widthProperty().subtract((ObservableNumberValue)this.widthProperty());
        DoubleBinding factor = this.contentBody.widthProperty().divide((ObservableNumberValue)max);
        this.maxValue = this.contentBody.widthProperty().divide((ObservableNumberValue)factor);
        this.visibleAmount = this.widthProperty().divide((ObservableNumberValue)factor);
        this.updateValue(this.maxValue.get(), bar.maxProperty());
        this.updateValue(this.visibleAmount.get(), bar.visibleAmountProperty());
        this.maxValue.addListener(o -> this.updateValue(this.maxValue.get(), bar.maxProperty()));
        this.visibleAmount.addListener(o -> this.updateValue(this.visibleAmount.get(), bar.visibleAmountProperty()));
        this.offsetX.bind((ObservableValue)bar.valueProperty());
        this.widthProperty().addListener((x, o, n) -> {
            if (!Double.isNaN(bar.getMax()) && !Double.isNaN(bar.getValue())) {
                bar.setValue(Math.max(0.0, Math.min(bar.getMax(), bar.getValue())));
            }
        });
    }

    private void updateValue(double v, DoubleProperty p) {
        if (Double.isNaN(v)) {
            p.set(0.0);
        } else {
            p.set(v);
        }
    }

    public void bindVerticalScrollbar(ScrollBar bar) {
        this.heightProperty().addListener((x, o, n) -> {
            if (!Double.isNaN(bar.getMax()) && !Double.isNaN(bar.getValue())) {
                bar.setValue(Math.max(0.0, Math.min(bar.getMax(), bar.getValue())));
            }
        });
    }

    public DoubleProperty offsetYProperty() {
        return this.offsetY;
    }

    public void updatelines(RangeSet<Integer> rs) {
        this.updateNodesNow(rs);
    }

    public void updateInsertionMarkerIndex(int index) {
        if (this.insertionMarkerIndex != index) {
            this.insertionMarkerIndex = index;
        }
        TreeRangeSet rs = TreeRangeSet.create();
        this.updateNodesNow((RangeSet<Integer>)rs.complement());
    }

    void updateNodesNow(RangeSet<Integer> rs) {
        RangeSet subRangeSet = rs.subRangeSet(this.getVisibleLines()).subRangeSet(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.getNumberOfLines())));
        subRangeSet.asRanges().forEach(r -> ContiguousSet.create((Range)r, (DiscreteDomain)DiscreteDomain.integers()).forEach(index -> this.getLineLayer().updateNode((int)index)));
    }

    void releaseNodesNow(RangeSet<Integer> rs) {
        RangeSet subRangeSet = rs.subRangeSet(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.getNumberOfLines())));
        subRangeSet.asRanges().forEach(r -> ContiguousSet.create((Range)r, (DiscreteDomain)DiscreteDomain.integers()).forEach(index -> this.getLineLayer().releaseNode((int)index)));
    }

    public Optional<Point2D> getLocationInScene(int globalOffset, StyledTextArea.LineLocation locationHint) {
        this.applyCss();
        this.layout();
        int lineIndex = this.getContent().getLineAtOffset(globalOffset);
        Optional node = this.lineLayer.getVisibleNode(lineIndex);
        return node.map(n2 -> {
            double x = n2.getCharLocation(globalOffset - n2.getStartOffset());
            double y = 0.0;
            switch (locationHint) {
                case BELOW: {
                    y = 0.0;
                    break;
                }
                case ABOVE: {
                    y = -this.getLineHeight();
                    break;
                }
                case CENTER: {
                    y = -this.getLineHeight() / 2.0;
                }
            }
            Point2D p = new Point2D(x, y);
            return n2.localToScene(p);
        });
    }

    public Optional<Integer> getLineIndex(Point2D point) {
        Point2D p = this.lineLayer.sceneToLocal(this.localToScene(point));
        Optional<Integer> result = this.lineLayer.getLineIndex(p);
        return result;
    }

    public void updateAnnotations(RangeSet<Integer> r) {
        this.updateNodesNow(r);
    }

    private class LineLayer
    extends VFlow<LineNode> {
        public LineLayer(Supplier<LineNode> nodeFactory, BiConsumer<LineNode, Integer> nodePopulator) {
            super(nodeFactory, nodePopulator);
            this.setOnRelease(n -> n.release());
            this.setOnActivate((idx, n) -> n.setIndex((int)idx));
        }

        @Override
        protected void releaseNode(int lineIndex) {
            super.releaseNode(lineIndex);
        }

        private Stream<LineNode> createVisibleLineNodesStream() {
            ContiguousSet visibleIndexes = ContiguousSet.create((Range)((Range)ContentView.this.visibleLines.get()), (DiscreteDomain)DiscreteDomain.integers());
            return visibleIndexes.stream().filter(i -> i < this.getNumberOfLines()).map(idx -> this.getVisibleNode((int)idx)).filter(n -> n.isPresent()).map(n -> (LineNode)((Object)((Object)n.get())));
        }

        Optional<Integer> getLineIndex(Point2D point) {
            Predicate<Node> filter = n -> {
                Bounds b = n.getBoundsInParent();
                return b.getMinY() <= point.getY() && point.getY() <= b.getMaxY();
            };
            Optional<Node> hitLine = this.createVisibleLineNodesStream().filter(filter).findFirst();
            Optional<Integer> index = hitLine.map(n -> {
                int i = n.getCaretIndexAtPoint(new Point2D(point.getX(), n.getHeight() / 2.0));
                if (i >= 0) {
                    return n.getStartOffset() + i;
                }
                if (point.getX() > 0.0) {
                    return n.getEndOffset();
                }
                if (point.getX() < 0.0) {
                    return n.getStartOffset();
                }
                return -1;
            });
            return index;
        }

        public List<HoverTarget> findHoverTargets(Point2D localLocation) {
            ContiguousSet visibleIndexes = ContiguousSet.create((Range)((Range)ContentView.this.visibleLines.get()), (DiscreteDomain)DiscreteDomain.integers());
            return visibleIndexes.stream().map(lineIndex -> this.getVisibleNode((int)lineIndex)).filter(x -> x.isPresent()).filter(x -> ((LineNode)((Object)((Object)x.get()))).getBoundsInParent().contains(localLocation)).flatMap(x -> ((LineNode)((Object)((Object)x.get()))).findHoverTargets(((LineNode)((Object)((Object)x.get()))).parentToLocal(localLocation)).stream()).collect(Collectors.toList());
        }

        public Optional<TextNode> findTextNode(Point2D localLocation) {
            ContiguousSet visibleLineIndexes = ContiguousSet.create((Range)((Range)ContentView.this.visibleLines.get()), (DiscreteDomain)DiscreteDomain.integers());
            return visibleLineIndexes.stream().map(lineIndex -> this.getVisibleNode((int)lineIndex)).filter(x -> x.isPresent()).filter(x -> ((LineNode)((Object)((Object)x.get()))).getBoundsInParent().contains(localLocation)).findFirst().flatMap(x -> ((LineNode)((Object)((Object)x.get()))).findTextNode(((LineNode)((Object)((Object)x.get()))).parentToLocal(localLocation)));
        }
    }
}

