/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.authn.oauth;

import com.google.gdata.client.authn.oauth.OAuthException;
import com.google.gdata.client.authn.oauth.OAuthParameters;
import com.google.gdata.client.authn.oauth.OAuthSigner;
import com.google.gdata.client.authn.oauth.OAuthUtil;
import com.google.gdata.util.common.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class OAuthHmacSha1Signer
implements OAuthSigner {
    public String getSignature(String baseString, OAuthParameters oauthParameters) throws OAuthException {
        try {
            if (oauthParameters == null) {
                throw new OAuthException("OAuth parameters cannot be null");
            }
            String keyString = this.getKey(oauthParameters);
            SecretKeySpec key = new SecretKeySpec(keyString.getBytes("UTF-8"), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(key);
            return Base64.encode(mac.doFinal(baseString.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuthException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OAuthException(e);
        }
        catch (InvalidKeyException e) {
            throw new OAuthException(e);
        }
    }

    private String getKey(OAuthParameters oauthParameters) {
        return OAuthUtil.encode(oauthParameters.getOAuthConsumerSecret()) + "&" + OAuthUtil.encode(oauthParameters.getOAuthTokenSecret());
    }

    public String getSignatureMethod() {
        return "HMAC-SHA1";
    }
}

