/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gdata.model.AttributeCreator;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.AttributeMetadataRegistryBuilder;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementCreatorImpl;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadataRegistryBuilder;
import com.google.gdata.model.MetadataContext;
import com.google.gdata.model.Schema;
import com.google.gdata.model.TransformKey;
import com.google.gdata.util.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetadataRegistry {
    private final Map<Schema.RootKey, AttributeMetadataRegistryBuilder> attributes = Maps.newHashMap();
    private final Map<Schema.RootKey, ElementMetadataRegistryBuilder> elements = Maps.newHashMap();
    private volatile Schema cachedSchema;

    public MetadataRegistry() {
    }

    public MetadataRegistry(MetadataRegistry source) {
        this();
        this.merge(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MetadataRegistry merge(MetadataRegistry other) {
        MetadataRegistry metadataRegistry = other;
        synchronized (metadataRegistry) {
            Object builder;
            Schema.RootKey key;
            for (Map.Entry<Schema.RootKey, AttributeMetadataRegistryBuilder> entry : other.attributes.entrySet()) {
                key = entry.getKey();
                builder = this.attributes.get(key);
                if (builder == null) {
                    builder = new AttributeMetadataRegistryBuilder(this);
                    this.attributes.put(key, (AttributeMetadataRegistryBuilder)builder);
                }
                ((AttributeMetadataRegistryBuilder)builder).merge(entry.getValue());
            }
            for (Map.Entry<Schema.RootKey, Object> entry : other.elements.entrySet()) {
                key = entry.getKey();
                builder = this.elements.get(key);
                if (builder == null) {
                    builder = new ElementMetadataRegistryBuilder(this);
                    this.elements.put(key, (ElementMetadataRegistryBuilder)builder);
                }
                ((ElementMetadataRegistryBuilder)builder).merge((ElementMetadataRegistryBuilder)entry.getValue());
            }
        }
        return this;
    }

    public MetadataRegistry register(ElementKey<?, ?> key) {
        if (key != null) {
            Class<?> elementType = key.getElementType();
            if (Element.class == elementType) {
                this.build(key);
            } else {
                this.registerClass(elementType);
            }
        }
        return this;
    }

    public synchronized MetadataRegistry registerClass(Class<? extends Element> clazz) {
        if (Element.class == clazz) {
            return this;
        }
        try {
            Method registerMethod = clazz.getDeclaredMethod("registerMetadata", MetadataRegistry.class);
            if (!Modifier.isStatic(registerMethod.getModifiers())) {
                throw new IllegalArgumentException("Class " + clazz + " had a non-static registerMetadata(MetadataRegistry) method.");
            }
            registerMethod.invoke(null, this);
            return this;
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + clazz + " doesn't support metadata registration.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e.getCause());
        }
    }

    public Schema createSchema() {
        Schema instance = this.cachedSchema;
        return instance != null ? instance : this.buildSchema();
    }

    private synchronized Schema buildSchema() {
        Schema instance = this.cachedSchema;
        if (instance == null) {
            this.whitelistAttributes();
            this.whitelistElements();
            this.cachedSchema = instance = new Schema(this);
        }
        return instance;
    }

    void dirty() {
        Preconditions.checkState(Thread.holdsLock(this), "Cannot call dirty() without holding the lock on the registry.");
        this.cachedSchema = null;
    }

    private void whitelistAttributes() {
        for (ElementMetadataRegistryBuilder builder : this.elements.values()) {
            TransformKey key;
            LinkedHashMap whitelistMap = Maps.newLinkedHashMap();
            Map<TransformKey, ElementCreatorImpl> creators = builder.getCreators();
            for (Map.Entry<TransformKey, ElementCreatorImpl> entry : creators.entrySet()) {
                key = entry.getKey();
                ElementCreatorImpl element = entry.getValue();
                if (element.getAttributeWhitelist() == null) continue;
                whitelistMap.put(key, element.getAttributeWhitelist());
            }
            for (Map.Entry<TransformKey, ElementCreatorImpl> entry : whitelistMap.entrySet()) {
                key = entry.getKey();
                Set whitelist = (Set)((Object)entry.getValue());
                HashSet whitelistNames = Sets.newHashSet();
                for (AttributeKey whitelistKey : whitelist) {
                    whitelistNames.add(whitelistKey.getId());
                }
                HashSet allAttributes = Sets.newHashSet();
                for (Map.Entry<TransformKey, ElementCreatorImpl> entry2 : creators.entrySet()) {
                    if (!entry2.getKey().matches(key)) continue;
                    allAttributes.addAll(entry2.getValue().getAttributeSet());
                }
                if (!allAttributes.containsAll(whitelist)) {
                    HashSet missing = Sets.newHashSet((Iterable)whitelist);
                    missing.removeAll(allAttributes);
                    throw new IllegalStateException("Missing attributes!  Whitelist specified " + missing + " but did not find those attributes.");
                }
                for (AttributeKey attribute : allAttributes) {
                    if (whitelistNames.contains(attribute.getId())) continue;
                    ElementKey parent = (ElementKey)key.getKey();
                    this.build(parent, attribute, key.getContext()).setVisible(false);
                }
            }
        }
    }

    private void whitelistElements() {
        for (Map.Entry<Schema.RootKey, ElementMetadataRegistryBuilder> rootEntry : this.elements.entrySet()) {
            TransformKey key;
            ElementMetadataRegistryBuilder builder = rootEntry.getValue();
            LinkedHashMap whitelistMap = Maps.newLinkedHashMap();
            Map<TransformKey, ElementCreatorImpl> creators = builder.getCreators();
            for (Map.Entry<TransformKey, ElementCreatorImpl> entry : creators.entrySet()) {
                key = entry.getKey();
                ElementCreatorImpl element = entry.getValue();
                if (element.getElementWhitelist() == null) continue;
                whitelistMap.put(key, element.getElementWhitelist());
            }
            for (Map.Entry<TransformKey, ElementCreatorImpl> entry : whitelistMap.entrySet()) {
                key = entry.getKey();
                Set whitelist = (Set)((Object)entry.getValue());
                HashSet whitelistNames = Sets.newHashSet();
                for (ElementKey whitelistKey : whitelist) {
                    whitelistNames.add(whitelistKey.getId());
                }
                HashSet allChildren = Sets.newHashSet();
                for (Map.Entry<TransformKey, ElementCreatorImpl> entry2 : creators.entrySet()) {
                    if (!entry2.getKey().matches(key)) continue;
                    allChildren.addAll(entry2.getValue().getElementSet());
                }
                if (!allChildren.containsAll(whitelist)) {
                    HashSet missing = Sets.newHashSet((Iterable)whitelist);
                    missing.removeAll(allChildren);
                    throw new IllegalStateException("Missing children!  Whitelist specified " + missing + " but did not find those child elements.");
                }
                for (ElementKey child : allChildren) {
                    if (whitelistNames.contains(child.getId())) continue;
                    ElementKey parent = (ElementKey)key.getKey();
                    this.build(parent, child, key.getContext()).setVisible(false);
                }
            }
        }
    }

    public boolean isRegistered(ElementKey<?, ?> key) {
        Schema.RootKey rootKey = Schema.getRootKey(key);
        ElementMetadataRegistryBuilder elementRegistry = this.elements.get(rootKey);
        if (elementRegistry != null) {
            return elementRegistry.isRegistered(null, key, null);
        }
        return false;
    }

    public ElementCreator build(ElementKey<?, ?> element) {
        return this.build(null, element, null);
    }

    public ElementCreator build(ElementKey<?, ?> parent, ElementKey<?, ?> element) {
        return this.build(parent, element, null);
    }

    public ElementCreator build(ElementKey<?, ?> element, MetadataContext context) {
        return this.build(null, element, context);
    }

    public ElementCreator build(ElementKey<?, ?> parent, ElementKey<?, ?> element, MetadataContext context) {
        ElementCreatorImpl creator = this.getOrCreateElement(element).build(parent, element, context);
        if (parent != null || context != null) {
            this.register(element);
        }
        return creator;
    }

    private synchronized ElementMetadataRegistryBuilder getOrCreateElement(ElementKey<?, ?> key) {
        Schema.RootKey rootKey = Schema.getRootKey(key);
        ElementMetadataRegistryBuilder elementRegistry = this.elements.get(rootKey);
        if (elementRegistry == null) {
            elementRegistry = new ElementMetadataRegistryBuilder(this);
            this.elements.put(rootKey, elementRegistry);
        }
        this.dirty();
        return elementRegistry;
    }

    public AttributeCreator build(ElementKey<?, ?> parent, AttributeKey<?> attribute) {
        return this.build(parent, attribute, null);
    }

    public AttributeCreator build(ElementKey<?, ?> parent, AttributeKey<?> attribute, MetadataContext context) {
        return this.getOrCreateAttribute(attribute).build(parent, attribute, context);
    }

    private synchronized AttributeMetadataRegistryBuilder getOrCreateAttribute(AttributeKey<?> key) {
        Schema.RootKey rootKey = Schema.getRootKey(key);
        AttributeMetadataRegistryBuilder attRegistry = this.attributes.get(rootKey);
        if (attRegistry == null) {
            attRegistry = new AttributeMetadataRegistryBuilder(this);
            this.attributes.put(rootKey, attRegistry);
        }
        this.dirty();
        return attRegistry;
    }

    public <D, E extends Element> void adapt(ElementKey<D, E> source, String kind, ElementKey<? extends D, ? extends E> adaptation) {
        this.build(source).adapt(kind, adaptation);
    }

    Map<Schema.RootKey, AttributeMetadataRegistryBuilder> getAttributes() {
        return ImmutableMap.copyOf(this.attributes);
    }

    Map<Schema.RootKey, ElementMetadataRegistryBuilder> getElements() {
        return ImmutableMap.copyOf(this.elements);
    }
}

