/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.common.collect.Lists;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.AttributeMetadata;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.Metadata;
import com.google.gdata.model.MetadataKey;
import com.google.gdata.util.ParseException;
import com.google.gdata.wireformats.ContentCreationException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataValueTransform
implements Metadata.VirtualValue {
    private final List<MetadataKey<?>> sources;

    public MetadataValueTransform(MetadataKey<?> ... inputSources) {
        this.sources = Lists.newArrayList((Object[])inputSources);
    }

    @Override
    public Object generate(Element element, ElementMetadata<?, ?> metadata) {
        for (MetadataKey<?> source : this.sources) {
            if (source instanceof ElementKey) {
                ElementMetadata childMeta;
                Object value;
                ElementKey childKey = (ElementKey)source;
                Object child = element.getElement(childKey);
                if (child == null || (value = (childMeta = metadata == null ? null : metadata.bindElement(childKey)) == null ? ((Element)child).getTextValue() : childMeta.generateValue((Element)child, childMeta)) == null) continue;
                return value;
            }
            AttributeKey attKey = (AttributeKey)source;
            AttributeMetadata attMeta = metadata == null ? null : metadata.bindAttribute(attKey);
            Object value = attMeta == null ? element.getAttributeValue(attKey) : attMeta.generateValue(element, metadata);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public void parse(Element element, ElementMetadata<?, ?> metadata, Object value) throws ParseException {
        if (this.sources.isEmpty()) {
            return;
        }
        MetadataKey<?> source = this.sources.get(0);
        if (source instanceof ElementKey) {
            ElementKey childKey = (ElementKey)source;
            ElementMetadata childMeta = metadata.bindElement(childKey);
            Object child = element.getElement(childKey);
            if (child == null) {
                try {
                    child = childMeta.createElement();
                }
                catch (ContentCreationException e) {
                    throw new ParseException(e);
                }
                element.addElement(childKey, (Element)child);
            }
            childMeta.parseValue((Element)child, childMeta, value);
        } else {
            AttributeKey attKey = (AttributeKey)source;
            AttributeMetadata attMeta = metadata.bindAttribute(attKey);
            attMeta.parseValue(element, metadata, value);
        }
    }
}

