/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.ISkinSimple;
import net.sourceforge.plantuml.style.Style;

public class ComponentRoseDelayText
extends AbstractTextualComponent {
    public ComponentRoseDelayText(Style style, Display stringsToDisplay, ISkinSimple spriteContainer) {
        super(style, LineBreakStrategy.NONE, 0, 0, 4, spriteContainer, stringsToDisplay, false);
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        XDimension2D dimensionToUse = area.getDimensionToUse();
        TextBlock textBlock = this.getTextBlock();
        StringBounder stringBounder = ug.getStringBounder();
        double textWidth = this.getTextWidth(stringBounder);
        double textHeight = this.getTextHeight(stringBounder);
        double xpos = (dimensionToUse.getWidth() - textWidth) / 2.0;
        double ypos = (dimensionToUse.getHeight() - textHeight) / 2.0;
        textBlock.drawU(ug.apply(new UTranslate(xpos, ypos + (double)this.getMarginY())));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 20.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder);
    }
}

