/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.requirement.model.element;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.model.IGenericSimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.MatlabHandleElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.requirement.model.SimulinkRequirementModel;
import org.eclipse.epsilon.emc.simulink.requirement.model.element.ISimulinkRequirementModelElement;
import org.eclipse.epsilon.emc.simulink.requirement.model.element.SimulinkJustification;
import org.eclipse.epsilon.emc.simulink.requirement.model.element.SimulinkLink;
import org.eclipse.epsilon.emc.simulink.requirement.util.collection.SimulinkRequirementCollection;
import org.eclipse.epsilon.emc.simulink.types.HandleObject;
import org.eclipse.epsilon.emc.simulink.types.Struct;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class SimulinkRequirement
extends SimulinkModelElement
implements ISimulinkRequirementModelElement {
    protected MatlabHandleElement requirementHandle;

    public SimulinkRequirement(SimulinkRequirementModel model, MatlabEngine engine, SimulinkRequirement requirement) {
        super((IGenericSimulinkModel)model, engine);
        try {
            this.requirementHandle = new MatlabHandleElement((IGenericSimulinkModel)model, engine, (HandleObject)engine.fevalWithResult("add", new Object[]{requirement.getHandle()}));
        }
        catch (MatlabException e) {
            e.printStackTrace();
        }
    }

    public SimulinkRequirement(SimulinkRequirementModel model, MatlabEngine engine, SimulinkJustification justification) {
        super((IGenericSimulinkModel)model, engine);
        try {
            this.requirementHandle = new MatlabHandleElement((IGenericSimulinkModel)model, engine, (HandleObject)engine.fevalWithResult("add", new Object[]{justification.getHandle().getHandle()}));
        }
        catch (MatlabException e) {
            e.printStackTrace();
        }
    }

    public SimulinkRequirement(SimulinkRequirementModel model, MatlabEngine engine) {
        super((IGenericSimulinkModel)model, engine);
        try {
            this.requirementHandle = new MatlabHandleElement((IGenericSimulinkModel)model, engine, (HandleObject)engine.fevalWithResult("add", new Object[]{model.getHandle().getHandle()}));
        }
        catch (MatlabException e) {
            e.printStackTrace();
        }
    }

    public SimulinkRequirement(SimulinkRequirementModel model, MatlabEngine engine, String subtype) {
        super((IGenericSimulinkModel)model, engine);
        try {
            this.requirementHandle = new MatlabHandleElement((IGenericSimulinkModel)model, engine, (HandleObject)engine.fevalWithResult("add", new Object[]{model.getHandle().getHandle(), "ReqType", subtype}));
        }
        catch (MatlabException e) {
            e.printStackTrace();
        }
    }

    public SimulinkRequirement(SimulinkRequirementModel model, MatlabEngine engine, HandleObject id) {
        super((IGenericSimulinkModel)model, engine);
        this.requirementHandle = new MatlabHandleElement((IGenericSimulinkModel)model, engine, id);
    }

    public Object getProperty(String property) throws EolRuntimeException {
        return this.requirementHandle.getProperty(property);
    }

    public void setProperty(String property, Object value) throws EolRuntimeException {
        this.requirementHandle.setProperty(property, value);
    }

    public Collection<String> getAllTypeNamesOf() {
        return Arrays.asList("Requirement", this.getType());
    }

    public boolean deleteElementInModel() throws EolRuntimeException {
        if (this.requirementHandle != null) {
            try {
                this.engine.feval("remove", new Object[]{this.requirementHandle.getHandle()});
            }
            catch (MatlabException matlabException) {
                return false;
            }
        }
        return true;
    }

    public Object getHandle() {
        return this.requirementHandle.getHandle();
    }

    public String getType() {
        try {
            return (String)this.getProperty("Type");
        }
        catch (EolRuntimeException eolRuntimeException) {
            return "Requirement";
        }
    }

    public SimulinkRequirementCollection children() {
        try {
            Object collection = this.engine.fevalWithResult("children", new Object[]{this.getHandle()});
            return new SimulinkRequirementCollection(collection, (SimulinkRequirementModel)this.getOwningModel());
        }
        catch (MatlabException matlabException) {
            return new SimulinkRequirementCollection(null, (SimulinkRequirementModel)this.getOwningModel());
        }
    }

    public SimulinkRequirement add() {
        try {
            HandleObject id = (HandleObject)this.engine.fevalWithResult("add", new Object[]{this.getHandle()});
            return new SimulinkRequirement((SimulinkRequirementModel)this.getOwningModel(), this.engine, id);
        }
        catch (MatlabException matlabException) {
            return null;
        }
    }

    public SimulinkRequirement parent() {
        try {
            HandleObject id = (HandleObject)this.engine.fevalWithResult("parent", new Object[]{this.getHandle()});
            if (id != null) {
                return new SimulinkRequirement((SimulinkRequirementModel)this.getOwningModel(), this.engine, id);
            }
            return null;
        }
        catch (MatlabException matlabException) {
            return null;
        }
    }

    public Struct getImplementationStatus() throws MatlabException {
        return (Struct)this.engine.fevalWithResult("getImplementationStatus", new Object[]{this.getHandle()});
    }

    public SimulinkLink justifyImplementation(SimulinkJustification justification) {
        return this.justify(justification, "Implementation");
    }

    public SimulinkLink justifyVerification(SimulinkJustification justification) {
        return this.justify(justification, "Verification");
    }

    public SimulinkLink justify(SimulinkJustification justification, String kind) {
        try {
            HandleObject id = (HandleObject)this.engine.fevalWithResult("justify" + kind, new Object[]{this.getHandle(), justification.getHandle().getHandle()});
            return new SimulinkLink((SimulinkRequirementModel)this.getOwningModel(), this.engine, id);
        }
        catch (MatlabException matlabException) {
            return null;
        }
    }

    public SimulinkLink linkTo(ISimulinkModelElement element) {
        try {
            HandleObject id = (HandleObject)this.engine.fevalWithResult("slreq.createLink", new Object[]{this.getHandle(), element.getHandle()});
            return new SimulinkLink((SimulinkRequirementModel)this.getOwningModel(), this.engine, id);
        }
        catch (MatlabException matlabException) {
            return null;
        }
    }

    public SimulinkLink linkFrom(ISimulinkModelElement element) {
        try {
            HandleObject id = (HandleObject)this.engine.fevalWithResult("slreq.createLink", new Object[]{element.getHandle(), this.getHandle()});
            return new SimulinkLink((SimulinkRequirementModel)this.getOwningModel(), this.engine, id);
        }
        catch (MatlabException matlabException) {
            return null;
        }
    }
}

