/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.diagram.part;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmf.gmfgraph.provider.GMFGraphItemProviderAdapterFactory;
import org.eclipse.gmf.mappings.provider.GMFMapItemProviderAdapterFactory;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.tooldef.provider.GMFToolItemProviderAdapterFactory;
import org.eclipse.gmf.tooling.simplemap.diagram.part.SimplemapDocumentProvider;
import org.eclipse.gmf.tooling.simplemap.diagram.providers.ElementInitializers;
import org.eclipse.gmf.tooling.simplemap.simplemappings.provider.SimplemappingsItemProviderAdapterFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class SimplemapDiagramEditorPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.eclipse.gmf.tooling.simplemap.diagram";
    public static final PreferencesHint DIAGRAM_PREFERENCES_HINT = new PreferencesHint("org.eclipse.gmf.tooling.simplemap.diagram");
    private static SimplemapDiagramEditorPlugin instance;
    private ComposedAdapterFactory adapterFactory;
    private SimplemapDocumentProvider documentProvider;
    private ElementInitializers initializers;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        PreferencesHint.registerPreferenceStore((PreferencesHint)DIAGRAM_PREFERENCES_HINT, (Object)this.getPreferenceStore());
        this.adapterFactory = this.createAdapterFactory();
    }

    public void stop(BundleContext context) throws Exception {
        this.adapterFactory.dispose();
        this.adapterFactory = null;
        this.initializers = null;
        instance = null;
        super.stop(context);
    }

    public static SimplemapDiagramEditorPlugin getInstance() {
        return instance;
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        ArrayList<AdapterFactory> factories = new ArrayList<AdapterFactory>();
        this.fillItemProviderFactories(factories);
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        for (AdapterFactory factory : factories) {
            composedAdapterFactory.addAdapterFactory(factory);
        }
        return composedAdapterFactory;
    }

    protected void fillItemProviderFactories(List<AdapterFactory> factories) {
        factories.add((AdapterFactory)new SimplemappingsItemProviderAdapterFactory());
        factories.add((AdapterFactory)new GMFGraphItemProviderAdapterFactory());
        factories.add((AdapterFactory)new GMFMapItemProviderAdapterFactory());
        factories.add((AdapterFactory)new GMFToolItemProviderAdapterFactory());
        factories.add((AdapterFactory)new ResourceItemProviderAdapterFactory());
        factories.add((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }

    public AdapterFactory getItemProvidersAdapterFactory() {
        return this.adapterFactory;
    }

    public String getItemLabel(Object item) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(item, IItemLabelProvider.class);
        if (labelProvider != null) {
            return labelProvider.getText(item);
        }
        return null;
    }

    public ImageDescriptor getItemImageDescriptor(Object item) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(item, IItemLabelProvider.class);
        if (labelProvider != null) {
            return ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage(item));
        }
        return null;
    }

    public Image getImage(Object item) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(item, IItemLabelProvider.class);
        if (labelProvider != null) {
            return ExtendedImageRegistry.getInstance().getImage(labelProvider.getImage(item));
        }
        return null;
    }

    public static ImageDescriptor getBundledImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public static ImageDescriptor findImageDescriptor(String path) {
        Path p = new Path(path);
        if (p.isAbsolute() && p.segmentCount() > 1) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)p.segment(0), (String)p.removeFirstSegments(1).makeAbsolute().toString());
        }
        return SimplemapDiagramEditorPlugin.getBundledImageDescriptor(p.makeAbsolute().toString());
    }

    public Image getBundledImage(String path) {
        Image image = this.getImageRegistry().get(path);
        if (image == null) {
            this.getImageRegistry().put(path, SimplemapDiagramEditorPlugin.getBundledImageDescriptor(path));
            image = this.getImageRegistry().get(path);
        }
        return image;
    }

    public static String getString(String key) {
        return Platform.getResourceString((Bundle)SimplemapDiagramEditorPlugin.getInstance().getBundle(), (String)("%" + key));
    }

    public SimplemapDocumentProvider getDocumentProvider() {
        if (this.documentProvider == null) {
            this.documentProvider = new SimplemapDocumentProvider();
        }
        return this.documentProvider;
    }

    public ElementInitializers getElementInitializers() {
        return this.initializers;
    }

    public void setElementInitializers(ElementInitializers i) {
        this.initializers = i;
    }

    public void logError(String error) {
        this.logError(error, null);
    }

    public void logError(String error, Throwable throwable) {
        if (error == null && throwable != null) {
            error = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(4, ID, 0, error, throwable));
        this.debug(error, throwable);
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Throwable throwable) {
        if (message == null && throwable != null) {
            message = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(1, ID, 0, message, throwable));
        this.debug(message, throwable);
    }

    private void debug(String message, Throwable throwable) {
        if (!this.isDebugging()) {
            return;
        }
        if (message != null) {
            System.err.println(message);
        }
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }
}

