/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.internal.validate.AbstractValidator;
import org.eclipse.gmf.internal.validate.DefUtils;
import org.eclipse.gmf.internal.validate.GMFValidationPlugin;
import org.eclipse.gmf.internal.validate.Messages;
import org.eclipse.osgi.util.NLS;

public class ExternModelImport {
    private static final String DIAGNOSTIC_SOURCE = "org.eclipse.gmf.validate.imports";
    private static final Object ROOT_TARGET_OBJECT_KEY = new Object();
    private final ResourceSet importedModels;
    private final EPackage.Registry registry = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
    private final HashSet<URI> myProcessedMetaModels = new HashSet();
    private final HashSet<EPackage> processedPackages;

    private ExternModelImport(EObject validatedObject) {
        this.importedModels = new ResourceSetImpl();
        Resource targetModel = validatedObject.eResource();
        if (targetModel != null) {
            this.importedModels.setURIConverter(targetModel.getResourceSet().getURIConverter());
        }
        this.importedModels.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        this.processedPackages = new HashSet();
    }

    public static EValidator newImportValidator() {
        return new AbstractValidator(){

            public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                ExternModelImport.ensureRootTargetInitialized(eObject, context);
                return true;
            }

            public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                ExternModelImport.ensureRootTargetInitialized(eObject, context);
                ExternModelImport importer = ExternModelImport.getImporter(context);
                if (eObject instanceof EAnnotation) {
                    return importer.processAnnotation((EAnnotation)eObject, diagnostics);
                }
                EPackage ePackage = eObject.eClass().getEPackage();
                if (!importer.hasPackageImportsProcessed(ePackage)) {
                    return importer.processAnnotations(eObject.eClass().getEPackage(), diagnostics);
                }
                return true;
            }

            public boolean validate(EDataType dataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
                return true;
            }
        };
    }

    public static ExternModelImport getImporter(Map<Object, Object> context) {
        Object value = context.get(ExternModelImport.class);
        if (value instanceof ExternModelImport) {
            return (ExternModelImport)value;
        }
        assert (value == null);
        EObject validationTarget = ExternModelImport.getRootTargetObject(context);
        ExternModelImport importer = new ExternModelImport(validationTarget);
        importer.initializeExternPackages(validationTarget);
        context.put(ExternModelImport.class, importer);
        return importer;
    }

    public EPackage.Registry getPackageRegistry() {
        return this.registry;
    }

    boolean hasPackageImportsProcessed(EPackage importingPackage) {
        return this.processedPackages.contains(importingPackage);
    }

    private boolean processAnnotations(EPackage importingPackage, DiagnosticChain diagnostics) {
        boolean result = true;
        for (EAnnotation next : importingPackage.getEAnnotations()) {
            result &= this.processAnnotation(next, diagnostics);
        }
        this.processedPackages.add(importingPackage);
        return result;
    }

    private boolean processAnnotation(EAnnotation annotation, DiagnosticChain diagnostics) {
        if ("http://www.eclipse.org/gmf/2005/constraints".equals(annotation.getSource())) {
            return this.processImportEAnnotation(annotation, diagnostics);
        }
        return true;
    }

    public void initializeExternPackages(EObject root) {
        Resource metaModelResource = root.eClass().getEPackage().eResource();
        if (metaModelResource != null && !this.myProcessedMetaModels.contains(metaModelResource.getURI())) {
            for (EObject nextResourceElement : metaModelResource.getContents()) {
                if (!(nextResourceElement instanceof EPackage)) continue;
                this.registerLocally((EPackage)nextResourceElement);
            }
            this.registerReferencedMetaModels(EcoreUtil.ExternalCrossReferencer.find((Resource)metaModelResource));
            this.myProcessedMetaModels.add(metaModelResource.getURI());
        }
        this.registerReferencedMetaModels(EcoreUtil.ExternalCrossReferencer.find((EObject)root));
    }

    static void ensureRootTargetInitialized(EObject target, Map<Object, Object> context) {
        if (context != null && !context.containsKey(ROOT_TARGET_OBJECT_KEY)) {
            context.put(ROOT_TARGET_OBJECT_KEY, EcoreUtil.getRootContainer((EObject)target, (boolean)true));
        }
    }

    private static EObject getRootTargetObject(Map<Object, Object> context) {
        Object rootObj = context.get(ROOT_TARGET_OBJECT_KEY);
        assert (rootObj == null || rootObj instanceof EObject);
        return (EObject)rootObj;
    }

    private void registerReferencedMetaModels(Map<EObject, Collection<EStructuralFeature.Setting>> externalCrossReferences) {
        for (EObject next : externalCrossReferences.keySet()) {
            GenClassifier genClassifier;
            EPackage nextPackage = null;
            if (next instanceof EClassifier) {
                nextPackage = ((EClassifier)next).getEPackage();
            } else if (next instanceof EPackage) {
                nextPackage = (EPackage)next;
            } else if (next instanceof GenPackage) {
                nextPackage = ((GenPackage)next).getEcorePackage();
            } else if (next instanceof GenClassifier && (genClassifier = (GenClassifier)next).getGenPackage() != null) {
                nextPackage = genClassifier.getGenPackage().getEcorePackage();
            }
            if (nextPackage == null) continue;
            this.registerLocally(nextPackage);
        }
    }

    private void registerLocally(EPackage nextPackage) {
        this.registry.put((Object)nextPackage.getNsURI(), (Object)this.registry.getEPackage(nextPackage.getNsURI()));
    }

    private boolean processImportEAnnotation(EAnnotation annotation, DiagnosticChain diagnostics) {
        boolean result = true;
        for (Map.Entry nextEntry : annotation.getDetails()) {
            if (!((String)nextEntry.getKey()).equals("import")) continue;
            String importVal = (String)nextEntry.getValue();
            if (importVal != null) {
                EPackage p = this.registry.getEPackage(importVal = importVal.trim());
                if (p != null) {
                    this.registerLocally(p);
                    return true;
                }
                if (this.loadAsResourceURI(importVal, annotation, diagnostics)) continue;
                result = false;
                continue;
            }
            result = false;
            ExternModelImport.reportInvalidModelURI(importVal, annotation.getEModelElement(), diagnostics);
        }
        return result;
    }

    private boolean loadAsResourceURI(String importValue, EAnnotation annotation, DiagnosticChain diagnostics) {
        try {
            URI modelURI = URI.createURI((String)importValue);
            try {
                this.importModelFromResource(modelURI);
            }
            catch (RuntimeException e) {
                ExternModelImport.reportModelLoadingError(importValue, annotation.getEModelElement(), diagnostics, e);
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ExternModelImport.reportInvalidModelURI(importValue, annotation.getEModelElement(), diagnostics);
            return false;
        }
        return true;
    }

    private static void reportInvalidModelURI(String modelURIValue, EModelElement annotatedElement, DiagnosticChain diagnostics) {
        Map.Entry<String, String> destObj = DefUtils.findAnnotationDetailEntry(annotatedElement, "http://www.eclipse.org/gmf/2005/constraints", "import", modelURIValue);
        assert (destObj != null);
        BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 305, NLS.bind((String)Messages.invalidModelImportUri, (Object)modelURIValue), new Object[]{destObj});
        diagnostics.add((Diagnostic)diagnostic);
    }

    private static void reportModelLoadingError(String modelURIValue, EModelElement annotatedElement, DiagnosticChain diagnostics, RuntimeException error) {
        Map.Entry<String, String> destObj = DefUtils.findAnnotationDetailEntry(annotatedElement, "http://www.eclipse.org/gmf/2005/constraints", "import", modelURIValue);
        assert (destObj != null);
        String message = NLS.bind((String)Messages.modelImportResourceLoadingError, (Object)modelURIValue, (Object)error.getLocalizedMessage());
        BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 305, message, new Object[]{destObj});
        diagnostics.add((Diagnostic)diagnostic);
        GMFValidationPlugin.log(diagnostic.getSeverity(), message, error);
    }

    private boolean importModelFromResource(URI modelURI) throws RuntimeException {
        EList contents = this.importedModels.getResource(modelURI, true).getContents();
        for (EObject nextObj : contents) {
            if (!(nextObj instanceof EPackage)) continue;
            EPackage ePackage = (EPackage)nextObj;
            if (ePackage.getNsURI() != null) {
                this.registerLocally(ePackage);
            }
            return true;
        }
        return false;
    }
}

