/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.karaf;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.generator.api.FromSelector;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.api.support.BaseGenerator;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;

public class KarafGenerator
extends BaseGenerator {
    private static final String KARAF = "karaf";
    private static final String KARAF_MAVEN_PLUGIN_ARTIFACT_ID = "karaf-maven-plugin";

    public KarafGenerator(GeneratorContext context) {
        super(context, KARAF, (FromSelector)new FromSelector.Default(context, KARAF));
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddGeneratedImageConfiguration(configs) && JKubeProjectUtil.hasPluginOfAnyArtifactId((JavaProject)this.getProject(), (String)KARAF_MAVEN_PLUGIN_ARTIFACT_ID);
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs, boolean prePackagePhase) {
        ImageConfiguration.ImageConfigurationBuilder imageBuilder = ImageConfiguration.builder();
        BuildConfiguration.BuildConfigurationBuilder buildBuilder = BuildConfiguration.builder();
        buildBuilder.ports(this.extractPorts());
        buildBuilder.putEnv("DEPLOYMENTS_DIR", this.getConfig(Config.BASE_DIR)).putEnv("KARAF_HOME", "/deployments/karaf");
        this.addSchemaLabels(buildBuilder, this.log);
        this.addFrom(buildBuilder);
        if (!prePackagePhase) {
            buildBuilder.assembly(this.createDefaultAssembly());
        }
        this.addLatestTagIfSnapshot(buildBuilder);
        imageBuilder.name(this.getImageName()).alias(this.getAlias()).build(buildBuilder.build());
        configs.add(imageBuilder.build());
        return configs;
    }

    protected List<String> extractPorts() {
        return Stream.of(this.getConfig(Config.WEB_PORT)).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private AssemblyConfiguration createDefaultAssembly() {
        return AssemblyConfiguration.builder().targetDir(this.getConfig(Config.BASE_DIR)).name("deployments").inline(Assembly.builder().fileSet(AssemblyFileSet.builder().directory(new File(this.getProject().getBuildDirectory(), "assembly")).outputDirectory(new File(KARAF)).exclude("bin/**").directoryMode("0775").build()).fileSet(AssemblyFileSet.builder().directory(this.getProject().getBuildDirectory().toPath().resolve("assembly").resolve("bin").toFile()).outputDirectory(new File(KARAF, "bin")).exclude("contrib/**").exclude("*.bat").directoryMode("0775").fileMode("0777").build()).build()).build();
    }

    private static enum Config implements Configs.Config
    {
        BASE_DIR("baseDir", "/deployments"),
        WEB_PORT("webPort", "8181");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

