/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.auth.handler;

import java.util.function.UnaryOperator;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.api.auth.RegistryAuthConfig;
import org.eclipse.jkube.kit.build.api.auth.RegistryAuthHandler;
import org.eclipse.jkube.kit.common.KitLogger;

public class FromConfigRegistryAuthHandler
implements RegistryAuthHandler {
    private final RegistryAuthConfig registryAuthConfig;
    private final KitLogger log;

    public FromConfigRegistryAuthHandler(RegistryAuthConfig registryAuthConfig, KitLogger log) {
        this.registryAuthConfig = registryAuthConfig;
        this.log = log;
    }

    @Override
    public String getId() {
        return "config";
    }

    @Override
    public AuthConfig create(RegistryAuthConfig.Kind kind, String user, String registry, UnaryOperator<String> decryptor) {
        if (this.registryAuthConfig.getUsername(kind) != null) {
            if (this.registryAuthConfig.getPassword(kind) == null) {
                throw new IllegalArgumentException("No 'password' given while using <authConfig> in configuration for mode " + (Object)((Object)kind));
            }
            this.log.debug("AuthConfig: credentials from plugin config", new Object[0]);
            return AuthConfig.fromRegistryAuthConfig(this.registryAuthConfig, kind, decryptor);
        }
        return null;
    }
}

