/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jkube.kit.config.resource.IngressRulePathConfig;

public class IngressRuleConfig {
    private String host;
    private List<IngressRulePathConfig> paths;

    public static IngressRuleConfigBuilder builder() {
        return new IngressRuleConfigBuilder();
    }

    public IngressRuleConfigBuilder toBuilder() {
        IngressRuleConfigBuilder builder = new IngressRuleConfigBuilder().host(this.host);
        if (this.paths != null) {
            builder.paths(this.paths);
        }
        return builder;
    }

    public IngressRuleConfig(String host, List<IngressRulePathConfig> paths) {
        this.host = host;
        this.paths = paths;
    }

    public IngressRuleConfig() {
    }

    public String getHost() {
        return this.host;
    }

    public List<IngressRulePathConfig> getPaths() {
        return this.paths;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IngressRuleConfig)) {
            return false;
        }
        IngressRuleConfig other = (IngressRuleConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        List<IngressRulePathConfig> this$paths = this.getPaths();
        List<IngressRulePathConfig> other$paths = other.getPaths();
        return !(this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IngressRuleConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        List<IngressRulePathConfig> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        return result;
    }

    public static class IngressRuleConfigBuilder {
        private String host;
        private ArrayList<IngressRulePathConfig> paths;

        IngressRuleConfigBuilder() {
        }

        public IngressRuleConfigBuilder host(String host) {
            this.host = host;
            return this;
        }

        public IngressRuleConfigBuilder path(IngressRulePathConfig path) {
            if (this.paths == null) {
                this.paths = new ArrayList();
            }
            this.paths.add(path);
            return this;
        }

        public IngressRuleConfigBuilder paths(Collection<? extends IngressRulePathConfig> paths) {
            if (paths == null) {
                throw new NullPointerException("paths cannot be null");
            }
            if (this.paths == null) {
                this.paths = new ArrayList();
            }
            this.paths.addAll(paths);
            return this;
        }

        public IngressRuleConfigBuilder clearPaths() {
            if (this.paths != null) {
                this.paths.clear();
            }
            return this;
        }

        public IngressRuleConfig build() {
            List<IngressRulePathConfig> paths;
            switch (this.paths == null ? 0 : this.paths.size()) {
                case 0: {
                    paths = Collections.emptyList();
                    break;
                }
                case 1: {
                    paths = Collections.singletonList(this.paths.get(0));
                    break;
                }
                default: {
                    paths = Collections.unmodifiableList(new ArrayList<IngressRulePathConfig>(this.paths));
                }
            }
            return new IngressRuleConfig(this.host, paths);
        }

        public String toString() {
            return "IngressRuleConfig.IngressRuleConfigBuilder(host=" + this.host + ", paths=" + this.paths + ")";
        }
    }
}

