/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.config.resource.ConfigMap;
import org.eclipse.jkube.kit.config.resource.ContainerResourcesConfig;
import org.eclipse.jkube.kit.config.resource.ControllerResourceConfig;
import org.eclipse.jkube.kit.config.resource.IngressConfig;
import org.eclipse.jkube.kit.config.resource.MetaDataConfig;
import org.eclipse.jkube.kit.config.resource.MetricsConfig;
import org.eclipse.jkube.kit.config.resource.ProbeConfig;
import org.eclipse.jkube.kit.config.resource.SecretConfig;
import org.eclipse.jkube.kit.config.resource.ServiceAccountConfig;
import org.eclipse.jkube.kit.config.resource.ServiceConfig;
import org.eclipse.jkube.kit.config.resource.VolumeConfig;

public class ResourceConfig {
    @Deprecated
    private Map<String, String> env;
    private MetaDataConfig labels;
    private MetaDataConfig annotations;
    @Deprecated
    private List<VolumeConfig> volumes;
    private List<SecretConfig> secrets;
    @Deprecated
    private String controllerName;
    private List<ServiceConfig> services;
    private List<String> remotes;
    private ConfigMap configMap;
    @Deprecated
    private ProbeConfig liveness;
    @Deprecated
    private ProbeConfig readiness;
    @Deprecated
    private ProbeConfig startup;
    private MetricsConfig metrics;
    @Deprecated
    private boolean containerPrivileged;
    @Deprecated
    private String imagePullPolicy;
    @Deprecated
    private Integer replicas;
    private String namespace;
    private String serviceAccount;
    private List<ServiceAccountConfig> serviceAccounts;
    private ContainerResourcesConfig openshiftBuildConfig;
    private Boolean createExternalUrls;
    private IngressConfig ingress;
    private String routeDomain;
    @Deprecated
    private String restartPolicy;
    private ControllerResourceConfig controller;
    private boolean useLegacyJKubePrefix;

    public final ControllerResourceConfig getController() {
        if (this.controller != null && this.isAnyControllerLegacyConfigFieldSet()) {
            throw new IllegalArgumentException("Can't use both controller and resource level controller configuration fields. Please migrate to controller configuration");
        }
        return this.controller == null ? this.controllerResourceConfigFromLegacyFields() : this.controller;
    }

    public static ResourceConfigBuilder toBuilder(ResourceConfig original) {
        return Optional.ofNullable(original).orElse(new ResourceConfig()).toBuilder();
    }

    private ControllerResourceConfig controllerResourceConfigFromLegacyFields() {
        ControllerResourceConfig.ControllerResourceConfigBuilder builder = ControllerResourceConfig.builder();
        if (this.env != null && !this.env.isEmpty()) {
            builder.env(this.env);
        }
        if (this.volumes != null) {
            builder.volumes(this.volumes);
        }
        if (StringUtils.isNotBlank((CharSequence)this.controllerName)) {
            builder.controllerName(this.controllerName);
        }
        if (this.liveness != null) {
            builder.liveness(this.liveness);
        }
        if (this.readiness != null) {
            builder.readiness(this.readiness);
        }
        if (this.startup != null) {
            builder.startup(this.startup);
        }
        if (this.imagePullPolicy != null) {
            builder.imagePullPolicy(this.imagePullPolicy);
        }
        if (this.replicas != null) {
            builder.replicas(this.replicas);
        }
        if (StringUtils.isNotBlank((CharSequence)this.restartPolicy)) {
            builder.restartPolicy(this.restartPolicy);
        }
        builder.containerPrivileged(this.containerPrivileged);
        return builder.build();
    }

    public boolean isAnyControllerLegacyConfigFieldSet() {
        return this.env != null && !this.env.isEmpty() || this.volumes != null && !this.volumes.isEmpty() || this.controllerName != null || this.liveness != null || this.readiness != null || this.startup != null || this.imagePullPolicy != null || this.replicas != null || this.restartPolicy != null || this.containerPrivileged;
    }

    public static ResourceConfigBuilder builder() {
        return new ResourceConfigBuilder();
    }

    public ResourceConfigBuilder toBuilder() {
        ResourceConfigBuilder builder = new ResourceConfigBuilder().env(this.env).labels(this.labels).annotations(this.annotations).controllerName(this.controllerName).configMap(this.configMap).liveness(this.liveness).readiness(this.readiness).startup(this.startup).metrics(this.metrics).containerPrivileged(this.containerPrivileged).imagePullPolicy(this.imagePullPolicy).replicas(this.replicas).namespace(this.namespace).serviceAccount(this.serviceAccount).openshiftBuildConfig(this.openshiftBuildConfig).createExternalUrls(this.createExternalUrls).ingress(this.ingress).routeDomain(this.routeDomain).restartPolicy(this.restartPolicy).controller(this.controller).useLegacyJKubePrefix(this.useLegacyJKubePrefix);
        if (this.volumes != null) {
            builder.volumes(this.volumes);
        }
        if (this.secrets != null) {
            builder.secrets(this.secrets);
        }
        if (this.services != null) {
            builder.services(this.services);
        }
        if (this.remotes != null) {
            builder.remotes(this.remotes);
        }
        if (this.serviceAccounts != null) {
            builder.serviceAccounts(this.serviceAccounts);
        }
        return builder;
    }

    public ResourceConfig(Map<String, String> env, MetaDataConfig labels, MetaDataConfig annotations, List<VolumeConfig> volumes, List<SecretConfig> secrets, String controllerName, List<ServiceConfig> services, List<String> remotes, ConfigMap configMap, ProbeConfig liveness, ProbeConfig readiness, ProbeConfig startup, MetricsConfig metrics, boolean containerPrivileged, String imagePullPolicy, Integer replicas, String namespace, String serviceAccount, List<ServiceAccountConfig> serviceAccounts, ContainerResourcesConfig openshiftBuildConfig, Boolean createExternalUrls, IngressConfig ingress, String routeDomain, String restartPolicy, ControllerResourceConfig controller, boolean useLegacyJKubePrefix) {
        this.env = env;
        this.labels = labels;
        this.annotations = annotations;
        this.volumes = volumes;
        this.secrets = secrets;
        this.controllerName = controllerName;
        this.services = services;
        this.remotes = remotes;
        this.configMap = configMap;
        this.liveness = liveness;
        this.readiness = readiness;
        this.startup = startup;
        this.metrics = metrics;
        this.containerPrivileged = containerPrivileged;
        this.imagePullPolicy = imagePullPolicy;
        this.replicas = replicas;
        this.namespace = namespace;
        this.serviceAccount = serviceAccount;
        this.serviceAccounts = serviceAccounts;
        this.openshiftBuildConfig = openshiftBuildConfig;
        this.createExternalUrls = createExternalUrls;
        this.ingress = ingress;
        this.routeDomain = routeDomain;
        this.restartPolicy = restartPolicy;
        this.controller = controller;
        this.useLegacyJKubePrefix = useLegacyJKubePrefix;
    }

    public ResourceConfig() {
    }

    @Deprecated
    public Map<String, String> getEnv() {
        return this.env;
    }

    public MetaDataConfig getLabels() {
        return this.labels;
    }

    public MetaDataConfig getAnnotations() {
        return this.annotations;
    }

    @Deprecated
    public List<VolumeConfig> getVolumes() {
        return this.volumes;
    }

    public List<SecretConfig> getSecrets() {
        return this.secrets;
    }

    @Deprecated
    public String getControllerName() {
        return this.controllerName;
    }

    public List<ServiceConfig> getServices() {
        return this.services;
    }

    public List<String> getRemotes() {
        return this.remotes;
    }

    public ConfigMap getConfigMap() {
        return this.configMap;
    }

    @Deprecated
    public ProbeConfig getLiveness() {
        return this.liveness;
    }

    @Deprecated
    public ProbeConfig getReadiness() {
        return this.readiness;
    }

    @Deprecated
    public ProbeConfig getStartup() {
        return this.startup;
    }

    public MetricsConfig getMetrics() {
        return this.metrics;
    }

    @Deprecated
    public boolean isContainerPrivileged() {
        return this.containerPrivileged;
    }

    @Deprecated
    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    @Deprecated
    public Integer getReplicas() {
        return this.replicas;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public List<ServiceAccountConfig> getServiceAccounts() {
        return this.serviceAccounts;
    }

    public ContainerResourcesConfig getOpenshiftBuildConfig() {
        return this.openshiftBuildConfig;
    }

    public Boolean getCreateExternalUrls() {
        return this.createExternalUrls;
    }

    public IngressConfig getIngress() {
        return this.ingress;
    }

    public String getRouteDomain() {
        return this.routeDomain;
    }

    @Deprecated
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public boolean isUseLegacyJKubePrefix() {
        return this.useLegacyJKubePrefix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceConfig)) {
            return false;
        }
        ResourceConfig other = (ResourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isContainerPrivileged() != other.isContainerPrivileged()) {
            return false;
        }
        if (this.isUseLegacyJKubePrefix() != other.isUseLegacyJKubePrefix()) {
            return false;
        }
        Integer this$replicas = this.getReplicas();
        Integer other$replicas = other.getReplicas();
        if (this$replicas == null ? other$replicas != null : !((Object)this$replicas).equals(other$replicas)) {
            return false;
        }
        Boolean this$createExternalUrls = this.getCreateExternalUrls();
        Boolean other$createExternalUrls = other.getCreateExternalUrls();
        if (this$createExternalUrls == null ? other$createExternalUrls != null : !((Object)this$createExternalUrls).equals(other$createExternalUrls)) {
            return false;
        }
        Map<String, String> this$env = this.getEnv();
        Map<String, String> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        MetaDataConfig this$labels = this.getLabels();
        MetaDataConfig other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        MetaDataConfig this$annotations = this.getAnnotations();
        MetaDataConfig other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        List<VolumeConfig> this$volumes = this.getVolumes();
        List<VolumeConfig> other$volumes = other.getVolumes();
        if (this$volumes == null ? other$volumes != null : !((Object)this$volumes).equals(other$volumes)) {
            return false;
        }
        List<SecretConfig> this$secrets = this.getSecrets();
        List<SecretConfig> other$secrets = other.getSecrets();
        if (this$secrets == null ? other$secrets != null : !((Object)this$secrets).equals(other$secrets)) {
            return false;
        }
        String this$controllerName = this.getControllerName();
        String other$controllerName = other.getControllerName();
        if (this$controllerName == null ? other$controllerName != null : !this$controllerName.equals(other$controllerName)) {
            return false;
        }
        List<ServiceConfig> this$services = this.getServices();
        List<ServiceConfig> other$services = other.getServices();
        if (this$services == null ? other$services != null : !((Object)this$services).equals(other$services)) {
            return false;
        }
        List<String> this$remotes = this.getRemotes();
        List<String> other$remotes = other.getRemotes();
        if (this$remotes == null ? other$remotes != null : !((Object)this$remotes).equals(other$remotes)) {
            return false;
        }
        ConfigMap this$configMap = this.getConfigMap();
        ConfigMap other$configMap = other.getConfigMap();
        if (this$configMap == null ? other$configMap != null : !this$configMap.equals(other$configMap)) {
            return false;
        }
        ProbeConfig this$liveness = this.getLiveness();
        ProbeConfig other$liveness = other.getLiveness();
        if (this$liveness == null ? other$liveness != null : !((Object)this$liveness).equals(other$liveness)) {
            return false;
        }
        ProbeConfig this$readiness = this.getReadiness();
        ProbeConfig other$readiness = other.getReadiness();
        if (this$readiness == null ? other$readiness != null : !((Object)this$readiness).equals(other$readiness)) {
            return false;
        }
        ProbeConfig this$startup = this.getStartup();
        ProbeConfig other$startup = other.getStartup();
        if (this$startup == null ? other$startup != null : !((Object)this$startup).equals(other$startup)) {
            return false;
        }
        MetricsConfig this$metrics = this.getMetrics();
        MetricsConfig other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics)) {
            return false;
        }
        String this$imagePullPolicy = this.getImagePullPolicy();
        String other$imagePullPolicy = other.getImagePullPolicy();
        if (this$imagePullPolicy == null ? other$imagePullPolicy != null : !this$imagePullPolicy.equals(other$imagePullPolicy)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$serviceAccount = this.getServiceAccount();
        String other$serviceAccount = other.getServiceAccount();
        if (this$serviceAccount == null ? other$serviceAccount != null : !this$serviceAccount.equals(other$serviceAccount)) {
            return false;
        }
        List<ServiceAccountConfig> this$serviceAccounts = this.getServiceAccounts();
        List<ServiceAccountConfig> other$serviceAccounts = other.getServiceAccounts();
        if (this$serviceAccounts == null ? other$serviceAccounts != null : !((Object)this$serviceAccounts).equals(other$serviceAccounts)) {
            return false;
        }
        ContainerResourcesConfig this$openshiftBuildConfig = this.getOpenshiftBuildConfig();
        ContainerResourcesConfig other$openshiftBuildConfig = other.getOpenshiftBuildConfig();
        if (this$openshiftBuildConfig == null ? other$openshiftBuildConfig != null : !((Object)this$openshiftBuildConfig).equals(other$openshiftBuildConfig)) {
            return false;
        }
        IngressConfig this$ingress = this.getIngress();
        IngressConfig other$ingress = other.getIngress();
        if (this$ingress == null ? other$ingress != null : !((Object)this$ingress).equals(other$ingress)) {
            return false;
        }
        String this$routeDomain = this.getRouteDomain();
        String other$routeDomain = other.getRouteDomain();
        if (this$routeDomain == null ? other$routeDomain != null : !this$routeDomain.equals(other$routeDomain)) {
            return false;
        }
        String this$restartPolicy = this.getRestartPolicy();
        String other$restartPolicy = other.getRestartPolicy();
        if (this$restartPolicy == null ? other$restartPolicy != null : !this$restartPolicy.equals(other$restartPolicy)) {
            return false;
        }
        ControllerResourceConfig this$controller = this.getController();
        ControllerResourceConfig other$controller = other.getController();
        return !(this$controller == null ? other$controller != null : !((Object)this$controller).equals(other$controller));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isContainerPrivileged() ? 79 : 97);
        result = result * 59 + (this.isUseLegacyJKubePrefix() ? 79 : 97);
        Integer $replicas = this.getReplicas();
        result = result * 59 + ($replicas == null ? 43 : ((Object)$replicas).hashCode());
        Boolean $createExternalUrls = this.getCreateExternalUrls();
        result = result * 59 + ($createExternalUrls == null ? 43 : ((Object)$createExternalUrls).hashCode());
        Map<String, String> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        MetaDataConfig $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        MetaDataConfig $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        List<VolumeConfig> $volumes = this.getVolumes();
        result = result * 59 + ($volumes == null ? 43 : ((Object)$volumes).hashCode());
        List<SecretConfig> $secrets = this.getSecrets();
        result = result * 59 + ($secrets == null ? 43 : ((Object)$secrets).hashCode());
        String $controllerName = this.getControllerName();
        result = result * 59 + ($controllerName == null ? 43 : $controllerName.hashCode());
        List<ServiceConfig> $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
        List<String> $remotes = this.getRemotes();
        result = result * 59 + ($remotes == null ? 43 : ((Object)$remotes).hashCode());
        ConfigMap $configMap = this.getConfigMap();
        result = result * 59 + ($configMap == null ? 43 : $configMap.hashCode());
        ProbeConfig $liveness = this.getLiveness();
        result = result * 59 + ($liveness == null ? 43 : ((Object)$liveness).hashCode());
        ProbeConfig $readiness = this.getReadiness();
        result = result * 59 + ($readiness == null ? 43 : ((Object)$readiness).hashCode());
        ProbeConfig $startup = this.getStartup();
        result = result * 59 + ($startup == null ? 43 : ((Object)$startup).hashCode());
        MetricsConfig $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
        String $imagePullPolicy = this.getImagePullPolicy();
        result = result * 59 + ($imagePullPolicy == null ? 43 : $imagePullPolicy.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $serviceAccount = this.getServiceAccount();
        result = result * 59 + ($serviceAccount == null ? 43 : $serviceAccount.hashCode());
        List<ServiceAccountConfig> $serviceAccounts = this.getServiceAccounts();
        result = result * 59 + ($serviceAccounts == null ? 43 : ((Object)$serviceAccounts).hashCode());
        ContainerResourcesConfig $openshiftBuildConfig = this.getOpenshiftBuildConfig();
        result = result * 59 + ($openshiftBuildConfig == null ? 43 : ((Object)$openshiftBuildConfig).hashCode());
        IngressConfig $ingress = this.getIngress();
        result = result * 59 + ($ingress == null ? 43 : ((Object)$ingress).hashCode());
        String $routeDomain = this.getRouteDomain();
        result = result * 59 + ($routeDomain == null ? 43 : $routeDomain.hashCode());
        String $restartPolicy = this.getRestartPolicy();
        result = result * 59 + ($restartPolicy == null ? 43 : $restartPolicy.hashCode());
        ControllerResourceConfig $controller = this.getController();
        result = result * 59 + ($controller == null ? 43 : ((Object)$controller).hashCode());
        return result;
    }

    public static class ResourceConfigBuilder {
        private Map<String, String> env;
        private MetaDataConfig labels;
        private MetaDataConfig annotations;
        private ArrayList<VolumeConfig> volumes;
        private ArrayList<SecretConfig> secrets;
        private String controllerName;
        private ArrayList<ServiceConfig> services;
        private ArrayList<String> remotes;
        private ConfigMap configMap;
        private ProbeConfig liveness;
        private ProbeConfig readiness;
        private ProbeConfig startup;
        private MetricsConfig metrics;
        private boolean containerPrivileged;
        private String imagePullPolicy;
        private Integer replicas;
        private String namespace;
        private String serviceAccount;
        private ArrayList<ServiceAccountConfig> serviceAccounts;
        private ContainerResourcesConfig openshiftBuildConfig;
        private Boolean createExternalUrls;
        private IngressConfig ingress;
        private String routeDomain;
        private String restartPolicy;
        private ControllerResourceConfig controller;
        private boolean useLegacyJKubePrefix;

        ResourceConfigBuilder() {
        }

        @Deprecated
        public ResourceConfigBuilder env(Map<String, String> env) {
            this.env = env;
            return this;
        }

        public ResourceConfigBuilder labels(MetaDataConfig labels) {
            this.labels = labels;
            return this;
        }

        public ResourceConfigBuilder annotations(MetaDataConfig annotations) {
            this.annotations = annotations;
            return this;
        }

        @Deprecated
        public ResourceConfigBuilder volume(VolumeConfig volume) {
            if (this.volumes == null) {
                this.volumes = new ArrayList();
            }
            this.volumes.add(volume);
            return this;
        }

        @Deprecated
        public ResourceConfigBuilder volumes(Collection<? extends VolumeConfig> volumes) {
            if (volumes == null) {
                throw new NullPointerException("volumes cannot be null");
            }
            if (this.volumes == null) {
                this.volumes = new ArrayList();
            }
            this.volumes.addAll(volumes);
            return this;
        }

        @Deprecated
        public ResourceConfigBuilder clearVolumes() {
            if (this.volumes != null) {
                this.volumes.clear();
            }
            return this;
        }

        public ResourceConfigBuilder secret(SecretConfig secret) {
            if (this.secrets == null) {
                this.secrets = new ArrayList();
            }
            this.secrets.add(secret);
            return this;
        }

        public ResourceConfigBuilder secrets(Collection<? extends SecretConfig> secrets) {
            if (secrets == null) {
                throw new NullPointerException("secrets cannot be null");
            }
            if (this.secrets == null) {
                this.secrets = new ArrayList();
            }
            this.secrets.addAll(secrets);
            return this;
        }

        public ResourceConfigBuilder clearSecrets() {
            if (this.secrets != null) {
                this.secrets.clear();
            }
            return this;
        }

        @Deprecated
        public ResourceConfigBuilder controllerName(String controllerName) {
            this.controllerName = controllerName;
            return this;
        }

        public ResourceConfigBuilder service(ServiceConfig service) {
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.add(service);
            return this;
        }

        public ResourceConfigBuilder services(Collection<? extends ServiceConfig> services) {
            if (services == null) {
                throw new NullPointerException("services cannot be null");
            }
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.addAll(services);
            return this;
        }

        public ResourceConfigBuilder clearServices() {
            if (this.services != null) {
                this.services.clear();
            }
            return this;
        }

        public ResourceConfigBuilder remote(String remote) {
            if (this.remotes == null) {
                this.remotes = new ArrayList();
            }
            this.remotes.add(remote);
            return this;
        }

        public ResourceConfigBuilder remotes(Collection<? extends String> remotes) {
            if (remotes == null) {
                throw new NullPointerException("remotes cannot be null");
            }
            if (this.remotes == null) {
                this.remotes = new ArrayList();
            }
            this.remotes.addAll(remotes);
            return this;
        }

        public ResourceConfigBuilder clearRemotes() {
            if (this.remotes != null) {
                this.remotes.clear();
            }
            return this;
        }

        public ResourceConfigBuilder configMap(ConfigMap configMap) {
            this.configMap = configMap;
            return this;
        }

        @Deprecated
        public ResourceConfigBuilder liveness(ProbeConfig liveness) {
            this.liveness = liveness;
            return this;
        }

        @Deprecated
        public ResourceConfigBuilder readiness(ProbeConfig readiness) {
            this.readiness = readiness;
            return this;
        }

        @Deprecated
        public ResourceConfigBuilder startup(ProbeConfig startup) {
            this.startup = startup;
            return this;
        }

        public ResourceConfigBuilder metrics(MetricsConfig metrics) {
            this.metrics = metrics;
            return this;
        }

        @Deprecated
        public ResourceConfigBuilder containerPrivileged(boolean containerPrivileged) {
            this.containerPrivileged = containerPrivileged;
            return this;
        }

        @Deprecated
        public ResourceConfigBuilder imagePullPolicy(String imagePullPolicy) {
            this.imagePullPolicy = imagePullPolicy;
            return this;
        }

        @Deprecated
        public ResourceConfigBuilder replicas(Integer replicas) {
            this.replicas = replicas;
            return this;
        }

        public ResourceConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ResourceConfigBuilder serviceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        public ResourceConfigBuilder serviceAccount(ServiceAccountConfig serviceAccount) {
            if (this.serviceAccounts == null) {
                this.serviceAccounts = new ArrayList();
            }
            this.serviceAccounts.add(serviceAccount);
            return this;
        }

        public ResourceConfigBuilder serviceAccounts(Collection<? extends ServiceAccountConfig> serviceAccounts) {
            if (serviceAccounts == null) {
                throw new NullPointerException("serviceAccounts cannot be null");
            }
            if (this.serviceAccounts == null) {
                this.serviceAccounts = new ArrayList();
            }
            this.serviceAccounts.addAll(serviceAccounts);
            return this;
        }

        public ResourceConfigBuilder clearServiceAccounts() {
            if (this.serviceAccounts != null) {
                this.serviceAccounts.clear();
            }
            return this;
        }

        public ResourceConfigBuilder openshiftBuildConfig(ContainerResourcesConfig openshiftBuildConfig) {
            this.openshiftBuildConfig = openshiftBuildConfig;
            return this;
        }

        public ResourceConfigBuilder createExternalUrls(Boolean createExternalUrls) {
            this.createExternalUrls = createExternalUrls;
            return this;
        }

        public ResourceConfigBuilder ingress(IngressConfig ingress) {
            this.ingress = ingress;
            return this;
        }

        public ResourceConfigBuilder routeDomain(String routeDomain) {
            this.routeDomain = routeDomain;
            return this;
        }

        @Deprecated
        public ResourceConfigBuilder restartPolicy(String restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        public ResourceConfigBuilder controller(ControllerResourceConfig controller) {
            this.controller = controller;
            return this;
        }

        public ResourceConfigBuilder useLegacyJKubePrefix(boolean useLegacyJKubePrefix) {
            this.useLegacyJKubePrefix = useLegacyJKubePrefix;
            return this;
        }

        public ResourceConfig build() {
            List<ServiceAccountConfig> serviceAccounts;
            List<String> remotes;
            List<ServiceConfig> services;
            List<SecretConfig> secrets;
            List<VolumeConfig> volumes;
            switch (this.volumes == null ? 0 : this.volumes.size()) {
                case 0: {
                    volumes = Collections.emptyList();
                    break;
                }
                case 1: {
                    volumes = Collections.singletonList(this.volumes.get(0));
                    break;
                }
                default: {
                    volumes = Collections.unmodifiableList(new ArrayList<VolumeConfig>(this.volumes));
                }
            }
            switch (this.secrets == null ? 0 : this.secrets.size()) {
                case 0: {
                    secrets = Collections.emptyList();
                    break;
                }
                case 1: {
                    secrets = Collections.singletonList(this.secrets.get(0));
                    break;
                }
                default: {
                    secrets = Collections.unmodifiableList(new ArrayList<SecretConfig>(this.secrets));
                }
            }
            switch (this.services == null ? 0 : this.services.size()) {
                case 0: {
                    services = Collections.emptyList();
                    break;
                }
                case 1: {
                    services = Collections.singletonList(this.services.get(0));
                    break;
                }
                default: {
                    services = Collections.unmodifiableList(new ArrayList<ServiceConfig>(this.services));
                }
            }
            switch (this.remotes == null ? 0 : this.remotes.size()) {
                case 0: {
                    remotes = Collections.emptyList();
                    break;
                }
                case 1: {
                    remotes = Collections.singletonList(this.remotes.get(0));
                    break;
                }
                default: {
                    remotes = Collections.unmodifiableList(new ArrayList<String>(this.remotes));
                }
            }
            switch (this.serviceAccounts == null ? 0 : this.serviceAccounts.size()) {
                case 0: {
                    serviceAccounts = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceAccounts = Collections.singletonList(this.serviceAccounts.get(0));
                    break;
                }
                default: {
                    serviceAccounts = Collections.unmodifiableList(new ArrayList<ServiceAccountConfig>(this.serviceAccounts));
                }
            }
            return new ResourceConfig(this.env, this.labels, this.annotations, volumes, secrets, this.controllerName, services, remotes, this.configMap, this.liveness, this.readiness, this.startup, this.metrics, this.containerPrivileged, this.imagePullPolicy, this.replicas, this.namespace, this.serviceAccount, serviceAccounts, this.openshiftBuildConfig, this.createExternalUrls, this.ingress, this.routeDomain, this.restartPolicy, this.controller, this.useLegacyJKubePrefix);
        }

        public String toString() {
            return "ResourceConfig.ResourceConfigBuilder(env=" + this.env + ", labels=" + this.labels + ", annotations=" + this.annotations + ", volumes=" + this.volumes + ", secrets=" + this.secrets + ", controllerName=" + this.controllerName + ", services=" + this.services + ", remotes=" + this.remotes + ", configMap=" + this.configMap + ", liveness=" + this.liveness + ", readiness=" + this.readiness + ", startup=" + this.startup + ", metrics=" + this.metrics + ", containerPrivileged=" + this.containerPrivileged + ", imagePullPolicy=" + this.imagePullPolicy + ", replicas=" + this.replicas + ", namespace=" + this.namespace + ", serviceAccount=" + this.serviceAccount + ", serviceAccounts=" + this.serviceAccounts + ", openshiftBuildConfig=" + this.openshiftBuildConfig + ", createExternalUrls=" + this.createExternalUrls + ", ingress=" + this.ingress + ", routeDomain=" + this.routeDomain + ", restartPolicy=" + this.restartPolicy + ", controller=" + this.controller + ", useLegacyJKubePrefix=" + this.useLegacyJKubePrefix + ")";
        }
    }
}

