/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.jobs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.CloseableContainer;
import org.eclipse.linuxtools.internal.docker.core.ContainerFileProxy;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerImage;
import org.eclipse.linuxtools.internal.docker.ui.jobs.JobMessages;

public class CopyFromDockerJob
extends Job {
    private static final String COPY_STATE_FILE = ".copyState";
    private static final String IMAGE_ID_FILE = ".image_id";
    private static final boolean isWin = File.separatorChar == '\\';
    private static final int MAXLINKDEPTH = 20;
    private static Object m_lockObject = new Object();
    private static Object m_lockObjectManagedInit = new Object();
    private static Map<Path, String> m_targetpathToImageIdMap = new HashMap<Path, String>();
    private static Map<Path, HashSet<Path>> m_pathToCopiedList = new HashMap<Path, HashSet<Path>>();
    private static Map<Path, Map<Path, Job>> m_targetpathToCopyingMap = new HashMap<Path, Map<Path, Job>>();
    private Map<Path, Job> m_copyingMap;
    private Set<Path> m_copiedList;
    private IProgressMonitor m_monitor = null;
    private final DockerConnection m_connection;
    private final String m_image;
    private final Path m_targetfolder;
    private final boolean m_mirror;
    private Map<Path, Path> m_pathsToCopy;
    private String m_containerId = null;
    private String m_imageId = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<IPath> getCopiedPaths(Path folder) {
        HashSet<Path> ps = CopyFromDockerJob.getCopiedSet(folder);
        Object object = m_lockObject;
        synchronized (object) {
            return (Set)ps.clone();
        }
    }

    public CopyFromDockerJob(IDockerConnection connection, CopyType copyType, String desc, Set<Path> copySet, Path targetDir) {
        this(connection, copyType, desc, copySet.stream().collect(Collectors.toMap(x -> x, x -> targetDir)));
    }

    public CopyFromDockerJob(IDockerConnection connection, CopyType copyType, String desc, Map<Path, Path> copyMap) {
        super(JobMessages.getString("CopyFromDockerJob.title"));
        this.m_connection = (DockerConnection)connection;
        this.m_containerId = null;
        if (copyType == CopyType.Container || copyType == CopyType.ContainerMirror) {
            this.m_image = null;
            this.m_containerId = desc;
        } else if (copyType == CopyType.Image || copyType == CopyType.ImageMirror) {
            this.m_image = desc;
            this.m_containerId = null;
        } else {
            throw new IllegalArgumentException();
        }
        if (copyType == CopyType.Container || copyType == CopyType.Image) {
            this.m_mirror = false;
            this.m_targetfolder = null;
        } else {
            this.m_mirror = true;
            this.m_targetfolder = copyMap.values().iterator().next();
        }
        this.getImageId();
        if (this.m_mirror) assert (copyMap.values().stream().allMatch(x -> x.equals((Object)this.m_targetfolder))) : "In mirror-mode all target paths must point to the same folder";
        this.m_pathsToCopy = copyMap;
    }

    private Path toHost(IPath pathInDocker, Path copyBasePath, Path targetBasePath) {
        if (this.m_mirror) {
            return (Path)this.m_targetfolder.append(pathInDocker);
        }
        assert (this.isInCopyPath(pathInDocker, copyBasePath)) : MessageFormat.format("The path {0} is not part of {1}", pathInDocker.toString(), copyBasePath.toString());
        return (Path)targetBasePath.append(pathInDocker.removeFirstSegments(copyBasePath.segmentCount()));
    }

    private boolean isInCopyPath(IPath dockerpath, Path basepath) {
        return this.m_mirror || basepath.isPrefixOf(dockerpath);
    }

    private static Set<PosixFilePermission> toPerms(int mode) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        if ((mode & 0x100) != 0) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) != 0) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) != 0) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) != 0) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) != 0) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) != 0) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) != 0) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) != 0) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) != 0) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms;
    }

    Path mkdirSyms(String containerId, Path path, Path hostDir) throws DockerException, IOException {
        assert (this.m_mirror);
        for (int i = 0; i < path.segmentCount(); ++i) {
            IPath curpath = path.uptoSegment(i);
            List dir = this.m_connection.readContainerDirectory(containerId, curpath.toString());
            if (dir.isEmpty()) {
                Activator.logWarningMessage(MessageFormat.format("Could not get dirlist of {0}", curpath.toString()));
            }
            String nextp = path.segments()[i];
            ContainerFileProxy e = dir.stream().filter(ent -> nextp.equals(ent.getName())).findAny().orElse(null);
            if (e == null) {
                Activator.logWarningMessage(JobMessages.getFormattedString("CopyFromDockerJob.docker.failed.find.file", new String[]{nextp, curpath.toString(), path.toString()}));
                return null;
            }
            if (e.isLink()) {
                Path linkTarget = e.getLink().startsWith("/") ? new Path(e.getLink()) : (Path)curpath.append(e.getLink());
                SymLink sl = new SymLink((Path)path.uptoSegment(i + 1), linkTarget, hostDir, e.isFolder());
                Path rv = (Path)linkTarget.append(path.removeFirstSegments(i + 1));
                if (!sl.targetExists()) {
                    rv = this.mkdirSyms(containerId, rv, hostDir);
                }
                if (rv != null) {
                    sl.create();
                }
                return rv;
            }
            this.toHost(path.uptoSegment(i + 1), Path.ROOT, hostDir).toFile().mkdir();
        }
        return path;
    }

    private boolean copyTar(Path tarPath, Path hostpath, InputStream tarStream, Set<SymLink> symlinkBacklog, IProgressMonitor monitor) throws IOException {
        File targetdir = this.toHost((IPath)tarPath, tarPath, hostpath).removeLastSegments(1).toFile();
        if (!targetdir.exists() && !targetdir.mkdirs()) {
            throw new IOException(JobMessages.getFormattedString("CopyFromDockerJob.create.failed.dir", this.toHost((IPath)tarPath, tarPath, hostpath).toString()));
        }
        boolean successful = true;
        try (TarArchiveInputStream k = new TarArchiveInputStream((InputStream)new BlockingInputStream(tarStream));){
            TarArchiveEntry te = null;
            while ((te = k.getNextEntry()) != null) {
                Path copypath = new Path(te.getName());
                Path path = (Path)tarPath.append(copypath.removeFirstSegments(1));
                File f = this.toHost((IPath)path, tarPath, hostpath).toFile();
                int mode = te.getMode();
                String basemsg = JobMessages.getString("CopyFromDockerJob.tar.copy");
                if (te.isCharacterDevice()) {
                    Activator.logWarningMessage(basemsg + MessageFormat.format(JobMessages.getString("CopyFromDockerJob.tar.copy.no.chardev"), tarPath.append(te.getName()).toString()));
                    successful = false;
                    continue;
                }
                if (te.isBlockDevice()) {
                    Activator.logWarningMessage(basemsg + MessageFormat.format(JobMessages.getString("CopyFromDockerJob.tar.copy.no.blockdev"), tarPath.append(te.getName()).toString()));
                    successful = false;
                    continue;
                }
                if (te.isFIFO()) {
                    Activator.logWarningMessage(basemsg + JobMessages.getFormattedString("CopyFromDockerJob.tar.copy.no.fifo", tarPath.append(te.getName()).toString()));
                    successful = false;
                    continue;
                }
                if (te.isSymbolicLink() || te.isLink()) {
                    SymLink sl;
                    if (te.isLink()) {
                        Activator.logWarningMessage(basemsg + MessageFormat.format(JobMessages.getString("CopyFromDockerJob.create.failed.link.symlink"), path.toString(), tarPath.append(te.getLinkName()).removeFirstSegments(1)).toString());
                    }
                    if ((sl = new SymLink(path, tarPath, hostpath, te)).targetInBase() && sl.create()) continue;
                    symlinkBacklog.add(sl);
                    continue;
                }
                if (te.isDirectory()) {
                    if (f.exists()) {
                        if (f.isDirectory()) continue;
                        Activator.logWarningMessage(JobMessages.getFormattedString("CopyFromDockerJob.create.failed.dir.already.exists", f.getAbsolutePath()));
                        successful = false;
                        continue;
                    }
                    if (!f.mkdir()) {
                        Activator.logWarningMessage(JobMessages.getFormattedString("CopyFromDockerJob.create.failed.dir", f.getAbsolutePath()));
                        successful = false;
                        continue;
                    }
                    if (isWin || te.isSymbolicLink()) continue;
                    Files.setPosixFilePermissions(f.toPath(), CopyFromDockerJob.toPerms(mode));
                    continue;
                }
                if (te.isFile()) {
                    block30: {
                        if (f.exists()) {
                            if (this.checkWasCopied(path)) continue;
                            if (f.isDirectory()) {
                                Activator.logWarningMessage(JobMessages.getFormattedString("CopyFromDockerJob.create.failed.file.dir.exists", f.getAbsolutePath()));
                                successful = false;
                                continue;
                            }
                            Activator.logWarningMessage(MessageFormat.format(JobMessages.getString("CopyFromDockerJob.create.failed.file.overwritten"), f.getAbsolutePath()));
                        } else {
                            try {
                                if (!f.createNewFile()) {
                                    Activator.logWarningMessage(JobMessages.getFormattedString("CopyFromDockerJob.create.failed", f.getAbsolutePath()));
                                    successful = false;
                                }
                                break block30;
                            }
                            catch (IOException e) {
                                Activator.logErrorMessage(JobMessages.getFormattedString("CopyFromDockerJob.create.failed", f.getAbsolutePath()), e);
                                successful = false;
                            }
                            continue;
                        }
                    }
                    if (!isWin) {
                        Files.setPosixFilePermissions(f.toPath(), CopyFromDockerJob.toPerms(mode));
                    }
                    FileOutputStream os = new FileOutputStream(f);
                    try {
                        byte[] barray = new byte[4096];
                        int result = -1;
                        while ((result = k.read(barray, 0, barray.length)) > -1) {
                            if (monitor.isCanceled()) {
                                throw new RuntimeException(JobMessages.getString("CopyFromDockerJob.cancel.user"));
                            }
                            os.write(barray, 0, result);
                        }
                        continue;
                    }
                    finally {
                        os.close();
                        continue;
                    }
                }
                throw new RuntimeException("Unsupported Tar file entry that should not exist");
            }
        }
        return successful;
    }

    private String getImageId() {
        if (this.m_imageId != null) {
            return this.m_imageId;
        }
        if (this.m_containerId != null) {
            IDockerContainerInfo containerinfo = this.m_connection.getContainerInfo(this.m_containerId);
            this.m_imageId = containerinfo.image();
        } else if (this.m_image != null) {
            List images;
            Optional<IDockerImage> oImage;
            IDockerImage dockerImage = this.m_connection.getImageByTag(this.m_image);
            if (dockerImage == null && (oImage = (images = this.m_connection.getImages()).stream().filter(f -> ((DockerImage)f).shortId().equals(this.m_image)).findFirst()).isPresent()) {
                dockerImage = oImage.get();
            }
            if (dockerImage == null) {
                throw new RuntimeException(JobMessages.getFormattedString("CopyFromDockerJob.docker.no.image", this.m_image));
            }
            this.m_imageId = dockerImage.id();
        } else assert (false) : "Neither container nor image set. Broken init?";
        return this.m_imageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashSet<Path> getCopiedSet(Path targetPath) {
        Object object = m_lockObjectManagedInit;
        synchronized (object) {
            File dirFile;
            HashSet copiedList = m_pathToCopiedList.get(targetPath);
            if (copiedList == null && (dirFile = targetPath.append(COPY_STATE_FILE).toFile()).exists()) {
                try (FileInputStream f = new FileInputStream(dirFile);){
                    try (ObjectInputStream ois = new ObjectInputStream(f);){
                        HashSet temp = (HashSet)ois.readObject();
                        copiedList = temp.stream().map(x -> new Path(x)).collect(Collectors.toCollection(HashSet::new));
                        m_pathToCopiedList.put(targetPath, copiedList);
                    }
                    catch (FileNotFoundException | ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (copiedList == null) {
                copiedList = new HashSet(0);
                m_pathToCopiedList.put(targetPath, copiedList);
            }
            return copiedList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initmirror() throws FileNotFoundException, IOException, InterruptedException {
        assert (this.m_mirror);
        String dockerImageId = this.getImageId();
        File imageFile = this.m_targetfolder.append(IMAGE_ID_FILE).toFile();
        Object object = m_lockObjectManagedInit;
        synchronized (object) {
            String imageId = m_targetpathToImageIdMap.getOrDefault(this.m_targetfolder, "");
            this.m_copyingMap = m_targetpathToCopyingMap.get(this.m_targetfolder);
            if (this.m_copyingMap == null) {
                this.m_copyingMap = new HashMap<Path, Job>();
                m_targetpathToCopyingMap.put(this.m_targetfolder, this.m_copyingMap);
            }
            this.m_copiedList = CopyFromDockerJob.getCopiedSet(this.m_targetfolder);
            if (imageId.isEmpty() && imageFile.exists()) {
                try (BufferedReader bufferReader = new BufferedReader(new FileReader(imageFile));){
                    imageId = bufferReader.readLine();
                }
            }
            if (!dockerImageId.equals(imageId)) {
                while (true) {
                    Job j = null;
                    Object object2 = m_lockObject;
                    synchronized (object2) {
                        if (this.m_copyingMap.isEmpty()) {
                            this.m_copiedList.clear();
                            break;
                        }
                        j = this.m_copyingMap.values().iterator().next();
                    }
                    this.m_monitor.subTask(JobMessages.getString("CopyFromDockerJob.waiting.for.job"));
                    j.join(0L, this.m_monitor);
                }
                if (this.m_targetfolder.toFile().exists()) {
                    List<java.nio.file.Path> paths = Files.walk(this.m_targetfolder.toFile().toPath(), new FileVisitOption[0]).toList();
                    Collections.reverse(paths);
                    paths.stream().forEach(p -> p.toFile().delete());
                }
                imageFile.getParentFile().mkdirs();
                try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(imageFile));){
                    bufferedWriter.write(dockerImageId);
                    bufferedWriter.newLine();
                }
            }
            m_targetpathToImageIdMap.put(this.m_targetfolder, dockerImageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMirrorState() {
        assert (this.m_mirror);
        if (this.m_copiedList != null) {
            Object object = m_lockObject;
            synchronized (object) {
                File dirFile = this.m_targetfolder.append(COPY_STATE_FILE).toFile();
                Set writelist = this.m_copiedList.stream().map(x -> x.toString()).collect(Collectors.toSet());
                try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(dirFile));){
                    oos.writeObject(writelist);
                }
                catch (IOException e) {
                    Activator.logErrorMessage(JobMessages.getString("CopyFromDockerJob.failed.save.state"), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfAlreadyCopied(Path path) {
        assert (this.m_mirror);
        Object object = m_lockObjectManagedInit;
        synchronized (object) {
            String dockerImageId = this.getImageId();
            assert (dockerImageId.equals(m_targetpathToImageIdMap.get(this.m_targetfolder))) : "Mirroring multiple Images to the same folder is not possible";
        }
        object = m_lockObject;
        synchronized (object) {
            return this.m_copiedList.stream().anyMatch(other -> other.isPrefixOf((IPath)path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needsBeingCopied(Path sourcePath, boolean addToCopyingList, boolean wait) throws OperationCanceledException, InterruptedException {
        boolean rv;
        assert (this.m_mirror);
        List<Job> jAbove = null;
        List<Job> jBelow = null;
        Iterator<Job> iterator = m_lockObject;
        synchronized (iterator) {
            boolean wascopied = this.m_copiedList.stream().anyMatch(p -> p.isPrefixOf((IPath)sourcePath));
            if (wascopied && !wait) {
                return false;
            }
            jAbove = this.m_copyingMap.entrySet().stream().filter(other -> ((Path)other.getKey()).isPrefixOf((IPath)sourcePath)).map(Map.Entry::getValue).toList();
            jBelow = this.m_copyingMap.entrySet().stream().filter(other -> sourcePath.isPrefixOf((IPath)other.getKey())).map(Map.Entry::getValue).toList();
            if (jAbove.isEmpty() && !wascopied) {
                if (addToCopyingList) {
                    this.m_copyingMap.put(sourcePath, this);
                }
                rv = true;
            } else {
                rv = false;
            }
        }
        if (wait) {
            for (Job j : jAbove) {
                j.join(0L, this.m_monitor);
            }
            for (Job j : jBelow) {
                j.join(0L, this.m_monitor);
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkWasCopied(Path sourcePath) {
        assert (this.m_mirror);
        Object object = m_lockObject;
        synchronized (object) {
            return this.m_copiedList.stream().anyMatch(p -> p.isPrefixOf((IPath)sourcePath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySuccess(Path sourcePath) {
        assert (this.m_mirror);
        Object object = m_lockObject;
        synchronized (object) {
            Job j = this.m_copyingMap.remove(sourcePath);
            assert (j == this) : "Sychronisation is broken";
            this.m_copiedList.add(sourcePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFailed(Path sourcePath) {
        assert (this.m_mirror);
        Object object = m_lockObject;
        synchronized (object) {
            Job j = this.m_copyingMap.remove(sourcePath);
            assert (j == this) : "Sychronisation is broken";
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.m_monitor = monitor;
        if (this.m_mirror) {
            return this.runMirror();
        }
        return this.runCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus runMirror() {
        Path currentVolume = null;
        HashSet<SymLink> symlinkBacklog = new HashSet<SymLink>();
        try {
            this.initmirror();
            HashMap<Path, Path> filtered_volumes = new HashMap<Path, Path>();
            for (Map.Entry<Path, Path> p : this.m_pathsToCopy.entrySet()) {
                if (!this.checkIfAlreadyCopied(p.getKey())) {
                    filtered_volumes.put(p.getKey(), p.getValue());
                    continue;
                }
                this.m_monitor.worked(1);
            }
            this.m_pathsToCopy = filtered_volumes;
        }
        catch (OperationCanceledException e) {
            return Status.CANCEL_STATUS;
        }
        catch (Exception e) {
            Activator.logErrorMessage("Failed to initialize mirror", e);
            return Status.error((String)"Failed to initialize", (Throwable)e);
        }
        if (this.m_pathsToCopy.isEmpty()) {
            this.m_monitor.done();
            return Status.OK_STATUS;
        }
        if (this.m_image != null) {
            this.m_monitor.beginTask(JobMessages.getFormattedString("CopyFromDockerJob.title.copyImage", this.m_image), this.m_pathsToCopy.size() + 2);
        } else {
            this.m_monitor.beginTask(JobMessages.getFormattedString("CopyFromDockerJob.title.copyContainer", this.m_image), this.m_pathsToCopy.size() + 2);
        }
        try (CloseableContainer container = this.m_containerId == null ? new CloseableContainer((IDockerConnection)this.m_connection, this.m_image) : null;
             Closeable dcToken = this.m_connection.getOperationToken();){
            if (container != null) {
                this.m_containerId = container.containerId;
                container.start();
            }
            for (Map.Entry<Path, Path> volume : this.m_pathsToCopy.entrySet()) {
                InputStream in;
                Path realDir;
                Path srcdir = volume.getKey();
                Path hostDir = volume.getValue();
                currentVolume = srcdir;
                this.m_monitor.worked(1);
                this.m_monitor.subTask(JobMessages.getFormattedString("CopyFromDockerJob.title.copyPath", srcdir.toString()));
                if (this.m_monitor.isCanceled()) {
                    this.m_monitor.done();
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                if (!this.needsBeingCopied(srcdir, true, false) || (realDir = this.mkdirSyms(this.m_containerId, srcdir, hostDir)) == null) continue;
                if (!srcdir.equals((Object)realDir)) {
                    this.copySuccess(srcdir);
                    srcdir = realDir;
                    if (!this.needsBeingCopied(srcdir, true, false)) continue;
                }
                if (this.copyTar(srcdir, hostDir, in = this.m_connection.copyContainer(dcToken, this.m_containerId, srcdir.toString()), symlinkBacklog, this.m_monitor)) {
                    this.copySuccess(srcdir);
                    continue;
                }
                this.copyFailed(srcdir);
            }
            for (SymLink sl : symlinkBacklog) {
                block43: {
                    if (this.needsBeingCopied(sl.m_targetAbs, false, true)) {
                        Path get = sl.m_targetAbs;
                        if (!sl.m_isDirectory) {
                            get = (Path)get.removeLastSegments(1);
                        }
                        HashSet<Path> dir = new HashSet<Path>();
                        dir.add(get);
                        CopyFromDockerJob job = new CopyFromDockerJob((IDockerConnection)this.m_connection, CopyType.ContainerMirror, this.m_containerId, dir, this.m_targetfolder);
                        job.schedule();
                        try {
                            job.join(0L, this.m_monitor);
                            if (!job.getResult().isOK()) {
                                Activator.logWarningMessage(JobMessages.getFormattedString("CopyFromDockerJob.create.failed.symlink.get", ((Object)dir).toString()));
                            }
                            break block43;
                        }
                        catch (Exception e) {
                            Activator.logErrorMessage(JobMessages.getFormattedString("CopyFromDockerJob.create.failed.symlink.get", ((Object)dir).toString()), e);
                        }
                        continue;
                    }
                }
                if (sl.create()) continue;
                Activator.logWarningMessage(JobMessages.getFormattedString("CopyFromDockerJob.docker.failed.get", sl.m_targetAbs.toString()));
            }
            this.saveMirrorState();
        }
        catch (OperationCanceledException e) {
            this.copyFailed(currentVolume);
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (InterruptedException | DockerException e) {
            Activator.logErrorMessage(MessageFormat.format("Docker Connection Error: {0}", e.getMessage()), e);
            this.copyFailed(currentVolume);
        }
        catch (Exception e) {
            Activator.logErrorMessage(JobMessages.getFormattedString("CopyFromDockerJob.copy.failed", new String[]{currentVolume.toString(), this.m_image}), e);
            this.copyFailed(currentVolume);
        }
        finally {
            this.m_monitor.done();
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus runCopy() {
        Path currentVolume = null;
        if (this.m_image != null) {
            this.m_monitor.beginTask(JobMessages.getFormattedString("CopyFromDockerJob.title.copyImage", this.m_image), this.m_pathsToCopy.size() + 2);
        } else {
            this.m_monitor.beginTask(JobMessages.getFormattedString("CopyFromDockerJob.title.copyContainer", this.m_image), this.m_pathsToCopy.size() + 2);
        }
        try (CloseableContainer container = this.m_containerId == null ? new CloseableContainer((IDockerConnection)this.m_connection, this.m_image) : null;
             Closeable dcToken = this.m_connection.getOperationToken();){
            if (container != null) {
                this.m_containerId = container.containerId;
                container.start();
            }
            for (Map.Entry<Path, Path> pathToCopy : this.m_pathsToCopy.entrySet()) {
                Path srcdir = pathToCopy.getKey();
                Path hostDir = pathToCopy.getValue();
                currentVolume = srcdir;
                this.m_monitor.worked(1);
                this.copyFolderFromContainer(dcToken, srcdir, (Path)hostDir.append(srcdir.lastSegment()), 0);
            }
        }
        catch (OperationCanceledException e) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (InterruptedException | DockerException e) {
            Activator.logErrorMessage(MessageFormat.format("Docker Connection Error: {0}", e.getMessage()), e);
        }
        catch (Exception e) {
            Activator.logErrorMessage(JobMessages.getFormattedString("CopyFromDockerJob.copy.failed", new String[]{currentVolume.toString(), this.m_image}), e);
        }
        finally {
            this.m_monitor.done();
        }
        return Status.OK_STATUS;
    }

    private void copyFolderFromContainer(Closeable dcToken, Path srcdir, Path hostDir, int linkdepth) throws DockerException, InterruptedException, IOException {
        assert (!this.m_mirror);
        if (this.m_monitor.isCanceled()) {
            return;
        }
        this.m_monitor.subTask(JobMessages.getFormattedString("CopyFromDockerJob.title.copyPath", srcdir.toString()));
        HashSet<SymLink> symlinkBacklog = new HashSet<SymLink>();
        try (InputStream in = this.m_connection.copyContainer(dcToken, this.m_containerId, srcdir.toString());){
            this.copyTar(srcdir, hostDir, in, symlinkBacklog, this.m_monitor);
        }
        for (SymLink sl : symlinkBacklog) {
            if (!sl.targetInBase()) {
                if (linkdepth < 20) {
                    this.copyFolderFromContainer(dcToken, sl.m_targetAbs, sl.hostPath(), linkdepth + 1);
                    continue;
                }
                Activator.logWarningMessage(JobMessages.getFormattedString("CopyFromDockerJob.link.depth", new String[]{"20", sl.m_filename.toString()}));
                continue;
            }
            sl.create();
        }
    }

    public static enum CopyType {
        Image,
        Container,
        ImageMirror,
        ContainerMirror;

    }

    private final class SymLink {
        public final Path m_filename;
        public final Path m_targetRel;
        public final Path m_targetAbs;
        public final boolean m_isAbs;
        public final Path m_basePath;
        public final Path m_hostBasePath;
        public final boolean m_isDirectory;

        public SymLink(Path filename, Path target, Path hostBasePath, boolean isDirectory) {
            this.m_basePath = null;
            this.m_filename = filename;
            this.m_targetRel = target;
            this.m_targetAbs = target;
            this.m_isAbs = true;
            this.m_hostBasePath = hostBasePath;
            this.m_isDirectory = isDirectory;
        }

        public SymLink(Path filename, Path basePath, Path hostFolder, TarArchiveEntry te) {
            assert (te.isSymbolicLink() || te.isLink()) : "This must only be called with symbolic links";
            this.m_isDirectory = te.isDirectory();
            this.m_basePath = basePath;
            this.m_filename = filename;
            this.m_hostBasePath = hostFolder;
            if (te.isLink()) {
                this.m_targetAbs = this.m_targetRel = (Path)basePath.append(new Path(te.getLinkName()).removeFirstSegments(1));
                this.m_isAbs = true;
                return;
            }
            Path dltf = this.m_targetRel = new Path(te.getLinkName());
            this.m_isAbs = dltf.isAbsolute();
            if (!this.m_isAbs) {
                dltf = basePath;
                dltf = dltf.append(new Path(te.getName()).removeFirstSegments(1));
                dltf = dltf.removeLastSegments(1);
                dltf = dltf.append(te.getLinkName());
            }
            this.m_targetAbs = dltf;
        }

        public Path hostPath() {
            return CopyFromDockerJob.this.toHost((IPath)this.m_filename, this.m_basePath, this.m_hostBasePath);
        }

        public Path hostTarget() {
            return CopyFromDockerJob.this.toHost((IPath)this.m_targetAbs, this.m_basePath, this.m_hostBasePath);
        }

        public boolean targetInBase() {
            return CopyFromDockerJob.this.isInCopyPath((IPath)this.m_targetAbs, this.m_basePath);
        }

        public boolean targetExists() {
            return this.hostTarget().toFile().exists();
        }

        public boolean create() throws IOException {
            if (!this.targetExists()) {
                return false;
            }
            try {
                if (this.m_isAbs) {
                    Files.createSymbolicLink(this.hostPath().toFile().toPath(), this.hostTarget().toFile().toPath(), new FileAttribute[0]);
                } else {
                    Files.createSymbolicLink(this.hostPath().toFile().toPath(), this.m_targetRel.toFile().toPath(), new FileAttribute[0]);
                }
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (FileSystemException e) {
                Object msg = JobMessages.getFormattedString("CopyFromDockerJob.create.failed.symlink", this.m_filename.toFile().getAbsolutePath());
                if (Platform.getOS().equals("win32")) {
                    msg = (String)msg + "\n";
                    msg = (String)msg + JobMessages.getString("CopyFromDockerJob.symlink.windows.permissions");
                }
                Activator.logErrorMessage((String)msg, e);
            }
            return true;
        }
    }

    private static class BlockingInputStream
    extends InputStream {
        private InputStream in;

        public BlockingInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }
    }
}

