/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMOperation;
import org.eclipse.m2m.atl.engine.vm.Debugger;
import org.eclipse.m2m.atl.engine.vm.ExecEnv;
import org.eclipse.m2m.atl.engine.vm.Operation;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMEnumLiteral;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModule;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclUndefined;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMReal;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMTupleType;

public class ASMExecEnv
extends ExecEnv {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private boolean cacheAttributeHelperResults;
    private ASMModule asm;
    private Map typeOperations;
    private Map vmTypeOperations;
    private Map attributeInitializers;
    private Map helperValuesByElement;

    public ASMExecEnv(ASMModule asm, Debugger debugger) {
        this(asm, debugger, true);
    }

    public ASMExecEnv(ASMModule asm, Debugger debugger, boolean cacheAttributeHelperResults) {
        super(debugger);
        this.asm = asm;
        this.globalVariables.put(asm.getName(), asm);
        this.typeOperations = new HashMap();
        this.attributeInitializers = new HashMap();
        this.helperValuesByElement = new HashMap();
        this.vmTypeOperations = ASMOclType.getVMOperations();
        this.cacheAttributeHelperResults = cacheAttributeHelperResults;
    }

    public ASMModule getASMModule() {
        return this.asm;
    }

    public void registerOperations(ASM asm) {
        for (ASMOperation op : asm.getOperations()) {
            String signature = op.getContextSignature();
            if (signature.matches("^(Q|G|C|E|O|N).*$")) {
                logger.warning("Unsupported registration: " + signature);
                continue;
            }
            try {
                ASMOclType type = this.parseType(new StringCharacterIterator(signature));
                this.registerOperation(type, op);
                op.setContextType(type);
            }
            catch (SignatureParsingException spe) {
                logger.log(Level.SEVERE, spe.getLocalizedMessage(), spe);
            }
        }
    }

    private String readUntil(CharacterIterator ci, char c) throws SignatureParsingException {
        StringBuffer ret = new StringBuffer();
        while (ci.current() != c) {
            ret.append(ci.current());
            ci.next();
        }
        this.read(ci, c);
        return ret.toString();
    }

    private void read(CharacterIterator ci, char c) throws SignatureParsingException {
        if (ci.current() != c) {
            throw new SignatureParsingException("Expected '" + c + "', found '" + ci.current() + "' at position " + ci.getIndex() + ".");
        }
        ci.next();
    }

    private ASMOclType parseType(CharacterIterator ci) throws SignatureParsingException {
        ASMOclType ret = this.parseTypeInternal(ci);
        if (ci.next() != '\uffff') {
            throw new SignatureParsingException("End of type signature expected at position " + ci.getIndex() + ".");
        }
        return ret;
    }

    private ASMOclType parseTypeInternal(CharacterIterator ci) throws SignatureParsingException {
        ASMOclType ret = null;
        switch (ci.current()) {
            case 'C': 
            case 'E': 
            case 'G': 
            case 'N': 
            case 'O': 
            case 'Q': {
                ci.next();
                this.parseTypeInternal(ci);
                break;
            }
            case 'T': {
                ci.next();
                HashMap<String, ASMOclType> attrs = new HashMap<String, ASMOclType>();
                while (ci.current() != ';') {
                    this.parseTypeInternal(ci);
                    String attrName = this.readUntil(ci, ';');
                    attrs.put(attrName, ASMOclAny.myType);
                }
                ret = new ASMTupleType(attrs);
                break;
            }
            case 'M': {
                ci.next();
                String mname = this.readUntil(ci, '!');
                String name = this.readUntil(ci, ';');
                ASMModel model = this.getModel(mname);
                if (model != null) {
                    ASMModelElement ame = model.findModelElement(name);
                    if (ame == null) {
                        throw new SignatureParsingException("ERROR: could not find model element " + name + " from " + mname);
                    }
                    ret = ame;
                    break;
                }
                logger.warning("could not find model " + mname + ".");
                break;
            }
            case 'A': {
                ret = ASMModule.myType;
                ci.next();
                break;
            }
            case 'J': {
                ret = ASMOclAny.myType;
                ci.next();
                break;
            }
            case 'V': {
                ret = ASMOclUndefined.myType;
                ci.next();
                break;
            }
            case 'I': {
                ret = ASMInteger.myType;
                ci.next();
                break;
            }
            case 'B': {
                ret = ASMBoolean.myType;
                ci.next();
                break;
            }
            case 'S': {
                ret = ASMString.myType;
                ci.next();
                break;
            }
            case 'Z': {
                ret = ASMEnumLiteral.myType;
                ci.next();
                break;
            }
            case 'D': {
                ret = ASMReal.myType;
                ci.next();
                break;
            }
            case 'L': {
                ret = ASMModel.myType;
                ci.next();
                break;
            }
            case '\uffff': {
                throw new SignatureParsingException("End of type signature unexpected at position " + ci.getIndex() + ".");
            }
            default: {
                throw new SignatureParsingException("Unknown type code : " + ci + ".");
            }
        }
        return ret;
    }

    private void registerOperation(ASMOclType type, Operation oper) {
        this.getOperations(type, true).put(oper.getName(), oper);
    }

    private Map getOperations(ASMOclType type, boolean createIfMissing) {
        HashMap ret = (HashMap)this.typeOperations.get(type);
        if (ret == null) {
            Map vmops = this.getVMOperations(type);
            if (createIfMissing || vmops != null && !vmops.isEmpty()) {
                ret = new HashMap();
                this.typeOperations.put(type, ret);
                if (vmops != null) {
                    ret.putAll(vmops);
                }
            }
        }
        return ret;
    }

    private Map getVMOperations(ASMOclType type) {
        return (Map)this.vmTypeOperations.get(type);
    }

    public Collection getOperations(ASMOclType type) {
        Collection ret = null;
        ret = this.getOperations(type, true).values();
        return ret;
    }

    public Operation getOperation(ASMOclType type, String name) {
        Operation ret = null;
        Map map = this.getOperations(type, false);
        if (map != null) {
            ret = (Operation)map.get(name);
        }
        if (ret == null) {
            Iterator i = type.getSupertypes().iterator();
            while (i.hasNext() && ret == null) {
                ASMOclType st = (ASMOclType)i.next();
                ret = this.getOperation(st, name);
            }
        }
        return ret;
    }

    public void registerAttributeHelper(ASMOclType type, String name, Operation oper) {
        this.getAttributeInitializers(type, true).put(name, oper);
    }

    public Operation getAttributeInitializer(ASMOclType type, String name) {
        Operation ret = null;
        Map map = this.getAttributeInitializers(type, false);
        if (map != null) {
            ret = (Operation)map.get(name);
        }
        if (ret == null) {
            Iterator i = type.getSupertypes().iterator();
            while (i.hasNext() && ret == null) {
                ASMOclType st = (ASMOclType)i.next();
                ret = this.getAttributeInitializer(st, name);
            }
        }
        return ret;
    }

    private Map getAttributeInitializers(ASMOclType type, boolean createIfMissing) {
        HashMap ret = (HashMap)this.attributeInitializers.get(type);
        if (createIfMissing && ret == null) {
            ret = new HashMap();
            this.attributeInitializers.put(type, ret);
        }
        return ret;
    }

    private Map getHelperValues(ASMOclAny element) {
        HashMap ret = (HashMap)this.helperValuesByElement.get(element);
        if (ret == null) {
            ret = new HashMap();
            this.helperValuesByElement.put(element, ret);
        }
        return ret;
    }

    public ASMOclAny getHelperValue(StackFrame frame, ASMOclAny element, String name) {
        Map helperValues = this.getHelperValues(element);
        ASMOclAny ret = (ASMOclAny)helperValues.get(name);
        if (ret == null) {
            ASMOperation o = (ASMOperation)this.getAttributeInitializer(element.getType(), name);
            ArrayList<ASMOclAny> args = new ArrayList<ASMOclAny>();
            args.add(element);
            ret = o.exec(frame.enterFrame(o, args));
            if (this.cacheAttributeHelperResults) {
                helperValues.put(name, ret);
            }
        }
        return ret;
    }

    private class SignatureParsingException
    extends Exception {
        private static final long serialVersionUID = -1184477079748763555L;

        public SignatureParsingException(String msg) {
            super(msg);
        }
    }
}

