/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class NewRepresentationAction
extends BaseSelectionListenerAction {
    private EObject selectedEObject;
    protected RepresentationDescription description;
    protected Session session;
    protected boolean forceDefaultName;
    protected boolean openRepresentation;
    protected final Collection<Layer> extraLayers;
    private Collection<FilterDescription> extraFilters;

    public NewRepresentationAction(RepresentationDescription description, EObject selectedEObject, Session session) {
        this(description, selectedEObject, session, false, true);
    }

    public NewRepresentationAction(RepresentationDescription description, EObject selectedEObject, Session session, boolean forceDefaultName, boolean openRepresentation) {
        this(description, selectedEObject, session, forceDefaultName, openRepresentation, Collections.emptyList(), Collections.emptyList());
    }

    public NewRepresentationAction(RepresentationDescription description, EObject selectedEObject, Session session, boolean forceDefaultName, boolean openRepresentation, Collection<Layer> extraLayers, Collection<FilterDescription> extraFilters) {
        super(description.getName());
        this.selectedEObject = selectedEObject;
        this.description = description;
        this.session = session;
        this.forceDefaultName = forceDefaultName;
        this.openRepresentation = openRepresentation;
        this.extraLayers = extraLayers;
        this.extraFilters = extraFilters;
    }

    public void run() {
        String defaultName = this.computeDefaultName(this.selectedEObject, this.description);
        if (!this.forceDefaultName) {
            String label = MessageTranslator.INSTANCE.getMessage((EObject)this.description, new IdentifiedElementQuery((IdentifiedElement)this.description).getLabel());
            if (label == null || label.isEmpty()) {
                label = this.description.getName();
            }
            String dialogTitle = "New " + label;
            String dialogMessage = "Name:";
            Shell activeShell = Display.getDefault().getActiveShell();
            InputDialog representationNameDlg = new InputDialog(activeShell, dialogTitle, dialogMessage, defaultName, null);
            if (representationNameDlg.open() == 0) {
                defaultName = representationNameDlg.getValue();
            } else {
                throw new OperationCanceledException();
            }
        }
        NewRepresentationCommand command = new NewRepresentationCommand(defaultName, this.selectedEObject, this.description, this.session, this.extraLayers, this.extraFilters);
        TransactionUtil.getEditingDomain((EObject)this.selectedEObject).getCommandStack().execute((Command)command);
        if (command.getRepresentation() != null) {
            SessionManager.INSTANCE.notifyRepresentationCreated(this.session);
            if (this.openRepresentation) {
                DialectUIManager.INSTANCE.openEditor(this.session, command.getRepresentation(), (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    protected String computeDefaultName(EObject eObject, RepresentationDescription repDescription) {
        IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)eObject);
        String newName = "";
        String titleExpression = repDescription.getTitleExpression();
        if (!StringUtil.isEmpty((String)titleExpression)) {
            try {
                newName = interpreter.evaluateString(eObject, titleExpression);
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)this.description, (EStructuralFeature)DescriptionPackage.eINSTANCE.getRepresentationDescription_TitleExpression(), (Throwable)e);
            }
        } else {
            newName = !StringUtil.isEmpty((String)repDescription.getLabel()) ? "New " + MessageTranslator.INSTANCE.getMessage((EObject)this.description, new IdentifiedElementQuery((IdentifiedElement)repDescription).getLabel()) : "New " + repDescription.getName();
        }
        return newName;
    }

    private class NewRepresentationCommand
    extends RecordingCommand {
        private String newName;
        private DRepresentation representation;
        private EObject eObject;
        private RepresentationDescription repDescription;
        private Session currentSession;
        private Collection<Layer> extraLayers;
        private Collection<FilterDescription> extraFilters;

        public NewRepresentationCommand(String newName, EObject eObject, RepresentationDescription repDescription, Session session, Collection<Layer> extraLayers, Collection<FilterDescription> extraFilters) {
            super(TransactionUtil.getEditingDomain((EObject)eObject));
            this.newName = newName;
            this.eObject = eObject;
            this.repDescription = repDescription;
            this.currentSession = session;
            this.extraLayers = extraLayers;
            this.extraFilters = extraFilters;
        }

        public void commandInterrupted() {
            this.commandRolledBack();
        }

        public void commandRolledBack() {
            this.representation = null;
        }

        public DRepresentation getRepresentation() {
            return this.representation;
        }

        public void doExecute() {
            NullProgressMonitor monitor = new NullProgressMonitor();
            this.representation = DialectManager.INSTANCE.createRepresentation(this.newName, this.eObject, this.repDescription, this.currentSession, (IProgressMonitor)monitor);
            if (this.representation instanceof DDiagram) {
                ((DDiagram)this.representation).getActivatedLayers().addAll(this.extraLayers);
                ((DDiagram)this.representation).getActivatedFilters().addAll(this.extraFilters);
            }
        }
    }
}

