/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.StringHelper;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions.Messages;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.dialect.command.DeleteRepresentationCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class DeleteRepresentationAction
extends BaseSelectionListenerAction {
    public DeleteRepresentationAction() {
        super("Delete");
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
    }

    public void run() {
        Set<DRepresentation> selectedRepresentations = this.getRepresentationsFromSelection();
        if (!selectedRepresentations.isEmpty()) {
            TransactionalEditingDomain domain;
            int deletedDiagramCount = selectedRepresentations.size();
            String contextualMessage = null;
            contextualMessage = deletedDiagramCount == 1 ? StringHelper.formatMessage(" diagram?", new String[]{selectedRepresentations.iterator().next().getName()}) : StringHelper.formatMessage(" these diagrams ?", new String[]{String.valueOf(deletedDiagramCount)});
            if (MessageDialog.openConfirm(null, (String)Messages.DeleteRepresentationAction_2, (String)(String.valueOf(Messages.DeleteRepresentationAction_3) + contextualMessage)) && (domain = TransactionUtil.getEditingDomain((EObject)((EObject)this.getRepresentationsFromSelection().iterator().next()))) != null) {
                SessionManager.INSTANCE.getSessions();
                Session session = SessionManager.INSTANCE.getSession(((DSemanticDecorator)this.getRepresentationsFromSelection().iterator().next()).getTarget());
                DeleteRepresentationCommand command = new DeleteRepresentationCommand(session, selectedRepresentations);
                domain.getCommandStack().execute((Command)command);
            }
        }
    }

    private Set<DRepresentation> getRepresentationsFromSelection() {
        HashSet<DRepresentation> representations = new HashSet<DRepresentation>();
        IStructuredSelection structuredSelection = this.getStructuredSelection();
        for (Object selectedObject : structuredSelection) {
            if (!(selectedObject instanceof DRepresentation) || !(selectedObject instanceof DSemanticDecorator)) continue;
            DRepresentation selectedRepresentation = (DRepresentation)selectedObject;
            representations.add(selectedRepresentation);
        }
        return representations;
    }
}

