/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.editor.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.actions.OpenActivityExplorerAction2;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.ActivityExplorerEditor;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.input.ActivityExplorerEditorInput;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.CommonActivityExplorerPage;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.Messages;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.FormHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.HTMLHelper;
import org.eclipse.amalgam.explorer.activity.ui.internal.actions.util.FormTextPageLinkAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.ScrolledFormText;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class OverviewActivityExplorerPage
extends CommonActivityExplorerPage {
    private static final String PAGE_ID = "overview";
    private static final String PAGE_TITLE = Messages.OverviewActivityExplorerPage_1;
    private static Map<String, String> __hrefImageMappings = new HashMap<String, String>();
    private static Map<String, String> __hoverHrefImageMappings = new HashMap<String, String>();
    private IMenuListener2 listener = new IMenuListener2(){

        public void menuAboutToShow(IMenuManager manager) {
            Session current = ((ActivityExplorerEditorInput)OverviewActivityExplorerPage.this.getEditorInput()).getSession();
            Form formWidget = OverviewActivityExplorerPage.this.getManagedForm().getForm().getForm();
            manager.removeAll();
            for (Session session : SessionManager.INSTANCE.getSessions()) {
                if (session.equals(current)) continue;
                formWidget.getMenuManager().add((IAction)new OpenActivityExplorerAction2(session));
            }
        }

        public void menuAboutToHide(IMenuManager manager) {
        }
    };

    public OverviewActivityExplorerPage() {
        super(null, PAGE_ID, "");
    }

    public OverviewActivityExplorerPage(FormEditor editor) {
        super(editor, PAGE_ID, PAGE_TITLE);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.setText(this.getHeaderTitle());
        TableWrapLayout layout = new TableWrapLayout();
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.topMargin = 20;
        layout.bottomMargin = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 2;
        Composite body = form.getBody();
        body.setLayout((Layout)layout);
        Form formWidget = managedForm.getForm().getForm();
        ((ActivityExplorerEditorInput)this.getEditorInput()).getSession();
        formWidget.getMenuManager().add((IContributionItem)new Separator("empty-list"));
        formWidget.getMenuManager().addMenuListener((IMenuListener)this.listener);
        for (CommonActivityExplorerPage page : this.getContributedPages()) {
            this.createSubForm(managedForm, body, page);
        }
        form.reflow(true);
    }

    public void dispose() {
        if (this.getManagedForm() != null) {
            this.getManagedForm().getForm().getForm().getMenuManager().removeMenuListener((IMenuListener)this.listener);
        }
        super.dispose();
    }

    protected String getHeaderTitle() {
        return String.valueOf(Messages.OverviewActivityExplorerPage_2) + ((ActivityExplorerEditorInput)this.getEditorInput()).getName();
    }

    public Composite createSubForm(IManagedForm managedForm, Composite body, CommonActivityExplorerPage page) {
        Composite composite = body;
        FormText richText = null;
        if (page.isVisible()) {
            String txt = HTMLHelper.imageLinkForm((IFormPage)page);
            if (txt != null && !txt.isEmpty()) {
                richText = FormHelper.createRichText(managedForm.getToolkit(), composite, txt, (IHyperlinkListener)new OverviewPageLinkAdapter((FormEditor)this.getEditor()));
                richText.setHyperlinkSettings((HyperlinkSettings)managedForm.getToolkit().getHyperlinkGroup());
                richText.setImage(page.getId(), page.getOverviewImageOff());
                richText.marginHeight = 0;
                richText.marginWidth = 0;
                TableWrapData layoutData = new TableWrapData();
                layoutData.align = 4;
                layoutData.valign = 32;
                richText.setLayoutData((Object)layoutData);
                txt = HTMLHelper.overviewDescForm(page);
            }
            if (txt != null && !txt.isEmpty()) {
                ScrolledFormText descriptionForm = new ScrolledFormText(composite, true);
                descriptionForm.setBackground(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 255, 255, 255));
                descriptionForm.setText(txt);
                descriptionForm.setMinWidth(600);
                TableWrapData layoutData2 = new TableWrapData();
                layoutData2.maxHeight = 100;
                layoutData2.maxWidth = 600;
                layoutData2.align = 4;
                layoutData2.valign = 32;
                descriptionForm.setLayoutData((Object)layoutData2);
                descriptionForm.pack(false);
            }
            richText.marginHeight = 0;
            richText.marginWidth = 40;
        }
        return composite;
    }

    @Override
    public boolean isVisible() {
        boolean result = true;
        if (this.predicate != null) {
            result &= this.predicate.isOk();
        }
        return result;
    }

    private List<CommonActivityExplorerPage> getContributedPages() {
        ArrayList<CommonActivityExplorerPage> contributed = new ArrayList<CommonActivityExplorerPage>();
        for (IFormPage iFormPage : ((ActivityExplorerEditor)this.getEditor()).getPages()) {
            CommonActivityExplorerPage ap;
            if (!(iFormPage instanceof CommonActivityExplorerPage) || !(ap = (CommonActivityExplorerPage)iFormPage).contributeToOverview()) continue;
            contributed.add(ap);
            __hrefImageMappings.put(ap.getId(), ap.getOverViewImageOffPath());
            __hoverHrefImageMappings.put(ap.getId(), ap.getOverViewImageOnPath());
        }
        return contributed;
    }

    class OverviewPageLinkAdapter
    extends FormTextPageLinkAdapter {
        private OverviewPageLinkAdapter(FormEditor editor) {
            super(editor);
        }

        @Override
        public void linkEntered(HyperlinkEvent hlevent) {
            super.linkEntered(hlevent);
            this.updateImage(hlevent, __hoverHrefImageMappings);
        }

        @Override
        public void linkExited(HyperlinkEvent hlevent) {
            super.linkExited(hlevent);
            this.updateImage(hlevent, __hrefImageMappings);
        }

        private void updateImage(HyperlinkEvent hlevent, Map<String, String> imageMappings) {
            String pageId = (String)hlevent.getHref();
            String image = imageMappings.get(pageId);
            if (image != null) {
                ((FormText)hlevent.widget).setImage(pageId, ActivityExplorerActivator.getDefault().getImage(image));
            }
        }
    }
}

