/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree;

import org.eclipse.emf.compare.rcp.ui.mergeviewer.MergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.StructuredMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.accessor.IEObjectAccessor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class TreeMergeViewer
extends StructuredMergeViewer {
    private IEObjectAccessor fInput;
    private TreeViewer fTreeViewer;

    public TreeMergeViewer(Composite parent, MergeViewer.MergeViewerSide side) {
        super(parent, side);
    }

    protected Control createControl(Composite parent) {
        this.fTreeViewer = new TreeViewer(parent);
        return this.fTreeViewer.getControl();
    }

    protected TreeViewer getStructuredViewer() {
        return this.fTreeViewer;
    }

    public void setInput(Object input) {
        if (input instanceof IEObjectAccessor) {
            this.fInput = (IEObjectAccessor)input;
            EObject eObject = ((IEObjectAccessor)input).getEObject();
            Object viewerInput = TreeMergeViewer.doGetInput(eObject);
            this.getStructuredViewer().setInput(viewerInput);
            Object selection = viewerInput;
            if (eObject != null) {
                if (eObject.eContainer() == viewerInput) {
                    selection = eObject;
                } else if (eObject.eContainer() == null) {
                    selection = eObject;
                }
            }
            this.getStructuredViewer().setSelection((ISelection)new StructuredSelection(selection));
            this.getStructuredViewer().expandToLevel(selection, 1);
        } else {
            this.getStructuredViewer().setInput(null);
        }
    }

    public Object getInput() {
        return this.fInput;
    }

    private static Object doGetInput(EObject eObject) {
        Object input = null;
        if (eObject != null) {
            input = eObject.eContainer() != null ? eObject.eContainer() : eObject.eResource();
        }
        return input;
    }

    public void refresh() {
        this.fTreeViewer.refresh();
    }
}

