/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.mergeviewer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareColorImpl
implements RemovalListener<RGB, Color>,
ICompareColor {
    private static final int MAX_CACHE_SIZE = 16;
    private static final int MED_RGB_COMPONENT = 128;
    private static final int MAX_RGB_COMPONENT = 255;
    private static final double INTERPOLATION_SCALE_1 = 0.6;
    private static final double INTERPOLATION_SCALE_2 = 0.97;
    public static final String INCOMING_COLOR = "INCOMING_COLOR";
    public static final String OUTGOING_COLOR = "OUTGOING_COLOR";
    public static final String CONFLICTING_COLOR = "CONFLICTING_COLOR";
    public static final String RESOLVED_COLOR = "RESOLVED_COLOR";
    private RGB fIncomingSelected;
    private RGB fIncoming;
    private RGB fIncomingFill;
    private RGB fConflictSelected;
    private RGB fConflict;
    private RGB fConflictFill;
    private RGB fOutgoingSelected;
    private RGB fOutgoing;
    private RGB fOutgoingFill;
    private RGB fResolved;
    private final Cache<RGB, Color> fColors;
    private final IPreferenceStore fPreferenceStore;
    private final IPropertyChangeListener fPreferenceChangeListener;
    private final boolean fLeftIsLocal;
    private Display fDisplay;

    public CompareColorImpl(Display display, boolean leftIsLocal, IPreferenceStore preferenceStore) {
        this.fDisplay = display;
        this.fPreferenceStore = preferenceStore;
        this.fColors = CacheBuilder.newBuilder().maximumSize(16).removalListener((RemovalListener)this).build((CacheLoader)new CacheLoader<RGB, Color>(){

            public Color load(RGB rgb) throws Exception {
                return new Color((Device)CompareColorImpl.this.fDisplay, rgb);
            }
        });
        this.fPreferenceChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                CompareColorImpl.this.handlePropertyChangeEvent(event);
            }
        };
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener(this.fPreferenceChangeListener);
        }
        this.fLeftIsLocal = leftIsLocal;
        this.updateColors();
    }

    public void onRemoval(RemovalNotification<RGB, Color> notification) {
        Color color = (Color)notification.getValue();
        if (!color.isDisposed()) {
            color.dispose();
        }
    }

    protected final void handlePropertyChangeEvent(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals(INCOMING_COLOR) || key.equals(OUTGOING_COLOR) || key.equals(CONFLICTING_COLOR) || key.equals(RESOLVED_COLOR)) {
            this.updateColors();
        }
    }

    private Color getColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        Color c = (Color)this.fColors.getUnchecked((Object)rgb);
        return c;
    }

    @Override
    public Color getFillColor(Diff diff, boolean isThreeWay, boolean isIgnoreAncestor, boolean selected) {
        return this.getColor(this.getFillRGB(diff, isThreeWay, isIgnoreAncestor, selected));
    }

    private RGB getFillRGB(Diff diff, boolean isThreeWay, boolean isIgnoreAncestor, boolean selected) {
        RGB selectedFill = this.getBackground();
        if (isThreeWay && !isIgnoreAncestor) {
            boolean requiredConflictForWayOfMerge = false;
            if (diff.getConflict() == null && !requiredConflictForWayOfMerge) {
                switch (diff.getSource()) {
                    case RIGHT: {
                        if (this.fLeftIsLocal) {
                            return selected ? selectedFill : this.fIncomingFill;
                        }
                        return selected ? selectedFill : this.fOutgoingFill;
                    }
                    case LEFT: {
                        if (this.fLeftIsLocal) {
                            return selected ? selectedFill : this.fOutgoingFill;
                        }
                        return selected ? selectedFill : this.fIncomingFill;
                    }
                }
            } else {
                return selected ? selectedFill : this.fConflictFill;
            }
            return selected ? selectedFill : this.fConflictFill;
        }
        return selected ? selectedFill : this.fOutgoingFill;
    }

    @Override
    public Color getStrokeColor(Diff diff, boolean isThreeWay, boolean isIgnoreAncestor, boolean selected) {
        return this.getColor(this.getStrokeRGB(diff, isThreeWay, isIgnoreAncestor, selected));
    }

    private RGB getStrokeRGB(Diff diff, boolean isThreeWay, boolean isIgnoreAncestor, boolean selected) {
        if (isThreeWay && !isIgnoreAncestor) {
            boolean requiredConflictForWayOfMerge = false;
            if (diff.getConflict() == null && !requiredConflictForWayOfMerge) {
                switch (diff.getSource()) {
                    case RIGHT: {
                        if (this.fLeftIsLocal) {
                            return selected ? this.fIncomingSelected : this.fIncoming;
                        }
                        return selected ? this.fOutgoingSelected : this.fOutgoing;
                    }
                    case LEFT: {
                        if (this.fLeftIsLocal) {
                            return selected ? this.fOutgoingSelected : this.fOutgoing;
                        }
                        return selected ? this.fIncomingSelected : this.fIncoming;
                    }
                }
            } else {
                return selected ? this.fConflictSelected : this.fConflict;
            }
            return selected ? this.fConflictSelected : this.fConflict;
        }
        return selected ? this.fOutgoingSelected : this.fOutgoing;
    }

    private RGB getBackground() {
        return this.fDisplay.getSystemColor(25).getRGB();
    }

    private void updateColors() {
        ColorRegistry registry = JFaceResources.getColorRegistry();
        RGB bg = this.getBackground();
        this.fIncomingSelected = registry.getRGB(INCOMING_COLOR);
        if (this.fIncomingSelected == null) {
            this.fIncomingSelected = new RGB(0, 0, 255);
        }
        this.fIncoming = CompareColorImpl.interpolate(this.fIncomingSelected, bg, 0.6);
        this.fIncomingFill = CompareColorImpl.interpolate(this.fIncomingSelected, bg, 0.97);
        this.fOutgoingSelected = registry.getRGB(OUTGOING_COLOR);
        if (this.fOutgoingSelected == null) {
            this.fOutgoingSelected = new RGB(0, 0, 0);
        }
        this.fOutgoing = CompareColorImpl.interpolate(this.fOutgoingSelected, bg, 0.6);
        this.fOutgoingFill = CompareColorImpl.interpolate(this.fOutgoingSelected, bg, 0.97);
        this.fConflictSelected = registry.getRGB(CONFLICTING_COLOR);
        if (this.fConflictSelected == null) {
            this.fConflictSelected = new RGB(255, 0, 0);
        }
        this.fConflict = CompareColorImpl.interpolate(this.fConflictSelected, bg, 0.6);
        this.fConflictFill = CompareColorImpl.interpolate(this.fConflictSelected, bg, 0.97);
        this.fResolved = registry.getRGB(RESOLVED_COLOR);
        if (this.fResolved == null) {
            this.fResolved = new RGB(0, 255, 0);
        }
    }

    private static RGB interpolate(RGB fg, RGB bg, double scale) {
        if (fg != null && bg != null) {
            return new RGB((int)((1.0 - scale) * (double)fg.red + scale * (double)bg.red), (int)((1.0 - scale) * (double)fg.green + scale * (double)bg.green), (int)((1.0 - scale) * (double)fg.blue + scale * (double)bg.blue));
        }
        if (fg != null) {
            return fg;
        }
        if (bg != null) {
            return bg;
        }
        return new RGB(128, 128, 128);
    }

    @Override
    public void dispose() {
        this.fColors.invalidateAll();
        this.fPreferenceStore.removePropertyChangeListener(this.fPreferenceChangeListener);
    }
}

