/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.diff;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.extension.IPostProcessor;
import org.eclipse.emf.compare.uml2.UMLDiff;
import org.eclipse.emf.compare.uml2.diff.internal.extension.DiffExtensionFactoryRegistry;
import org.eclipse.emf.compare.uml2.diff.internal.extension.IDiffExtensionFactory;

public class UMLDiffExtensionPostProcessor
implements IPostProcessor {
    private Set<IDiffExtensionFactory> uml2ExtensionFactories;

    public void postMatch(Comparison comparison, Monitor monitor) {
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
        Map<Class<? extends Diff>, IDiffExtensionFactory> mapUml2ExtensionFactories = DiffExtensionFactoryRegistry.createExtensionFactories();
        this.uml2ExtensionFactories = new HashSet<IDiffExtensionFactory>(mapUml2ExtensionFactories.values());
        for (Diff diff : comparison.getDifferences()) {
            this.applyManagedTypes(diff);
        }
        for (Diff umlDiff : comparison.getDifferences()) {
            Class classDiffElement;
            IDiffExtensionFactory diffFactory;
            if (!(umlDiff instanceof UMLDiff) || (diffFactory = mapUml2ExtensionFactories.get(classDiffElement = umlDiff.eClass().getInstanceClass())) == null) continue;
            diffFactory.fillRequiredDifferences(comparison, (UMLDiff)umlDiff);
        }
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    private void applyManagedTypes(Diff element) {
        for (IDiffExtensionFactory factory : this.uml2ExtensionFactories) {
            if (!factory.handles(element)) continue;
            Diff extension = factory.create(element);
            Match match = factory.getParentMatch(element);
            match.getDifferences().add((Object)extension);
        }
    }
}

